/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.suggestions2;

import com.google.gson.JsonObject;
import mod.vemerion.wizardstaff.Helper.Helper;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class PushBlockMagic
extends Magic {
    private static final int MAX_DISTANCE = 10;
    private Block block;

    public PushBlockMagic(MagicType<? extends PushBlockMagic> type) {
        super(type);
    }

    public PushBlockMagic setAdditionalParams(Block block) {
        this.block = block;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.block = (Block)MagicUtil.read(json, ForgeRegistries.BLOCKS, "block");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.write(json, this.block, "block");
    }

    @Override
    public void encodeAdditional(FriendlyByteBuf buffer) {
        MagicUtil.encode(buffer, this.block);
    }

    @Override
    protected void decodeAdditional(FriendlyByteBuf buffer) {
        this.block = (Block)MagicUtil.decode(buffer);
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::forwardBuildup;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::forwardShake;
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{this.block.m_49954_()};
    }

    @Override
    protected Object[] getDescrArgs() {
        return this.getNameArgs();
    }

    @Override
    public boolean magicPreventOtherUse(Level level, Player player, ItemStack staff) {
        return this.ray(level, player) != null;
    }

    @Override
    public ItemStack magicFinish(Level level, Player player, ItemStack staff) {
        if (!level.f_46443_) {
            Direction direction = Direction.m_122382_((Entity)player)[0];
            BlockPos start = this.ray(level, player);
            if (start != null) {
                BlockPos p = new BlockPos((Vec3i)start);
                BlockState state = level.m_8055_(p);
                BlockEntity tileEntity = level.m_7702_(start);
                for (int i = 0; i < 10 && level.m_46859_(p.m_142300_(direction)) && state.m_60710_((LevelReader)level, p.m_142300_(direction)); ++i) {
                    p = p.m_142300_(direction);
                }
                if (tileEntity != null) {
                    tileEntity = BlockEntity.m_155241_((BlockPos)p, (BlockState)state, (CompoundTag)tileEntity.serializeNBT());
                }
                if (p.equals((Object)start)) {
                    this.playSoundServer(level, player, ModSounds.POOF, 1.0f, this.soundPitch(player));
                } else {
                    this.playSoundServer(level, player, ModSounds.PUSH, 1.0f, this.soundPitch(player));
                    this.cost(player);
                    level.m_46597_(p, state);
                    if (tileEntity != null) {
                        level.m_46747_(start);
                        level.m_151523_(tileEntity);
                        tileEntity.m_6596_();
                    }
                    level.m_46597_(start, Blocks.f_50016_.m_49966_());
                }
            } else {
                this.playSoundServer(level, player, ModSounds.POOF, 1.0f, this.soundPitch(player));
            }
        }
        return super.magicFinish(level, player, staff);
    }

    private BlockPos ray(Level level, Player player) {
        BlockHitResult result = Helper.blockRay(level, player, 5.0f);
        if (result.m_6662_() == HitResult.Type.BLOCK && level.m_8055_(result.m_82425_()).m_60734_() == this.block) {
            return result.m_82425_();
        }
        return null;
    }
}

