/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.suggestions2;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.RegistryMatch;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public class RemoveFluidMagic
extends Magic {
    private RegistryMatch<Fluid> match;

    public RemoveFluidMagic(MagicType<?> type) {
        super(type);
    }

    public RemoveFluidMagic setAdditionalParams(RegistryMatch<Fluid> match) {
        this.match = match;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.match = RegistryMatch.read(ForgeRegistries.FLUIDS, GsonHelper.m_13930_((JsonObject)json, (String)"fluid_match"));
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        json.add("fluid_match", (JsonElement)this.match.write());
    }

    @Override
    protected void encodeAdditional(FriendlyByteBuf buffer) {
        this.match.encode(buffer);
    }

    @Override
    protected void decodeAdditional(FriendlyByteBuf buffer) {
        this.match = RegistryMatch.decode(ForgeRegistries.FLUIDS, buffer);
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::circling;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::swinging;
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{this.match.getName()};
    }

    @Override
    protected Object[] getDescrArgs() {
        return this.getNameArgs();
    }

    @Override
    public ItemStack magicFinish(Level level, Player player, ItemStack staff) {
        if (!level.f_46443_) {
            int count = 0;
            BlockPos pos = player.m_142538_();
            for (BlockPos p : BlockPos.m_121940_((BlockPos)pos.m_142082_(-2, -1, -2), (BlockPos)pos.m_142082_(2, 2, 2))) {
                BlockState blockstate = level.m_8055_(p);
                Block block = blockstate.m_60734_();
                if (!this.match.test(blockstate.m_60819_().m_76152_()) || !(block instanceof BucketPickup) || ((BucketPickup)block).m_142598_((LevelAccessor)level, p, blockstate) == ItemStack.f_41583_) continue;
                ++count;
            }
            this.cost(player, count);
            if (count > 0) {
                this.playSoundServer(level, player, ModSounds.EVAPORATE, 1.0f, this.soundPitch(player));
            }
        }
        return super.magicFinish(level, player, staff);
    }
}

