/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.suggestions2;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Vector4f;
import mod.vemerion.wizardstaff.Helper.Helper;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.Magic.RayMagic;
import mod.vemerion.wizardstaff.Magic.RegistryMatch;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.particle.MagicDustParticleData;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class TransformEntityMagic
extends RayMagic {
    private RegistryMatch<EntityType<?>> match;
    private EntityType<?> to;
    private int particleColor;
    private Vector4f particleColorComponents;

    public TransformEntityMagic(MagicType<? extends TransformEntityMagic> type) {
        super((MagicType<? extends RayMagic>)type);
    }

    public TransformEntityMagic setAdditionalParams(RegistryMatch<EntityType<?>> match, EntityType<?> to, int particleColor) {
        this.match = match;
        this.to = to;
        this.particleColor = particleColor;
        return this;
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        json.add("entity_match", (JsonElement)this.match.write());
        MagicUtil.write(json, this.to, "to");
        json.addProperty("particle_color", (Number)this.particleColor);
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.match = RegistryMatch.read(ForgeRegistries.ENTITIES, GsonHelper.m_13930_((JsonObject)json, (String)"entity_match"));
        this.to = (EntityType)MagicUtil.read(json, ForgeRegistries.ENTITIES, "to");
        this.particleColor = GsonHelper.m_13927_((JsonObject)json, (String)"particle_color");
    }

    @Override
    protected void encodeAdditional(FriendlyByteBuf buffer) {
        this.match.encode(buffer);
        MagicUtil.encode(buffer, this.to);
        buffer.writeInt(this.particleColor);
    }

    @Override
    protected void decodeAdditional(FriendlyByteBuf buffer) {
        this.match = RegistryMatch.decode(ForgeRegistries.ENTITIES, buffer);
        this.to = (EntityType)MagicUtil.decode(buffer);
        this.particleColor = buffer.readInt();
    }

    @Override
    protected Object[] getDescrArgs() {
        return new Object[]{this.match.getName(), this.to.m_20676_()};
    }

    @Override
    protected ParticleOptions generateParticle(Level level, Player player, ItemStack staff, int count) {
        if (this.particleColorComponents == null) {
            this.particleColorComponents = new Vector4f((float)Helper.red(this.particleColor) / 255.0f, (float)Helper.green(this.particleColor) / 255.0f, (float)Helper.blue(this.particleColor) / 255.0f, (float)Helper.alfa(this.particleColor) / 255.0f);
        }
        return new MagicDustParticleData(this.particleColorComponents.m_123601_(), this.particleColorComponents.m_123615_(), this.particleColorComponents.m_123616_(), this.particleColorComponents.m_123617_());
    }

    @Override
    protected void hitEntity(Level level, Player player, Entity target) {
        if (this.match.test(target.m_6095_())) {
            this.playSoundServer(level, player, ModSounds.TRANSFORM, 0.7f, this.soundPitch(player));
            if (!level.f_46443_) {
                this.cost(player);
                Entity entity = this.to.m_20615_(level);
                if (target.m_8077_()) {
                    entity.m_6593_(target.m_7770_());
                }
                entity.m_19890_(target.m_20185_(), target.m_20186_(), target.m_20189_(), target.m_146908_(), target.m_146909_());
                level.m_7967_(entity);
                target.m_146870_();
            }
        }
    }
}

