/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.swap;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.RegistryMatch;
import mod.vemerion.wizardstaff.init.ModMagics;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class ForceEntityMagic
extends Magic {
    private float force;
    private RegistryMatch<EntityType<?>> match;

    public ForceEntityMagic(MagicType<? extends ForceEntityMagic> type) {
        super(type);
    }

    public ForceEntityMagic setAdditionalParams(RegistryMatch<EntityType<?>> match, float force) {
        this.match = match;
        this.force = force;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.match = RegistryMatch.read(ForgeRegistries.ENTITIES, GsonHelper.m_13930_((JsonObject)json, (String)"entity_match"));
        this.force = GsonHelper.m_13915_((JsonObject)json, (String)"force");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        json.add("entity_match", (JsonElement)this.match.write());
        json.addProperty("force", (Number)Float.valueOf(this.force));
    }

    @Override
    public void encodeAdditional(FriendlyByteBuf buffer) {
        this.match.encode(buffer);
        buffer.writeFloat(this.force);
    }

    @Override
    protected void decodeAdditional(FriendlyByteBuf buffer) {
        this.match = RegistryMatch.decode(ForgeRegistries.ENTITIES, buffer);
        this.force = buffer.readFloat();
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{this.force >= 0.0f ? new TranslatableComponent("gui.wizardstaff." + ModMagics.FORCE_ENTITY_MAGIC.getRegistryName().m_135815_() + ".attract") : new TranslatableComponent("gui.wizardstaff." + ModMagics.FORCE_ENTITY_MAGIC.getRegistryName().m_135815_() + ".repel"), this.match.getName()};
    }

    @Override
    protected Object[] getDescrArgs() {
        return this.getNameArgs();
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::circling;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::swinging;
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Override
    public void magicTick(Level level, Player player, ItemStack staff, int count) {
        for (Entity e2 : level.m_6249_((Entity)player, player.m_142469_().m_82400_(3.0), e -> this.match.test(e.m_6095_()))) {
            Vec3 motion = player.m_20182_().m_82546_(e2.m_20182_()).m_82541_().m_82490_((double)this.force).m_82542_(1.0, 0.0, 1.0).m_82520_(0.0, e2.m_20184_().f_82480_, 0.0);
            e2.m_20256_(motion);
        }
        if (!level.f_46443_) {
            this.cost(player);
        }
        if (count % 6 == 0) {
            player.m_5496_(ModSounds.MAGNET, 1.0f, this.soundPitch(player));
        }
    }
}

