/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.swap;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.Magic.RayMagic;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.particle.MagicDustParticleData;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SwapPositionMagic
extends RayMagic {
    private Set<ResourceLocation> blacklist;
    private float range;

    public SwapPositionMagic(MagicType<? extends SwapPositionMagic> type) {
        super((MagicType<? extends RayMagic>)type);
    }

    public SwapPositionMagic setAdditionalParams(Set<ResourceLocation> blacklist, float range) {
        this.blacklist = blacklist;
        this.range = range;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.blacklist = MagicUtil.readColl(json, "blacklist", e -> new ResourceLocation(GsonHelper.m_13805_((JsonElement)e, (String)"entity name")), new HashSet());
        this.range = GsonHelper.m_13915_((JsonObject)json, (String)"range");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.writeColl(json, "blacklist", this.blacklist, r -> new JsonPrimitive(r.toString()));
        json.addProperty("range", (Number)Float.valueOf(this.range));
    }

    @Override
    protected void encodeAdditional(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.range);
    }

    @Override
    protected void decodeAdditional(FriendlyByteBuf buffer) {
        this.range = buffer.readFloat();
    }

    @Override
    protected float getRange() {
        return this.range;
    }

    @Override
    protected ParticleOptions generateParticle(Level level, Player player, ItemStack staff, int count) {
        Random rand = player.m_21187_();
        float duration = this.getUseDuration(staff);
        float progress = (duration - (float)count) / duration;
        float alfa = Math.min(1.0f, progress * 1.5f);
        return new MagicDustParticleData(0.9f + rand.nextFloat() * 0.1f, 0.9f + rand.nextFloat() * 0.1f, 0.0f, alfa);
    }

    @Override
    protected void hitEntity(Level level, Player player, Entity target) {
        if (!(target instanceof LivingEntity) || this.blacklist.contains(target.m_6095_().getRegistryName())) {
            this.playSoundServer(level, player, ModSounds.POOF, 1.0f, this.soundPitch(player));
            return;
        }
        this.cost(player);
        Vec3 start = player.m_20182_();
        player.m_6021_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        target.m_6021_(start.f_82479_, start.f_82480_, start.f_82481_);
        this.playSoundServer(level, player, ModSounds.SWAP, 1.0f, this.soundPitch(player));
    }
}

