/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.swap;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.RayMagic;
import mod.vemerion.wizardstaff.init.ModSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;

public class SwapTradeMagic
extends RayMagic {
    private Ingredient blacklist = Ingredient.f_43901_;

    public SwapTradeMagic(MagicType<? extends SwapTradeMagic> type) {
        super((MagicType<? extends RayMagic>)type);
    }

    @Override
    protected ParticleOptions generateParticle(Level level, Player player, ItemStack staff, int count) {
        return ParticleTypes.f_123748_;
    }

    public SwapTradeMagic setAdditionalParams(Ingredient blacklist) {
        this.blacklist = blacklist;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        if (GsonHelper.m_13900_((JsonObject)json, (String)"blacklist_ingredient")) {
            this.blacklist = Ingredient.m_43917_((JsonElement)json.get("blacklist_ingredient"));
        }
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        if (this.blacklist != Ingredient.f_43901_) {
            json.add("blacklist_ingredient", this.blacklist.m_43942_());
        }
    }

    @Override
    protected void hitEntity(Level level, Player player, Entity target) {
        if (!(target instanceof Villager)) {
            this.playSoundServer(level, player, ModSounds.POOF, 1.0f, this.soundPitch(player));
            return;
        }
        Villager villager = (Villager)target;
        this.cost(player);
        MerchantOffers offers = new MerchantOffers();
        for (MerchantOffer offer : villager.m_6616_()) {
            ItemStack buyFirst = offer.m_45352_();
            ItemStack buySecond = offer.m_45364_();
            ItemStack sell = offer.m_45368_();
            if (this.isBlacklisted(buyFirst) || this.isBlacklisted(buySecond) || this.isBlacklisted(sell) || !buyFirst.m_41619_() && !buySecond.m_41619_()) {
                offers.add((Object)new MerchantOffer(offer.m_45384_()));
                continue;
            }
            ItemStack selling = (buyFirst.m_41619_() ? buySecond : buyFirst).m_41777_();
            offers.add((Object)new MerchantOffer(sell.m_41777_(), ItemStack.f_41583_, selling, offer.m_45373_(), offer.m_45373_(), offer.m_45379_(), offer.m_45378_(), offer.m_45375_()));
        }
        villager.m_35476_(offers);
        this.playSoundServer(level, player, SoundEvents.f_12504_, 1.0f, this.soundPitch(player));
    }

    private boolean isBlacklisted(ItemStack stack) {
        return !stack.m_41619_() && this.blacklist.test(stack);
    }
}

