/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.capability;

import net.minecraft.core.Direction;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class Experience
implements INBTSerializable<DoubleTag> {
    public static final Capability<Experience> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<Experience>(){});
    private double exp;

    public int add(double value) {
        this.exp += value;
        int whole = (int)this.exp;
        this.exp -= (double)whole;
        return whole;
    }

    public static int add(Player player, double value) {
        return ((Experience)player.getCapability(CAPABILITY).orElse((Object)new Experience())).add(value);
    }

    public DoubleTag serializeNBT() {
        return DoubleTag.m_128500_((double)this.exp);
    }

    public void deserializeNBT(DoubleTag nbt) {
        this.exp = nbt.m_7061_();
    }

    @Mod.EventBusSubscriber(modid="wizardstaff", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ExperienceProvider
    implements ICapabilitySerializable<DoubleTag> {
        private LazyOptional<Experience> instance = LazyOptional.of(Experience::new);
        public static final ResourceLocation EXPERIENCE_LOCATION = new ResourceLocation("wizardstaff", "experience");

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CAPABILITY.orEmpty(cap, this.instance);
        }

        public DoubleTag serializeNBT() {
            return ((Experience)this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!"))).serializeNBT();
        }

        public void deserializeNBT(DoubleTag nbt) {
            ((Experience)this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!"))).deserializeNBT(nbt);
        }

        @SubscribeEvent
        public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player) {
                event.addCapability(EXPERIENCE_LOCATION, (ICapabilityProvider)new ExperienceProvider());
            }
        }
    }
}

