/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.capability;

import java.util.function.Supplier;
import mod.vemerion.wizardstaff.network.Network;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ByteTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ScreenAnimations
implements INBTSerializable<ByteTag> {
    public static final Capability<ScreenAnimations> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ScreenAnimations>(){});
    private boolean shouldAnimate;

    public ScreenAnimations() {
        this.shouldAnimate = true;
    }

    public ScreenAnimations(boolean shouldAnimate) {
        this.shouldAnimate = shouldAnimate;
    }

    public boolean shouldAnimate() {
        return this.shouldAnimate;
    }

    public void setShouldAnimate(boolean value) {
        this.shouldAnimate = value;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.shouldAnimate);
    }

    public static ScreenAnimations decode(FriendlyByteBuf buffer) {
        return new ScreenAnimations(buffer.readBoolean());
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.setPacketHandled(true);
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                ScreenAnimations screenAnimations = ScreenAnimations.getScreenAnimations((Player)player);
                screenAnimations.setShouldAnimate(this.shouldAnimate);
            }
        });
    }

    public static void sendMessage(Player player, boolean shouldAnimate) {
        Network.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new ScreenAnimations(shouldAnimate));
    }

    public static ScreenAnimations getScreenAnimations(Player player) {
        return (ScreenAnimations)player.getCapability(CAPABILITY).orElse((Object)new ScreenAnimations());
    }

    public ByteTag serializeNBT() {
        return ByteTag.m_128273_((boolean)this.shouldAnimate);
    }

    public void deserializeNBT(ByteTag nbt) {
        this.shouldAnimate = nbt.m_7063_() == 1;
    }

    @Mod.EventBusSubscriber(modid="wizardstaff", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ScreenAnimationsProvider
    implements ICapabilitySerializable<ByteTag> {
        private LazyOptional<ScreenAnimations> instance = LazyOptional.of(ScreenAnimations::new);
        public static final ResourceLocation SCREEN_ANIMATIONS_LOCATION = new ResourceLocation("wizardstaff", "screenanimations");

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CAPABILITY.orEmpty(cap, this.instance);
        }

        public ByteTag serializeNBT() {
            return ((ScreenAnimations)this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!"))).serializeNBT();
        }

        public void deserializeNBT(ByteTag nbt) {
            ((ScreenAnimations)this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!"))).deserializeNBT(nbt);
        }

        @SubscribeEvent
        public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player) {
                event.addCapability(SCREEN_ANIMATIONS_LOCATION, (ICapabilityProvider)new ScreenAnimationsProvider());
            }
        }
    }
}

