/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.capability;

import com.mojang.serialization.DynamicOps;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.Magics;
import mod.vemerion.wizardstaff.entity.GrapplingHookEntity;
import mod.vemerion.wizardstaff.staff.WizardStaffItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemStackHandler;

public class Wizard
implements INBTSerializable<CompoundTag> {
    public static final Capability<Wizard> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<Wizard>(){});
    public static final int INVENTORY_SIZE = 27;
    private GlobalPos lodestonePos;
    private boolean lodestoneTracked;
    private GrapplingHookEntity grapplingHook;
    private BlockPos surfaceStart;
    private BlockPos surfaceStop;
    private LinkedList<GlobalPos> revertPositions = new LinkedList();
    private ItemStackHandler inventory = new ItemStackHandler(27);
    private int mountJumpTimer;
    private Set<BlockPos> xRayed = new HashSet<BlockPos>();
    private int fov;

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public static Wizard getWizard(Player player) {
        return (Wizard)player.getCapability(CAPABILITY).orElseThrow(() -> new IllegalArgumentException("Player is missing wizard capability"));
    }

    public static LazyOptional<Wizard> getWizardOptional(Player player) {
        return player.getCapability(CAPABILITY);
    }

    public static boolean isUsingMagic(MagicType<?> type, Player player) {
        ItemStack staff = player.m_21211_();
        if (staff.m_41720_() instanceof WizardStaffItem) {
            ItemStack magic = WizardStaffItem.getMagic(staff);
            return Magics.getInstance(player.f_19853_.f_46443_).get(magic).getType() == type;
        }
        return false;
    }

    public void tick(Player player) {
        if (!player.f_19853_.f_46443_ && player.f_19797_ % 20 == 0) {
            this.revertPositions.addFirst(GlobalPos.m_122643_((ResourceKey)player.f_19853_.m_46472_(), (BlockPos)player.m_142538_()));
            if (this.revertPositions.size() > 5) {
                this.revertPositions.removeLast();
            }
        }
        if (this.mountJumpTimer > 0) {
            --this.mountJumpTimer;
        }
    }

    public Set<BlockPos> getXRayed() {
        return this.xRayed;
    }

    public void setFov(int fov) {
        this.fov = fov;
    }

    public int getFov() {
        return this.fov;
    }

    public boolean mountJump() {
        if (this.mountJumpTimer == 0) {
            this.mountJumpTimer = 40;
            return true;
        }
        return false;
    }

    public BlockPos revertPosition(Player player) {
        if (this.revertPositions.size() < 5) {
            return null;
        }
        GlobalPos pos = this.revertPositions.getLast();
        return pos.m_122640_() == player.f_19853_.m_46472_() ? pos.m_122646_() : null;
    }

    public boolean lodestoneTeleport(ServerPlayer player, Block waypoint) {
        if (this.lodestoneTracked && this.lodestonePos != null && player.f_19853_.m_46472_() == this.lodestonePos.m_122640_() && player.f_19853_.m_8055_(this.lodestonePos.m_122646_()).m_60734_() == waypoint) {
            this.lodestoneTracked = false;
            BlockPos destination = this.lodestonePos.m_122646_();
            player.m_8999_(player.m_183503_(), (double)destination.m_123341_(), (double)(destination.m_123342_() + 1), (double)destination.m_123343_(), player.m_146908_(), player.m_146909_());
            player.f_19853_.m_46961_(destination, false);
            return true;
        }
        return false;
    }

    public boolean throwGrapplingHook(Level world, Player player) {
        Vec3 end;
        Vec3 start;
        BlockHitResult raytrace;
        if (!world.f_46443_ && (raytrace = world.m_45547_(new ClipContext(start = player.m_20299_(0.5f), end = start.m_82549_(Vec3.m_82503_((Vec2)player.m_20155_()).m_82490_(10.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player))).m_6662_() == HitResult.Type.BLOCK) {
            GrapplingHookEntity hook = new GrapplingHookEntity(world, player);
            Vec3 pos = raytrace.m_82450_().m_82546_(end.m_82546_(start).m_82541_().m_82490_(0.07));
            hook.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, player.m_146908_(), player.m_146909_());
            world.m_7967_((Entity)hook);
            this.grapplingHook = hook;
            return true;
        }
        return false;
    }

    public void trackLodestone(Level world, BlockPos pos, Block waypoint) {
        if (world.m_8055_(pos).m_60734_() == waypoint) {
            this.lodestoneTracked = true;
            this.lodestonePos = GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)pos.m_7949_());
        }
    }

    public void reelGrapplingHook(Level world, Player player) {
        if (this.grapplingHook != null && this.grapplingHook.m_6084_()) {
            Vec3 direction = this.grapplingHook.m_20182_().m_82546_(player.m_20182_()).m_82541_().m_82490_(1.2);
            Vec3 motion = player.m_20184_().m_82549_(direction);
            player.m_20256_(motion);
            if (!world.f_46443_) {
                this.grapplingHook.m_146870_();
            }
        }
    }

    public void setGrapplingHook(GrapplingHookEntity hook) {
        this.grapplingHook = hook;
    }

    public void setSurfacePos(BlockPos pos) {
        if (pos.equals((Object)this.surfaceStart)) {
            this.surfaceStart = null;
        } else if (pos.equals((Object)this.surfaceStop)) {
            this.surfaceStop = null;
        } else if (this.surfaceStart != null && this.surfaceStop != null) {
            this.surfaceStart = pos;
            this.surfaceStop = null;
        } else if (this.surfaceStart == null) {
            this.surfaceStart = pos;
        } else {
            this.surfaceStop = pos;
        }
    }

    public int createSurface(Level world, Player player) {
        BlockPos start = this.surfaceStart == null ? null : new BlockPos((Vec3i)this.surfaceStart);
        BlockPos stop = this.surfaceStop == null ? null : new BlockPos((Vec3i)this.surfaceStop);
        this.surfaceStart = null;
        this.surfaceStop = null;
        if (start == null || stop == null) {
            return 0;
        }
        if (!player.m_142538_().m_123314_((Vec3i)start, 100.0) || !player.m_142538_().m_123314_((Vec3i)stop, 100.0)) {
            return 0;
        }
        if (world.m_46859_(start) || world.m_46859_(stop)) {
            return 0;
        }
        AABB surface = new AABB(start, stop);
        if (surface.m_82362_() > 0.1 && surface.m_82376_() > 0.1 && surface.m_82385_() > 0.1) {
            return 0;
        }
        Item item = world.m_8055_(start).m_60734_().m_5456_();
        if (item == Items.f_41852_ || !(item instanceof BlockItem)) {
            return 0;
        }
        List positions = BlockPos.m_121921_((AABB)surface).map(b -> b.m_7949_()).collect(Collectors.toList());
        int count = 0;
        Inventory inv = player.m_150109_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (inv.m_8020_(i).m_41720_() != item) continue;
            ItemStack stack = inv.m_8016_(i);
            while (!positions.isEmpty() && !stack.m_41619_()) {
                DirectionalPlaceContext context;
                BlockPos p = (BlockPos)positions.remove(0);
                if (!world.m_46859_(p) || ((BlockItem)item).m_40576_((BlockPlaceContext)(context = new DirectionalPlaceContext(world, p, Direction.NORTH, stack, Direction.DOWN))) == InteractionResult.FAIL) continue;
                ++count;
            }
            inv.m_36054_(stack);
        }
        return count;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.lodestoneTracked = compound.m_128471_("lodestoneTracked");
        if (this.lodestoneTracked) {
            this.lodestonePos = GlobalPos.f_122633_.parse((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128423_("lodestonePos")).result().orElse(null);
        }
        if (compound.m_128441_("inventory")) {
            this.inventory.deserializeNBT(compound.m_128469_("inventory"));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        if (this.lodestoneTracked) {
            GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.lodestonePos).resultOrPartial(s -> {}).ifPresent(lodestonePos -> compound.m_128365_("lodestonePos", lodestonePos));
        }
        compound.m_128379_("lodestoneTracked", this.lodestoneTracked);
        compound.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        return compound;
    }

    @Mod.EventBusSubscriber(modid="wizardstaff", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class WizardProvider
    implements ICapabilitySerializable<CompoundTag> {
        private LazyOptional<Wizard> instance = LazyOptional.of(Wizard::new);
        public static final ResourceLocation LOCATION = new ResourceLocation("wizardstaff", "wizard");

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CAPABILITY.orEmpty(cap, this.instance);
        }

        public CompoundTag serializeNBT() {
            return ((Wizard)this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!"))).serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            ((Wizard)this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!"))).deserializeNBT(nbt);
        }

        @SubscribeEvent
        public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player) {
                event.addCapability(LOCATION, (ICapabilityProvider)new WizardProvider());
            }
        }
    }
}

