/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.datagen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import mod.vemerion.wizardstaff.Helper.Helper;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.RegistryMatch;
import mod.vemerion.wizardstaff.init.ModEntities;
import mod.vemerion.wizardstaff.init.ModItems;
import mod.vemerion.wizardstaff.init.ModMagics;
import mod.vemerion.wizardstaff.init.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MagicProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LogManager.getLogger();
    protected final DataGenerator generator;
    private final String modid;

    public MagicProvider(DataGenerator generator, String modid) {
        this.generator = generator;
        this.modid = modid;
    }

    public void m_6865_(HashCache cache) throws IOException {
        Path folder = this.generator.m_123916_();
        this.registerMagics(magic -> {
            Path path = folder.resolve("data/" + this.modid + "/wizardstaffmagics/" + magic.getName().m_135815_() + ".json");
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)magic.write(), (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save magic {}", (Object)path, (Object)e);
            }
        });
    }

    protected void registerMagics(Consumer<Magic> c) {
        c.accept(this.create(ModMagics.BLAZE_POWDER_MAGIC).setParams(0.3f, -1, this.ing(Items.f_42593_)));
        c.accept(this.create(ModMagics.BLUE_DYE_MAGIC).setParams(30.0f, 50, this.ing((TagKey<Item>)Tags.Items.DYES_BLUE)));
        c.accept(this.create(ModMagics.BOOKSHELF_MAGIC).setAdditionalParams(Items.f_42517_, ModSounds.PAGE_TURN).setParams(0.8f, -1, this.ing(Items.f_41997_)));
        c.accept(this.create(ModMagics.TRANSMUTATION_MAGIC, "bottle_magic").setAdditionalParams(Items.f_42612_, SoundEvents.f_11772_).setParams(12.0f, 15, this.ing(Items.f_42590_)));
        c.accept(this.create(ModMagics.BRICKS_MAGIC).setParams(50.0f, 30, this.ing(Items.f_41995_)));
        c.accept(this.create(ModMagics.BUILDER_MAGIC).setAdditionalParams(new ResourceLocation("wizardstaff", "wizard_home"), Direction.SOUTH, new BlockPos(3, 3, 3), new BlockPos(0, 0, 5)).setParams(400.0f, 80, this.ing(Items.f_42594_)));
        c.accept(this.create(ModMagics.CARVED_PUMPKIN_MAGIC).setParams(50.0f, 40, this.ing(Items.f_42047_)));
        c.accept(this.create(ModMagics.CLOCK_MAGIC).setParams(1.0f, -1, this.ing(Items.f_42524_)));
        c.accept(this.create(ModMagics.DEAGE_MAGIC).setParams(30.0f, 30, this.ing(Items.f_42404_)));
        this.magicArmor(c, Items.f_42479_, (Item)ModItems.DRUID_BOOTS);
        this.magicArmor(c, Items.f_42477_, (Item)ModItems.DRUID_CHESTPLATE);
        this.magicArmor(c, Items.f_42476_, (Item)ModItems.DRUID_HELMET);
        this.magicArmor(c, Items.f_42478_, (Item)ModItems.DRUID_LEGGINGS);
        this.magicArmor(c, Items.f_42471_, (Item)ModItems.WARLOCK_BOOTS);
        this.magicArmor(c, Items.f_42469_, (Item)ModItems.WARLOCK_CHESTPLATE);
        this.magicArmor(c, Items.f_42468_, (Item)ModItems.WARLOCK_HELMET);
        this.magicArmor(c, Items.f_42470_, (Item)ModItems.WARLOCK_LEGGINGS);
        this.magicArmor(c, Items.f_42463_, (Item)ModItems.WIZARD_BOOTS);
        this.magicArmor(c, Items.f_42408_, (Item)ModItems.WIZARD_CHESTPLATE);
        this.magicArmor(c, Items.f_42407_, (Item)ModItems.WIZARD_HAT);
        this.magicArmor(c, Items.f_42462_, (Item)ModItems.WIZARD_LEGGINGS);
        c.accept(this.create(ModMagics.EGG_MAGIC).setAdditionalParams((Set<ResourceLocation>)ImmutableSet.of((Object)new ResourceLocation("iceandfire", "fire_dragon"), (Object)new ResourceLocation("iceandfire", "ice_dragon"), (Object)new ResourceLocation("iceandfire", "lightning_dragon"))).setParams(200.0f, 40, this.ing(Items.f_42521_)));
        c.accept(this.create(ModMagics.ELYTRA_MAGIC).setParams(1.0f, -1, this.ing(Items.f_42741_)));
        c.accept(this.create(ModMagics.FEATHER_MAGIC).setParams(0.05f, -1, this.ing(Items.f_42402_)));
        c.accept(this.create(ModMagics.GHAST_TEAR_MAGIC).setParams(0.5f, -1, this.ing(Items.f_42586_)));
        c.accept(this.create(ModMagics.GLOWSTONE_DUST_MAGIC).setParams(40.0f, 40, this.ing((TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE)));
        c.accept(this.create(ModMagics.TRANSFORM_BLOCK_MAGIC, "gold_magic").setAdditionalParams(Blocks.f_50069_, Blocks.f_49995_).setParams(50.0f, 25, this.ing((TagKey<Item>)Tags.Items.INGOTS_GOLD)));
        c.accept(this.create(ModMagics.GOLD_NUGGET_MAGIC).setParams(50.0f, 20, this.ing((TagKey<Item>)Tags.Items.NUGGETS_GOLD)));
        c.accept(this.create(ModMagics.GRAPPLING_HOOK_MAGIC).setParams(5.0f, -1, this.ing(Items.f_42523_)));
        c.accept(this.create(ModMagics.JUKEBOX_MAGIC).setAdditionalParams((Set<ResourceLocation>)ImmutableSet.of((Object)EntityType.f_20565_.getRegistryName(), (Object)EntityType.f_20496_.getRegistryName(), (Object)EntityType.f_20532_.getRegistryName()), 4.0f, SoundEvents.f_12146_).setParams(6.0f, -1, this.ing(Items.f_41984_)));
        c.accept(this.create(ModMagics.LODESTONE_MAGIC).setAdditionalParams(Blocks.f_50729_).setParams(500.0f, 120, this.ing(Items.f_42790_)));
        c.accept(this.create(ModMagics.MAP_MAGIC).setParams(30.0f, 40, this.ing(Items.f_42676_)));
        c.accept(this.create(ModMagics.MUSHROOM_CLOUD_MAGIC).setParams(50.0f, 40, this.ing(Items.f_42093_)));
        c.accept(this.create(ModMagics.NETHER_BRICK_MAGIC).setParams(60.0f, 20, this.ing((TagKey<Item>)Tags.Items.INGOTS_NETHER_BRICK)));
        c.accept(this.create(ModMagics.TRANSMUTATION_MAGIC, "netherite_ingot_magic").setAdditionalParams(ModItems.NETHER_WIZARD_STAFF, ModSounds.POOF).setParams(100.0f, 40, this.ing((TagKey<Item>)Tags.Items.INGOTS_NETHERITE)));
        c.accept(this.create(ModMagics.NETHERRACK_MAGIC).setParams(3.0f, -1, this.ing(Items.f_42048_)));
        c.accept(this.create(ModMagics.OBSIDIAN_MAGIC).setAdditionalParams((ResourceKey<Level>)Level.f_46429_, new ResourceLocation("wizardstaff", "textures/entity/nether_portal.png")).setParams(100.0f, 60, this.ing(Items.f_41999_)));
        c.accept(this.create(ModMagics.PILLAR_MAGIC).setAdditionalParams(Blocks.f_50493_).setParams(0.5f, -1, this.ing(Items.f_42329_)));
        c.accept(this.create(ModMagics.PORTABLE_CRAFTING_MAGIC).setParams(10.0f, 10, this.ing(Items.f_41960_)));
        c.accept(this.create(ModMagics.POTION_MAGIC, "haste_magic").setAdditionalParams(2, 600, 2.0f, MobEffects.f_19598_, true, SoundEvents.f_11772_).setParams(25.0f, 25, this.ing(Items.f_42422_)));
        c.accept(this.create(ModMagics.SHULKER_BULLET_MAGIC).setParams(20.0f, 25, this.ing(Items.f_42748_)));
        c.accept(this.create(ModMagics.SMELTING_MAGIC).setAdditionalParams((RecipeType<? extends Recipe<Container>>)RecipeType.f_44108_, 20, SoundEvents.f_11907_, Blocks.f_50094_.m_7705_(), 1).setParams(1.0f, -1, this.ing(Items.f_41962_)));
        c.accept(this.create(ModMagics.SMELTING_MAGIC, "stonecutting_magic").setAdditionalParams((RecipeType<? extends Recipe<Container>>)RecipeType.f_44112_, 2, SoundEvents.f_12494_, Blocks.f_50679_.m_7705_(), 1).setParams(0.1f, -1, this.ing(Items.f_42776_)));
        c.accept(this.create(ModMagics.SURFACE_MAGIC).setParams(0.5f, 20, this.ing(Items.f_41905_)));
        c.accept(this.create(ModMagics.BUCKET_MAGIC, "water_bucket_magic").setAdditionalParams((BucketItem)Items.f_42447_).setParams(5.0f, 10, this.ing(Items.f_42447_)));
        c.accept(this.create(ModMagics.PROJECTILE_MAGIC, "wither_skull_magic").setAdditionalParams(ModEntities.MAGIC_WITHER_SKULL, ModSounds.SKELETON, 0.5f).setParams(20.0f, 15, this.ing(Items.f_42679_)));
        c.accept(this.create(ModMagics.PROJECTILE_MAGIC, "wizard_hat_throw_magic").setAdditionalParams(ModEntities.WIZARD_HAT, ModSounds.CLOTH, 1.0f).setParams(20.0f, 25, this.ing((Item)ModItems.WIZARD_HAT)));
        c.accept(this.create(ModMagics.WIZARD_STAFF_MAGIC).setParams(0.0f, 20, this.ing(ModItems.WIZARD_STAFF)));
        c.accept(this.create(ModMagics.WRITABLE_BOOK_MAGIC).setAdditionalParams((List<String>)ImmutableList.of((Object)"All that glitters is gold", (Object)"Fear the old blood", (Object)"Every fleeing man must be caught. Every secret must be unearthed. Such is the conceit of the self-proclaimed seeker of truth.", (Object)"What we do in life echoes in eternity", (Object)"STEVEN LIVES", (Object)"What we've got here is... failure to communicate", (Object)"All those moments will be lost in time, like tears in rain", (Object)"A wizard is never late, nor is he early. He arrives precisely when he means to.")).setParams(10.0f, 20, this.ing(Items.f_42614_)));
        c.accept(this.create(ModMagics.PUSH_BLOCK_MAGIC, "push_spawner_magic").setAdditionalParams(Blocks.f_50085_).setParams(15.0f, 25, this.ing(Items.f_41998_)));
        c.accept(this.create(ModMagics.REVERT_POSITION_MAGIC).setParams(15.0f, 15, this.ing(Items.f_42730_)));
        c.accept(this.create(ModMagics.REMOVE_FLUID_MAGIC, "remove_water_magic").setAdditionalParams(new RegistryMatch<Fluid>(ForgeRegistries.FLUIDS, FluidTags.f_13131_)).setParams(0.2f, 10, this.ing(Items.f_41902_)));
        c.accept(this.create(ModMagics.PUSH_BUTTON_MAGIC).setParams(1.0f, -1, this.ing(Items.f_42083_)));
        c.accept(this.create(ModMagics.NAME_TAG_MAGIC).setAdditionalParams((List<String>)ImmutableList.of((Object)"ig", (Object)"nite", (Object)"syl", (Object)"la", (Object)"bles", (Object)"di", (Object)"vide", (Object)"un", (Object)"ex", (Object)"am", (Object)"ples", (Object)"dif", (Object[])new String[]{"fer", "ence", "re", "main", "der"})).setParams(10.0f, 20, this.ing(Items.f_42656_)));
        c.accept(this.create(ModMagics.LOCATE_SPAWN_MAGIC).setParams(25.0f, 20, this.ing(Items.f_42522_)));
        c.accept(this.create(ModMagics.TRANSFORM_ENTITY_MAGIC, "cow_to_mooshroom_magic").setAdditionalParams(new RegistryMatch(ForgeRegistries.ENTITIES, EntityType.f_20557_), EntityType.f_20504_, Helper.color(200, 100, 100, 255)).setParams(90.0f, 25, this.ing(Items.f_41952_)));
        c.accept(this.create(ModMagics.INVENTORY_MAGIC).setParams(10.0f, 10, this.ing(Items.f_42009_)));
        c.accept(this.create(ModMagics.ENDER_CHEST_MAGIC).setParams(10.0f, 10, this.ing(Items.f_42108_)));
        c.accept(this.create(ModMagics.DEFLECT_PROJECTILE_MAGIC).setAdditionalParams((Set<ResourceLocation>)ImmutableSet.of()).setParams(0.8f, -1, this.ing(Items.f_42740_)));
        c.accept(this.create(ModMagics.REPAIR_ARMOR_MAGIC).setAdditionalParams(1).setParams(1.0f, -1, this.ing(Items.f_42146_)));
        c.accept(this.create(ModMagics.SUMMON_ENTITY_MAGIC, "summon_friendly_vex_magic").setAdditionalParams(3).setAdditionalParams(ModEntities.MAGIC_VEX, ModSounds.BELL).setParams(40.0f, 40, this.ing(Items.f_42747_)));
        c.accept(this.create(ModMagics.MASS_HARVEST_MAGIC, "chop_tree_magic").setAdditionalParams(new RegistryMatch<Block>(ForgeRegistries.BLOCKS, BlockTags.f_13106_), 40).setParams(2.0f, 40, this.ing(Items.f_42391_)));
        c.accept(this.create(ModMagics.MASS_HARVEST_MAGIC, "clear_leaves_magic").setAdditionalParams(new RegistryMatch<Block>(ForgeRegistries.BLOCKS, BlockTags.f_13035_), 50).setParams(0.1f, 20, this.ing(Items.f_42574_)));
        c.accept(this.create(ModMagics.FORCE_ENTITY_MAGIC, "item_magnet_magic").setAdditionalParams(new RegistryMatch(ForgeRegistries.ENTITIES, EntityType.f_20461_), 0.2f).setParams(0.1f, -1, this.ing(Items.f_41913_)));
        c.accept(this.create(ModMagics.FORCE_ENTITY_MAGIC, "repel_zombie_magic").setAdditionalParams(new RegistryMatch(ForgeRegistries.ENTITIES, EntityType.f_20501_), -0.1f).setParams(0.5f, -1, this.ing(Items.f_42546_)));
        c.accept(this.create(ModMagics.SWAP_POSITION_MAGIC).setAdditionalParams((Set<ResourceLocation>)ImmutableSet.of((Object)EntityType.f_20565_.getRegistryName(), (Object)EntityType.f_20496_.getRegistryName()), 5.0f).setParams(25.0f, 20, this.ing(Items.f_42650_)));
        c.accept(this.create(ModMagics.SWAP_HEALTH_FOOD_MAGIC).setParams(20.0f, 20, this.ing(Items.f_42580_)));
        c.accept(this.create(ModMagics.SWAP_TRADE_MAGIC).setAdditionalParams(this.ing(Items.f_42777_)).setParams(400.0f, 40, this.ing(Items.f_42616_)));
        c.accept(this.create(ModMagics.TRANSFORM_BLOCK_MAGIC, "infest_stone_magic").setAdditionalParams(Blocks.f_50069_, Blocks.f_50226_).setParams(20.0f, 20, this.ing((TagKey<Item>)Tags.Items.DYES_LIGHT_GRAY)));
        c.accept(this.create(ModMagics.REPAIR_OFFHAND_MAGIC).setAdditionalParams(1).setParams(1.0f, -1, this.ing(Items.f_42775_)));
        c.accept(this.create(ModMagics.WALL_CLIMB_MAGIC).setAdditionalParams(0.2f).setParams(0.05f, -1, this.ing(Items.f_42401_)));
        c.accept(this.create(ModMagics.COBWEB_MAGIC).setParams(10.0f, 15, this.ing(Items.f_41863_)));
        c.accept(this.create(ModMagics.BEE_MAGIC).setParams(20.0f, 20, this.ing(Items.f_42784_)));
        c.accept(this.create(ModMagics.SHAPED_CREATE_ENTITY_MAGIC, "evoker_fangs_magic").setAdditionalParams(this.circlesShape()).setAdditionalParams(EntityType.f_20569_, ModSounds.BELL).setParams(30.0f, 15, this.ing(Items.f_42534_)));
        c.accept(this.create(ModMagics.SHAPED_CREATE_ENTITY_MAGIC, "soul_sand_magic").setAdditionalParams(this.soulSandMagicShape()).setAdditionalParams(ModEntities.MAGIC_SOUL_SAND_ARM, ModSounds.PUMPKIN_MAGIC).setParams(40.0f, 40, this.ing(Items.f_42049_)));
        c.accept(this.create(ModMagics.SHAPED_CREATE_ENTITY_MAGIC, "tnt_magic").setAdditionalParams(this.tntShape()).setAdditionalParams(EntityType.f_20515_, ModSounds.CLOCK).setParams(50.0f, 15, this.ing(Items.f_41996_)));
        c.accept(this.create(ModMagics.MINING_MAGIC).setAdditionalParams(new RegistryMatch<Block>(ForgeRegistries.BLOCKS, Tags.Blocks.ORES), 20).setParams(1.0f, 10, this.ing(Items.f_42390_)));
        c.accept(this.create(ModMagics.SUMMON_ENTITY_MAGIC, "summon_lightning_magic").setAdditionalParams(1).setAdditionalParams(EntityType.f_20465_, SoundEvents.f_12089_).setParams(40.0f, 60, this.ing(Items.f_151041_)));
        c.accept(this.create(ModMagics.MOUNT_MAGIC, "mount_goat_magic").setAdditionalParams(new RegistryMatch(ForgeRegistries.ENTITIES, EntityType.f_147035_)).setParams(0.2f, 60, this.ing(Items.f_42405_)));
        c.accept(this.create(ModMagics.X_RAY_MAGIC).setAdditionalParams(15, new RegistryMatch<Block>(ForgeRegistries.BLOCKS, Tags.Blocks.ORES)).setParams(3.0f, -1, this.ing(Items.f_41959_)));
        c.accept(this.create(ModMagics.LIGHT_MAGIC).setParams(5.0f, -1, this.ing(Items.f_42054_)));
        c.accept(this.create(ModMagics.ZOOM_MAGIC).setAdditionalParams(3).setParams(0.1f, -1, this.ing(Items.f_151059_)));
        c.accept(this.create(ModMagics.SUMMON_ENTITY_MAGIC, "summon_mining_vex_magic").setAdditionalParams(3).setAdditionalParams(ModEntities.MAGIC_MINING_VEX, ModSounds.BELL, this.jsonWithSingleProp("minable", Tags.Blocks.ORES.f_203868_().toString())).setParams(60.0f, 55, this.ing(Items.f_42432_)));
        c.accept(this.create(ModMagics.PLACE_LIGHT_RANDOM_MAGIC).setAdditionalParams(10, 4, (BlockItem)Items.f_42000_).setParams(0.4f, -1, this.ing(Items.f_42000_)));
    }

    private void magicArmor(Consumer<Magic> c, Item from, Item created) {
        c.accept(this.create(ModMagics.TRANSMUTATION_MAGIC, created.getRegistryName().m_135815_() + "_fashion_magic").setAdditionalParams(created, ModSounds.PLOP).setParams(30.0f, 20, this.ing(from)));
    }

    private <T extends Magic> T create(MagicType<T> type, String name) {
        return type.create(name == null || name.isEmpty() ? type.getRegistryName() : this.rl(name));
    }

    private <T extends Magic> T create(MagicType<T> type) {
        return this.create(type, "");
    }

    private ResourceLocation rl(String name) {
        return new ResourceLocation("wizardstaff", name);
    }

    private Ingredient ing(Item item) {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
    }

    private Ingredient ing(TagKey<Item> tag) {
        return Ingredient.m_204132_(tag);
    }

    private JsonObject jsonWithSingleProp(String key, String property) {
        JsonObject json = new JsonObject();
        json.addProperty(key, property);
        return json;
    }

    public String m_6055_() {
        return "Magics";
    }

    private List<String> shape(String ... rows) {
        ArrayList<String> shape = new ArrayList<String>();
        for (String s : rows) {
            shape.add(s);
        }
        return shape;
    }

    private List<String> circlesShape() {
        return this.shape("   x   ", " x   x ", "   x   ", "x xpx x", "   x   ", " x   x ", "   x   ");
    }

    private List<String> soulSandMagicShape() {
        return this.shape(" x ", "x  ", " x ", " x ", "  x", " x ", "  x", " x ", " p ");
    }

    private List<String> tntShape() {
        return this.shape("x", "x", "x", " ", "p");
    }
}

