/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.entity;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mod.vemerion.wizardstaff.Magic.CreateEntityMagic;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.entity.ICasted;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class MagicVexEntity
extends Vex
implements ICasted {
    private UUID caster;

    public MagicVexEntity(EntityType<? extends MagicVexEntity> type, Level level) {
        super(type, level);
        this.f_21364_ = 0;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor levelIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        this.m_21559_(this.m_21187_().nextBoolean());
        List<Item> tools = this.generateTools();
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)tools.get(this.m_21187_().nextInt(tools.size()))));
        this.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
        return spawnDataIn;
    }

    protected abstract List<Item> generateTools();

    public abstract int lifetime();

    @Override
    public UUID getCasterUUID() {
        return this.caster;
    }

    @Override
    public void setCasterUUID(UUID id) {
        this.caster = id;
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_7327_(Entity entityIn) {
        Player caster = this.getCaster(this.f_19853_);
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        DamageSource source = caster == null ? Magic.magicDamage() : Magic.magicDamage((Entity)this, caster);
        return entityIn.m_6469_(source, damage);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new UpdateOrigin(this));
        this.clearTargetSelector();
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("shooter")) {
            this.loadCaster(compound.m_128469_("shooter"));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("shooter", (Tag)this.saveCaster());
    }

    private void clearTargetSelector() {
        this.f_21346_.m_148105_().clear();
    }

    public static class UpdateOrigin
    extends Goal {
        private MagicVexEntity vex;

        public UpdateOrigin(MagicVexEntity vex) {
            this.vex = vex;
        }

        public boolean m_8036_() {
            Player player = this.vex.getCaster(this.vex.f_19853_);
            if (player == null) {
                return false;
            }
            return this.vex.m_21187_().nextInt(30) == 1 && player.m_20280_((Entity)this.vex) < 2000.0;
        }

        public void m_8056_() {
            Player player = this.vex.getCaster(this.vex.f_19853_);
            if (player == null) {
                return;
            }
            this.vex.m_34033_(player.m_142538_());
        }
    }

    public static class Mining
    extends MagicVexEntity {
        private TagKey<Block> minable = Tags.Blocks.ORES;

        public Mining(EntityType<? extends Mining> type, Level level) {
            super(type, level);
        }

        @Override
        protected List<Item> generateTools() {
            ArrayList<Item> weapons = new ArrayList<Item>();
            weapons.add(Items.f_42390_);
            weapons.add(Items.f_42432_);
            weapons.add(Items.f_42385_);
            weapons.add(Items.f_42427_);
            return weapons;
        }

        @Override
        protected void m_8099_() {
            super.m_8099_();
            this.f_21345_.m_25352_(1, (Goal)new MiningGoal(this, 1.0, 12, 6));
        }

        public boolean canMine(BlockState state) {
            return state.m_204336_(this.minable);
        }

        @Override
        public SpawnGroupData m_6518_(ServerLevelAccessor levelIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
            if (spawnDataIn != null && spawnDataIn instanceof CreateEntityMagic.JsonData) {
                CreateEntityMagic.JsonData data = (CreateEntityMagic.JsonData)spawnDataIn;
                if (data.json.has("minable")) {
                    this.minable = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation(GsonHelper.m_13906_((JsonObject)data.json, (String)"minable")));
                }
            }
            return super.m_6518_(levelIn, difficultyIn, reason, spawnDataIn, dataTag);
        }

        @Override
        public void m_7378_(CompoundTag compound) {
            super.m_7378_(compound);
            if (compound.m_128441_("minable")) {
                this.minable = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation(compound.m_128461_("minable")));
            }
        }

        @Override
        public void m_7380_(CompoundTag compound) {
            super.m_7380_(compound);
            compound.m_128359_("minable", this.minable.f_203868_().toString());
        }

        @Override
        public int lifetime() {
            return 800;
        }
    }

    public static class Attack
    extends MagicVexEntity {
        private static final ResourceLocation[] MOD_WEAPONS = new ResourceLocation[]{new ResourceLocation("twilightforest", "fiery_sword"), new ResourceLocation("immersiveengineering", "revolver"), new ResourceLocation("iceandfire", "dragonbone_sword")};

        public Attack(EntityType<? extends Attack> type, Level level) {
            super(type, level);
        }

        @Override
        protected List<Item> generateTools() {
            ArrayList<Item> weapons = new ArrayList<Item>();
            weapons.add(Items.f_42383_);
            weapons.add(Items.f_42392_);
            weapons.add(Items.f_42422_);
            for (ResourceLocation rl : MOD_WEAPONS) {
                if (!ForgeRegistries.ITEMS.containsKey(rl)) continue;
                weapons.add((Item)ForgeRegistries.ITEMS.getValue(rl));
            }
            return weapons;
        }

        @Override
        protected void m_8099_() {
            super.m_8099_();
            this.f_21346_.m_25352_(0, (Goal)new CopyCasterTargetGoal(this));
            this.f_21346_.m_25352_(1, (Goal)new DefendCasterGoal(this));
        }

        @Override
        public int lifetime() {
            return 400;
        }
    }

    private static class MiningGoal
    extends MoveToBlockGoal {
        private static final int MINING_DURATION = 50;
        private int duration;
        private Mining vex;

        public MiningGoal(Mining vex, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
            super((PathfinderMob)vex, pSpeedModifier, pSearchRange, pVerticalSearchRange);
            this.vex = vex;
        }

        public double m_8052_() {
            return 2.0;
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            return this.vex.canMine(pLevel.m_8055_(pPos));
        }

        protected int m_6099_(PathfinderMob pCreature) {
            return 100 + this.f_25598_.m_21187_().nextInt(100);
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.m_25625_()) {
                if (this.duration++ > 50) {
                    this.mineBlock();
                } else if (this.duration % 7 == 0) {
                    this.f_25598_.m_5496_(this.f_25598_.f_19853_.m_8055_(this.f_25602_).m_60827_().m_56778_(), 1.0f, this.f_25598_.m_6100_());
                    this.f_25598_.m_6674_(InteractionHand.OFF_HAND);
                }
            } else {
                this.f_25598_.m_21566_().m_6849_((double)this.f_25602_.m_123341_() + 0.5, (double)this.f_25602_.m_123342_() + 0.5, (double)this.f_25602_.m_123343_() + 0.5, 0.25);
            }
        }

        private void mineBlock() {
            if (this.m_6465_((LevelReader)this.f_25598_.f_19853_, this.f_25602_)) {
                this.f_25598_.f_19853_.m_46961_(this.f_25602_, true);
            }
        }

        protected BlockPos m_6669_() {
            return this.f_25602_;
        }

        public void m_8056_() {
            super.m_8056_();
            this.duration = 0;
        }
    }

    private static class DefendCasterGoal
    extends SetAttackTargetGoal {
        public DefendCasterGoal(MagicVexEntity vex) {
            super(vex);
        }

        @Override
        protected LivingEntity getTarget(Player player) {
            return player.m_142581_();
        }

        @Override
        protected int getTimestamp(Player player) {
            return player.m_21213_();
        }
    }

    private static class CopyCasterTargetGoal
    extends SetAttackTargetGoal {
        public CopyCasterTargetGoal(MagicVexEntity vex) {
            super(vex);
        }

        @Override
        protected LivingEntity getTarget(Player player) {
            return player.m_21214_();
        }

        @Override
        protected int getTimestamp(Player player) {
            return player.m_21215_();
        }
    }

    private static abstract class SetAttackTargetGoal
    extends TargetGoal {
        private MagicVexEntity vex;
        private int timestamp;

        public SetAttackTargetGoal(MagicVexEntity vex) {
            super((Mob)vex, false);
            this.vex = vex;
        }

        public boolean m_8036_() {
            Player player = this.vex.getCaster(this.vex.f_19853_);
            if (player == null) {
                return false;
            }
            if (this.timestamp == this.getTimestamp(player)) {
                return false;
            }
            LivingEntity target = this.getTarget(player);
            return target != null && (!(target instanceof MagicVexEntity) || ((MagicVexEntity)target).getCaster(this.vex.f_19853_) != player);
        }

        public void m_8056_() {
            Player player = this.vex.getCaster(this.vex.f_19853_);
            if (player == null) {
                return;
            }
            this.vex.m_6710_(this.getTarget(player));
            this.timestamp = this.getTimestamp(player);
            super.m_8056_();
        }

        protected abstract LivingEntity getTarget(Player var1);

        protected abstract int getTimestamp(Player var1);
    }
}

