/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.entity;

import java.util.function.Function;
import mod.vemerion.wizardstaff.Main;
import mod.vemerion.wizardstaff.init.ModParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.NetworkHooks;

public class NetherPortalEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("wizardstaff", "textures/entity/nether_portal.png");
    private static final int MAX_DURATION = 600;
    private int duration;
    private ResourceLocation texture;
    private ResourceKey<Level> dimension;

    public NetherPortalEntity(EntityType<? extends NetherPortalEntity> entityTypeIn, Level level, ResourceKey<Level> dimension, ResourceLocation texture) {
        super(entityTypeIn, level);
        this.m_20242_(true);
        this.texture = texture;
        this.dimension = dimension;
    }

    public NetherPortalEntity(EntityType<? extends NetherPortalEntity> entityTypeIn, Level level) {
        this(entityTypeIn, level, (ResourceKey<Level>)Level.f_46429_, DEFAULT_TEXTURE);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.spawnParticles();
            if (this.duration++ > 600) {
                this.m_146870_();
            }
        }
    }

    private void spawnParticles() {
        ServerLevel serverWorld = (ServerLevel)this.f_19853_;
        Vec3 sideways = Vec3.m_82498_((float)0.0f, (float)(this.m_146908_() + 90.0f));
        for (int j = 0; j < 30; ++j) {
            float rotation = this.f_19796_.nextFloat() * (float)Math.PI * 2.0f;
            float offset = this.f_19796_.nextFloat() * 0.05f - 0.025f;
            Vec3 pos = this.m_20182_().m_82520_(sideways.f_82479_ * (double)Mth.m_14089_((float)rotation) * (0.5 + (double)offset), (double)(1.0f + Mth.m_14031_((float)rotation) * (1.0f + offset)), sideways.f_82481_ * (double)Mth.m_14089_((float)rotation) * (0.5 + (double)offset));
            serverWorld.m_8767_((ParticleOptions)ModParticles.MAGIC_SMOKE_PARTICLE, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public boolean m_6087_() {
        return true;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!player.f_19853_.f_46443_ && this.duration > 20) {
            Level level = player.f_19853_;
            player.m_20091_();
            ServerLevel portalWorld = ((ServerLevel)level).m_142572_().m_129880_(this.dimension);
            if (portalWorld != null) {
                try {
                    ObfuscationReflectionHelper.setPrivateValue(Entity.class, (Object)player, (Object)player.m_142538_().m_7949_(), (String)"f_19819_");
                    player.changeDimension(portalWorld, (ITeleporter)new MagicTeleporter());
                }
                catch (RuntimeException e) {
                    Main.LOGGER.warn("Unable to use spell to teleport to nether, reason: " + e);
                }
            } else {
                Main.LOGGER.debug("Can not find dimension " + this.dimension.m_135782_().toString());
            }
        }
        return InteractionResult.FAIL;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public float m_6073_() {
        return 15.0f;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("texture")) {
            this.texture = new ResourceLocation(compound.m_128461_("texture"));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128359_("texture", this.texture.toString());
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.texture);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.texture = additionalData.m_130281_();
    }

    private static class MagicTeleporter
    implements ITeleporter {
        private MagicTeleporter() {
        }

        public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
            if (destWorld.m_46472_() == Level.f_46430_) {
                return defaultPortalInfo.apply(destWorld);
            }
            BlockPos p = destWorld.m_8900_();
            if (destWorld.m_46859_(p.m_7495_())) {
                destWorld.m_46597_(p.m_7495_(), Blocks.f_50069_.m_49966_());
            }
            for (int i = 0; i < 2; ++i) {
                if (destWorld.m_46859_(p.m_6630_(i))) continue;
                destWorld.m_46597_(p.m_6630_(i), Blocks.f_50016_.m_49966_());
            }
            return new PortalInfo(Vec3.m_82539_((Vec3i)p), Vec3.f_82478_, destWorld.m_5822_().nextFloat() * 360.0f, 0.0f);
        }
    }
}

