/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Vector3f;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.OptionalDouble;
import mod.vemerion.wizardstaff.Magic.Magics;
import mod.vemerion.wizardstaff.Main;
import mod.vemerion.wizardstaff.capability.Wizard;
import mod.vemerion.wizardstaff.event.ClientModEventSubscriber;
import mod.vemerion.wizardstaff.init.ModMagics;
import mod.vemerion.wizardstaff.network.CycleCurrentMessage;
import mod.vemerion.wizardstaff.network.Network;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import mod.vemerion.wizardstaff.staff.WizardStaffItem;
import mod.vemerion.wizardstaff.staff.WizardStaffItemHandler;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.RenderProperties;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="wizardstaff", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientForgeEventSubscriber {
    static final Method renderSpyglassOverlay = ObfuscationReflectionHelper.findMethod(Gui.class, (String)"m_168675_", (Class[])new Class[]{Float.TYPE});

    @SubscribeEvent
    public static void wizardStaff(RenderHandEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack itemStack = event.getItemStack();
        Item item = itemStack.m_41720_();
        float partialTicks = event.getPartialTicks();
        if (item instanceof WizardStaffItem && player.m_21211_().equals(itemStack)) {
            event.setCanceled(true);
            ItemStack magic = WizardStaffItem.getMagic(itemStack);
            HumanoidArm side = event.getHand() == InteractionHand.MAIN_HAND ? player.m_5737_() : player.m_5737_().m_20828_();
            WizardStaffTileEntityRenderer renderer = (WizardStaffTileEntityRenderer)RenderProperties.get((Item)item).getItemStackRenderer();
            int maxDuration = itemStack.m_41779_();
            float duration = (float)maxDuration - ((float)player.m_21212_() - partialTicks + 1.0f);
            Magics.getInstance(true).get(magic).firstPersonRenderer().render(renderer, duration, maxDuration, itemStack, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), OverlayTexture.f_118083_, partialTicks, side);
        }
    }

    @SubscribeEvent
    public static void cycleMagicKey(InputEvent.KeyInputEvent event) {
        if (!ClientModEventSubscriber.cycleMagicKey.m_90859_()) {
            return;
        }
        WizardStaffItemHandler.getOptional(Minecraft.m_91087_().f_91074_.m_21205_()).ifPresent(h -> {
            h.cycleCurrent();
            Network.INSTANCE.sendToServer((Object)new CycleCurrentMessage());
        });
    }

    @SubscribeEvent
    public static void noStaffSlowdown(MovementInputUpdateEvent event) {
        if (!(event.getPlayer().m_21211_().m_41720_() instanceof WizardStaffItem)) {
            return;
        }
        Input movement = event.getInput();
        movement.f_108566_ = (float)((double)movement.f_108566_ * 5.0);
        movement.f_108567_ = (float)((double)movement.f_108567_ * 5.0);
    }

    @SubscribeEvent
    public static void xRay(RenderLevelLastEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (!Wizard.isUsingMagic(ModMagics.X_RAY_MAGIC, (Player)player)) {
            Wizard.getWizardOptional((Player)player).ifPresent(w -> w.getXRayed().clear());
            return;
        }
        Wizard.getWizardOptional((Player)player).ifPresent(w -> {
            RenderSystem.m_69465_();
            RenderSystem.m_69464_();
            Camera camera = mc.f_91063_.m_109153_();
            MultiBufferSource.BufferSource source = Minecraft.m_91087_().m_91269_().m_110104_();
            Vec3 cameraOffset = camera.m_90583_().m_82548_();
            w.getXRayed().forEach(p -> {
                AABB box = new AABB(p, p.m_142082_(1, 1, 1));
                LevelRenderer.m_109654_((PoseStack)event.getPoseStack(), (VertexConsumer)source.m_6299_(RenderTypes.LINES), (VoxelShape)Shapes.m_83064_((AABB)box), (double)cameraOffset.f_82479_, (double)cameraOffset.f_82480_, (double)cameraOffset.f_82481_, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            });
            source.m_109911_();
            RenderSystem.m_69482_();
            RenderSystem.m_69481_();
        });
    }

    static boolean shouldZoom(Minecraft mc) {
        return Wizard.isUsingMagic(ModMagics.ZOOM_MAGIC, (Player)mc.f_91074_) && mc.f_91066_.m_92176_().m_90612_();
    }

    @SubscribeEvent
    public static void magicSpyglass(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (!ClientForgeEventSubscriber.shouldZoom(mc)) {
            return;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69465_();
        float time = (float)mc.f_91073_.m_46467_() + event.getPartialTicks();
        RenderSystem.m_157429_((float)(Math.abs(Mth.m_14031_((float)(time / 20.0f))) * 0.5f + 0.5f), (float)0.0f, (float)(Math.abs(Mth.m_14089_((float)(time / 20.0f + 0.2f))) * 0.5f + 0.5f), (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        PoseStack poseStack = RenderSystem.m_157191_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)(event.getWindow().m_85445_() / 2), (double)(event.getWindow().m_85446_() / 2), 0.0);
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(time));
        poseStack.m_85837_((double)(-event.getWindow().m_85445_() / 2), (double)(-event.getWindow().m_85446_() / 2), 0.0);
        RenderSystem.m_157182_();
        try {
            renderSpyglassOverlay.invoke((Object)mc.f_91065_, Float.valueOf(1.8f));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Main.LOGGER.warn("Could not invoke 'renderSpyglassOverlay':" + e);
        }
        RenderSystem.m_157424_();
        poseStack.m_85849_();
        RenderSystem.m_157182_();
    }

    @SubscribeEvent
    public static void zoom(EntityViewRenderEvent.FieldOfView event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (!ClientForgeEventSubscriber.shouldZoom(mc)) {
            return;
        }
        Wizard.getWizardOptional((Player)player).ifPresent(w -> {
            float time = (float)mc.f_91073_.m_46467_() + (float)event.getPartialTicks();
            float fov = (float)w.getFov() + Mth.m_14031_((float)(time / 20.0f));
            event.setFOV((double)fov);
        });
    }

    private static abstract class RenderTypes
    extends RenderType {
        private static final RenderType LINES = RenderTypes.m_173215_((String)"wizardstaff_lines", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.empty())).m_110669_(f_110119_).m_110685_(f_110139_).m_110675_(f_110129_).m_110687_(f_110114_).m_110661_(f_110110_).m_110663_(f_110111_).m_110691_(false));

        private RenderTypes(String pName, VertexFormat pFormat, VertexFormat.Mode pMode, int pBufferSize, boolean pAffectsCrumbling, boolean pSortOnUpload, Runnable pSetupState, Runnable pClearState) {
            super(pName, pFormat, pMode, pBufferSize, pAffectsCrumbling, pSortOnUpload, pSetupState, pClearState);
        }
    }
}

