/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.item;

import java.util.List;
import java.util.function.Consumer;
import mod.vemerion.wizardstaff.model.MagicArmorModel;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;

public abstract class MagicArmorItem
extends DyeableArmorItem {
    public MagicArmorItem(ArmorMaterial material, EquipmentSlot slot) {
        super(material, slot, new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40754_));
    }

    public int m_41121_(ItemStack stack) {
        return this.m_41113_(stack) ? super.m_41121_(stack) : this.getDefaultColor();
    }

    protected abstract int getDefaultColor();

    protected abstract String getMagicArmorName();

    protected abstract RenderProperties getRenderProperties();

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        if ("overlay".equals(type)) {
            return "wizardstaff:textures/armor/" + this.getMagicArmorName() + "_overlay.png";
        }
        return "wizardstaff:textures/armor/" + this.getMagicArmorName() + ".png";
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("item.wizardstaff." + this.getMagicArmorName() + ".description").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flagIn);
    }

    public static int countMagicArmorPieces(Player player) {
        int count = 0;
        for (ItemStack armor : player.m_6168_()) {
            if (!(armor.m_41720_() instanceof MagicArmorItem)) continue;
            ++count;
        }
        return count;
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(this.getRenderProperties());
    }

    protected static abstract class RenderProperties
    implements IItemRenderProperties {
        MagicArmorModel<?> model;

        protected RenderProperties() {
        }

        public HumanoidModel<?> getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
            if (this.model == null) {
                this.model = this.getModel();
            }
            this.model.setVisibility(armorSlot);
            this.model.f_102609_ = _default.f_102609_;
            this.model.f_102817_ = _default.f_102817_;
            this.model.f_102610_ = _default.f_102610_;
            this.model.f_102816_ = _default.f_102816_;
            this.model.f_102815_ = _default.f_102815_;
            return this.model;
        }

        protected abstract MagicArmorModel<?> getModel();
    }

    protected static abstract class MagicArmorMaterial
    implements ArmorMaterial {
        protected static final int[] MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
        protected static final int[] PROTECTION_ARRAY = new int[]{1, 2, 3, 1};

        protected MagicArmorMaterial() {
        }

        public int m_7366_(EquipmentSlot slotIn) {
            return MAX_DAMAGE_ARRAY[slotIn.m_20749_()] * 5;
        }

        public int m_7365_(EquipmentSlot slotIn) {
            return PROTECTION_ARRAY[slotIn.m_20749_()];
        }

        public int m_6646_() {
            return 20;
        }

        public SoundEvent m_7344_() {
            return SoundEvents.f_11678_;
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }
    }
}

