/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.network;

import java.util.UUID;
import java.util.function.Supplier;
import mod.vemerion.wizardstaff.sound.WizardStaffTickableSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class JukeboxMagicMessage {
    private UUID id;
    private SoundEvent music;

    public JukeboxMagicMessage(UUID id, SoundEvent music) {
        this.id = id;
        this.music = music;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.id);
        buffer.writeRegistryId((IForgeRegistryEntry)this.music);
    }

    public static JukeboxMagicMessage decode(FriendlyByteBuf buffer) {
        return new JukeboxMagicMessage(buffer.m_130259_(), (SoundEvent)buffer.readRegistryId());
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.setPacketHandled(true);
        context.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> PlayMusic.play(this.id, this.music)));
    }

    private static class PlayMusic {
        private PlayMusic() {
        }

        private static DistExecutor.SafeRunnable play(final UUID id, final SoundEvent music) {
            return new DistExecutor.SafeRunnable(){
                private static final long serialVersionUID = 1L;

                public void run() {
                    WizardStaffTickableSound sound = new WizardStaffTickableSound(id, music);
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
                }
            };
        }
    }
}

