/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.vemerion.wizardstaff.entity.GrapplingHookEntity;
import mod.vemerion.wizardstaff.init.ModLayerLocations;
import mod.vemerion.wizardstaff.model.GrapplingHookModel;
import mod.vemerion.wizardstaff.staff.WizardStaffItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class GrapplingHookRenderer
extends EntityRenderer<GrapplingHookEntity> {
    public static final ResourceLocation TEXTURES = new ResourceLocation("wizardstaff", "textures/entity/grappling_hook.png");
    private final GrapplingHookModel model;

    public GrapplingHookRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
        this.model = new GrapplingHookModel(renderManagerIn.m_174023_(ModLayerLocations.GRAPPLING_HOOK));
    }

    public void render(GrapplingHookEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        this.model.setupAnim(entityIn, 0.0f, 0.0f, (float)entityIn.f_19797_ + partialTicks, (float)Math.toRadians(180.0f - entityIn.m_5675_(partialTicks)), (float)Math.toRadians(-entityIn.m_5686_(partialTicks)));
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(this.model.m_103119_(this.getTextureLocation(entityIn)));
        this.model.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85836_();
        Player shooter = entityIn.getCaster(entityIn.f_19853_);
        if (shooter != null) {
            Vec3 shooterPos;
            float handOffset;
            float f = handOffset = shooter.m_5737_() == HumanoidArm.RIGHT ? 1.0f : -1.0f;
            if (!(shooter.m_21205_().m_41720_() instanceof WizardStaffItem)) {
                handOffset *= -1.0f;
            }
            if ((this.f_114476_.f_114360_ == null || this.f_114476_.f_114360_.m_92176_().m_90612_()) && shooter == Minecraft.m_91087_().f_91074_) {
                double fov = this.f_114476_.f_114360_.f_92068_ / 100.0;
                Vec3 fovOffset = new Vec3(-0.1 * fov * (double)handOffset, 0.03 * fov, 0.3);
                fovOffset = fovOffset.m_82496_((float)(-Math.toRadians(shooter.m_5686_(partialTicks))));
                fovOffset = fovOffset.m_82524_((float)(-Math.toRadians(shooter.m_5675_(partialTicks))));
                shooterPos = shooter.m_20299_(partialTicks).m_82546_(entityIn.m_20182_()).m_82549_(fovOffset);
            } else {
                float renderYawOffset = Mth.m_14179_((float)partialTicks, (float)shooter.f_20884_, (float)shooter.f_20883_) * ((float)Math.PI / 180);
                float xOffset = Mth.m_14031_((float)renderYawOffset);
                float yOffset = Mth.m_14089_((float)renderYawOffset);
                Vec3 offset = new Vec3((double)(-xOffset) * 0.8, 0.2, (double)yOffset * 0.8);
                shooterPos = shooter.m_20299_(partialTicks).m_82546_(entityIn.m_20182_()).m_82549_(offset);
            }
            VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110504_());
            PoseStack.Pose pose = matrixStackIn.m_85850_();
            builder.m_85982_(pose.m_85861_(), 0.0f, 0.1f, 0.0f).m_6122_(0, 0, 0, 255).m_85977_(pose.m_85864_(), 0.0f, 0.0f, 0.0f).m_5752_();
            builder.m_85982_(pose.m_85861_(), (float)shooterPos.f_82479_, (float)shooterPos.f_82480_, (float)shooterPos.f_82481_).m_6122_(0, 0, 0, 255).m_85977_(pose.m_85864_(), 0.0f, 0.0f, 0.0f).m_5752_();
        }
        matrixStackIn.m_85849_();
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected boolean shouldShowName(GrapplingHookEntity entity) {
        return false;
    }

    public ResourceLocation getTextureLocation(GrapplingHookEntity entity) {
        return TEXTURES;
    }
}

