/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import mod.vemerion.wizardstaff.Main;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.staff.WizardStaffItemHandler;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="wizardstaff", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class HeldItemFilterLayer
extends ItemInHandLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final Set<PlayerRenderer> injected = Collections.newSetFromMap(new WeakHashMap());
    private RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> parent;

    @SubscribeEvent
    public static void onPlayerRenderPre(RenderPlayerEvent.Pre event) {
        PlayerRenderer renderer = event.getRenderer();
        if (renderer != null && !injected.contains(renderer)) {
            HeldItemFilterLayer.addFilterLayer(renderer);
            renderer.m_115326_((RenderLayer)new WizardStaffLayer(renderer));
            injected.add(renderer);
        }
    }

    private static void addFilterLayer(PlayerRenderer renderer) {
        try {
            List layers = (List)ObfuscationReflectionHelper.getPrivateValue(LivingEntityRenderer.class, (Object)renderer, (String)"f_115291_");
            if (layers != null) {
                RenderLayer heldItemLayer = null;
                for (RenderLayer layerRenderer : layers) {
                    if (!(layerRenderer instanceof ItemInHandLayer) || layerRenderer instanceof HeldItemFilterLayer) continue;
                    heldItemLayer = layerRenderer;
                    break;
                }
                if (heldItemLayer != null) {
                    renderer.m_115326_((RenderLayer)new HeldItemFilterLayer((LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)renderer, heldItemLayer));
                    layers.remove(heldItemLayer);
                }
            }
        }
        catch (ObfuscationReflectionHelper.UnableToAccessFieldException e) {
            Main.LOGGER.warn("Unable to access RenderLivingBase.layerRenderers, reason: " + e);
        }
    }

    public HeldItemFilterLayer(LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderer, RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> parent) {
        super(renderer);
        this.parent = parent;
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, AbstractClientPlayer entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack activeItem = entitylivingbaseIn.m_21211_();
        this.setStaffVisibility(activeItem, false);
        this.parent.m_6494_(matrixStackIn, bufferIn, packedLightIn, (Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        this.setStaffVisibility(activeItem, true);
    }

    private void setStaffVisibility(ItemStack itemStack, boolean visible) {
        WizardStaffItemHandler.getOptional(itemStack).ifPresent(handler -> handler.setVisible(visible));
    }
}

