/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import java.util.Random;
import mod.vemerion.wizardstaff.Magic.Magics;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import mod.vemerion.wizardstaff.staff.WizardStaffItem;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.RenderProperties;

public class WizardStaffLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public WizardStaffLayer(PlayerRenderer renderer) {
        super((RenderLayerParent)renderer);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack activeItem = player.m_21211_();
        Item item = activeItem.m_41720_();
        if (activeItem.m_41619_() || !(item instanceof WizardStaffItem)) {
            return;
        }
        WizardStaffTileEntityRenderer renderer = (WizardStaffTileEntityRenderer)RenderProperties.get((Item)item).getItemStackRenderer();
        ItemStack magic = WizardStaffItem.getMagic(activeItem);
        int maxDuration = activeItem.m_41779_();
        float duration = (float)maxDuration - ((float)player.m_21212_() - partialTicks + 1.0f);
        HumanoidArm side = player.m_7655_() == InteractionHand.MAIN_HAND ? player.m_5737_() : player.m_5737_().m_20828_();
        Magics.getInstance(true).get(magic).thirdPersonRenderer().render(renderer, duration, maxDuration, activeItem, matrixStackIn, bufferIn, packedLightIn, OverlayTexture.f_118083_, partialTicks, side);
    }

    public static void helicopter(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, int combinedOverlayIn, float partialTicks, HumanoidArm hand) {
        matrix.m_85836_();
        float offset = hand == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        matrix.m_85837_(-0.4 * (double)offset, -0.5, 0.0);
        matrix.m_85845_(new Quaternion(90.0f, 0.0f, duration / 5.0f * 360.0f, true));
        renderer.m_108829_(stack, ItemTransforms.TransformType.GUI, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85849_();
    }

    public static void surround(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, int combinedOverlayIn, float partialTicks, HumanoidArm hand) {
        matrix.m_85836_();
        matrix.m_85837_(0.0, 0.15, 0.0);
        matrix.m_85845_(new Quaternion(0.0f, duration / 15.0f * 360.0f, 0.0f, true));
        matrix.m_85845_(new Quaternion(0.0f, 0.0f, duration / 5.0f * 360.0f, true));
        matrix.m_85837_(0.0, -0.5, -0.5);
        renderer.m_108829_(stack, ItemTransforms.TransformType.GUI, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85849_();
    }

    public static void buildup(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, int combinedOverlayIn, float partialTicks, HumanoidArm hand) {
        float sideOffset = hand == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        float progress = duration / (float)maxDuration;
        Random random = new Random((int)duration % 5 + 5);
        Vec3 offset = new Vec3((random.nextDouble() * 0.6 - 0.3) * (double)progress, (random.nextDouble() * 0.6 - 0.3) * (double)progress, (random.nextDouble() * 0.6 - 0.3) * (double)progress);
        matrix.m_85836_();
        matrix.m_85837_(-0.1 * (double)sideOffset + Mth.m_14085_((double)0.0, (double)offset.m_7096_(), (double)partialTicks), 0.6 + Mth.m_14085_((double)0.0, (double)offset.m_7098_(), (double)partialTicks), -0.45 + Mth.m_14085_((double)0.0, (double)offset.m_7094_(), (double)partialTicks));
        matrix.m_85841_(-1.0f, -1.0f, 1.0f);
        renderer.m_108829_(stack, ItemTransforms.TransformType.GUI, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85849_();
    }

    public static void spinMagic(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, int combinedOverlayIn, float partialTicks, HumanoidArm hand) {
        matrix.m_85836_();
        float progress = duration / 5.0f;
        matrix.m_85841_(-1.0f, -1.0f, 1.0f);
        matrix.m_85837_(hand == HumanoidArm.RIGHT ? 0.38 : -0.38, -0.6, 0.0);
        matrix.m_85845_(new Quaternion(-75.0f, 0.0f, 0.0f, true));
        renderer.renderOnlyStaffNoPop(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85845_(new Quaternion(0.0f, progress * 360.0f, 0.0f, true));
        renderer.renderOnlyMagic(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85849_();
        matrix.m_85849_();
    }

    public static void buildupMagic(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, int combinedOverlayIn, float partialTicks, HumanoidArm hand) {
        float sideOffset = hand == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        float progress = duration / (float)maxDuration;
        Random random = new Random((int)duration % 5 + 5);
        Vec3 offset = new Vec3((random.nextDouble() * 0.6 - 0.3) * (double)progress, (random.nextDouble() * 0.6 - 0.3) * (double)progress, (random.nextDouble() * 0.6 - 0.3) * (double)progress);
        matrix.m_85836_();
        matrix.m_85837_(-0.14 * (double)sideOffset, 0.6, -0.45);
        matrix.m_85841_(-1.0f, -1.0f, 1.0f);
        renderer.renderOnlyStaffNoPop(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85837_(Mth.m_14085_((double)0.0, (double)offset.m_7096_(), (double)partialTicks), Mth.m_14085_((double)0.0, (double)offset.m_7098_(), (double)partialTicks), Mth.m_14085_((double)0.0, (double)offset.m_7094_(), (double)partialTicks));
        renderer.renderOnlyMagic(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85849_();
        matrix.m_85849_();
    }

    public static void swinging(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, int combinedOverlayIn, float partialTicks, HumanoidArm hand) {
        matrix.m_85836_();
        matrix.m_85841_(-1.0f, -1.0f, 1.0f);
        matrix.m_85845_(new Quaternion(Mth.m_14031_((float)(duration / 20.0f * (float)Math.PI * 2.0f)) * 15.0f - 65.0f, 0.0f, 0.0f, true));
        matrix.m_85837_(hand == HumanoidArm.RIGHT ? 0.4 : -0.4, -0.3, -0.65);
        renderer.m_108829_(stack, ItemTransforms.TransformType.GUI, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85849_();
    }

    public static void forwardShake(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, int combinedOverlayIn, float partialTicks, HumanoidArm hand) {
        float offset = hand == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        Random random = new Random((int)duration % 5 + 5);
        Vec3 shake = new Vec3(random.nextDouble() * 0.2 - 0.1, random.nextDouble() * 0.2 - 0.1, random.nextDouble() * 0.2 - 0.1);
        matrix.m_85836_();
        matrix.m_85841_(-1.0f, -1.0f, 1.0f);
        matrix.m_85837_(Mth.m_14085_((double)0.0, (double)shake.m_7096_(), (double)partialTicks), Mth.m_14085_((double)0.0, (double)shake.m_7098_(), (double)partialTicks), Mth.m_14085_((double)0.0, (double)shake.m_7094_(), (double)partialTicks));
        matrix.m_85837_((double)offset * 0.25, -0.7, -0.3);
        matrix.m_85845_(new Quaternion(-30.0f, 10.0f * offset, 20.0f * offset, true));
        renderer.m_108829_(stack, ItemTransforms.TransformType.GUI, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85849_();
    }

    public static void noRender(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, int combinedOverlayIn, float partialTicks, HumanoidArm hand) {
    }

    @FunctionalInterface
    public static interface RenderThirdPersonMagic {
        public void render(WizardStaffTileEntityRenderer var1, float var2, int var3, ItemStack var4, PoseStack var5, MultiBufferSource var6, int var7, int var8, float var9, HumanoidArm var10);
    }
}

