/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import java.util.Random;
import mod.vemerion.wizardstaff.init.ModItems;
import mod.vemerion.wizardstaff.init.ModLayerLocations;
import mod.vemerion.wizardstaff.model.AbstractWizardStaffModel;
import mod.vemerion.wizardstaff.model.NetherWizardStaffModel;
import mod.vemerion.wizardstaff.model.WizardStaffModel;
import mod.vemerion.wizardstaff.staff.WizardStaffItem;
import mod.vemerion.wizardstaff.staff.WizardStaffItemHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;

public class WizardStaffTileEntityRenderer
extends BlockEntityWithoutLevelRenderer {
    private final WizardStaffModel WIZARD_STAFF;
    private final NetherWizardStaffModel NETHER_WIZARD_STAFF;

    public WizardStaffTileEntityRenderer(BlockEntityRenderDispatcher pBlockEntityRenderDispatcher, EntityModelSet pEntityModelSet) {
        super(pBlockEntityRenderDispatcher, pEntityModelSet);
        this.WIZARD_STAFF = new WizardStaffModel(pEntityModelSet.m_171103_(ModLayerLocations.WIZARD_STAFF));
        this.NETHER_WIZARD_STAFF = new NetherWizardStaffModel(pEntityModelSet.m_171103_(ModLayerLocations.NETHER_WIZARD_STAFF));
    }

    public void m_108829_(ItemStack itemStackIn, ItemTransforms.TransformType transformType, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!this.shouldRender(itemStackIn)) {
            return;
        }
        this.renderOnlyStaffNoPop(itemStackIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        this.renderOnlyMagic(itemStackIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        matrixStackIn.m_85849_();
    }

    protected AbstractWizardStaffModel getModel(ItemStack itemStackIn) {
        return itemStackIn.m_41720_() == ModItems.WIZARD_STAFF ? this.WIZARD_STAFF : this.NETHER_WIZARD_STAFF;
    }

    private boolean shouldRender(ItemStack staff) {
        LazyOptional<WizardStaffItemHandler> optInteractionHandler = WizardStaffItemHandler.getOptional(staff);
        return optInteractionHandler.isPresent() && ((WizardStaffItemHandler)((Object)optInteractionHandler.orElse(null))).isVisible();
    }

    protected void renderOnlyStaffNoPop(ItemStack itemStackIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!this.shouldRender(itemStackIn)) {
            return;
        }
        matrixStackIn.m_85836_();
        matrixStackIn.m_85841_(1.0f, -1.0f, -1.0f);
        matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
        AbstractWizardStaffModel model = this.getModel(itemStackIn);
        VertexConsumer builder = ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)model.m_103119_(model.getTexture()), (boolean)false, (boolean)itemStackIn.m_41790_());
        model.m_7695_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void renderOnlyMagic(ItemStack itemStackIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ItemStack magic = WizardStaffItem.getMagic(itemStackIn);
        if (!this.shouldRender(itemStackIn)) {
            return;
        }
        float ageInTicks = (float)Minecraft.m_91087_().f_91074_.f_19797_ + Minecraft.m_91087_().m_91296_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, -3.1, 0.0);
        matrixStackIn.m_85845_(new Quaternion(180.0f, ageInTicks, 0.0f, true));
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        float magicScale = this.getModel(itemStackIn).getMagicScale();
        matrixStackIn.m_85841_(magicScale, magicScale, magicScale);
        itemRenderer.m_174269_(magic, ItemTransforms.TransformType.GUI, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, 0);
        matrixStackIn.m_85849_();
    }

    public static void buildup(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, int combinedOverlayIn, float partialTicks, HumanoidArm side) {
        float progress = duration / (float)maxDuration;
        Random random = new Random((int)duration % 5 + 5);
        Vec3 offset = new Vec3((random.nextDouble() * 0.6 - 0.3) * (double)progress, (random.nextDouble() * 0.6 - 0.3) * (double)progress, (random.nextDouble() * 0.6 - 0.3) * (double)progress);
        matrix.m_85836_();
        matrix.m_85837_(0.0 + Mth.m_14085_((double)0.0, (double)offset.m_7096_(), (double)partialTicks), -1.4 + Mth.m_14085_((double)0.0, (double)offset.m_7098_(), (double)partialTicks), -1.5 + Mth.m_14085_((double)0.0, (double)offset.m_7094_(), (double)partialTicks));
        renderer.m_108829_(stack, ItemTransforms.TransformType.GUI, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85849_();
    }

    public static void helicopter(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, int combinedOverlayIn, float partialTicks, HumanoidArm hand) {
        matrix.m_85836_();
        matrix.m_85845_(new Quaternion(0.0f, 0.0f, duration / 5.0f * 360.0f, true));
        matrix.m_85837_(0.0, -0.5, -1.5);
        renderer.m_108829_(stack, ItemTransforms.TransformType.GUI, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85849_();
    }

    public static void forward(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, int combinedOverlayIn, float partialTicks, HumanoidArm hand) {
        float offset = hand == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        float max = maxDuration > 20 ? 5.0f : (float)(maxDuration / 4);
        float progress = Mth.m_14036_((float)(duration / max), (float)0.0f, (float)1.0f);
        matrix.m_85836_();
        matrix.m_85845_(new Quaternion(Mth.m_144920_((float)0.0f, (float)-45.0f, (float)progress), 0.0f, Mth.m_144920_((float)0.0f, (float)(35.0f * offset), (float)progress), true));
        matrix.m_85837_((double)offset, -0.5 - (double)(progress / 5.0f), -1.2);
        renderer.m_108829_(stack, ItemTransforms.TransformType.GUI, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85849_();
    }

    public static void spinMagic(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, int combinedOverlayIn, float partialTicks, HumanoidArm hand) {
        matrix.m_85836_();
        float progress = duration / 5.0f;
        matrix.m_85837_(hand == HumanoidArm.RIGHT ? 1.0 : -1.0, -1.0, -1.2);
        renderer.renderOnlyStaffNoPop(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85845_(new Quaternion(0.0f, progress * 360.0f, 0.0f, true));
        renderer.renderOnlyMagic(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85849_();
        matrix.m_85849_();
    }

    public static void buildupMagic(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, int combinedOverlayIn, float partialTicks, HumanoidArm hand) {
        matrix.m_85836_();
        float progress = duration / (float)maxDuration;
        Random random = new Random((int)duration % 5 + 5);
        Vec3 offset = new Vec3((random.nextDouble() * 0.3 - 0.15) * (double)progress, (random.nextDouble() * 0.3 - 0.15) * (double)progress, (random.nextDouble() * 0.3 - 0.15) * (double)progress);
        matrix.m_85836_();
        matrix.m_85837_(hand == HumanoidArm.RIGHT ? 1.0 : -1.0, -1.0, -1.2);
        renderer.renderOnlyStaffNoPop(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85837_(0.0 + Mth.m_14085_((double)0.0, (double)offset.m_7096_(), (double)partialTicks), Mth.m_14085_((double)0.0, (double)offset.m_7098_(), (double)partialTicks), Mth.m_14085_((double)0.0, (double)offset.m_7094_(), (double)partialTicks));
        renderer.renderOnlyMagic(stack, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85849_();
        matrix.m_85849_();
    }

    public static void swinging(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, int combinedOverlayIn, float partialTicks, HumanoidArm hand) {
        matrix.m_85836_();
        matrix.m_85845_(new Quaternion(Mth.m_14031_((float)(duration / 20.0f * (float)Math.PI * 2.0f)) * 30.0f, 0.0f, 0.0f, true));
        matrix.m_85837_(hand == HumanoidArm.RIGHT ? 1.0 : -1.0, -1.0, -1.2);
        renderer.m_108829_(stack, ItemTransforms.TransformType.GUI, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85849_();
    }

    public static void forwardBuildup(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, int combinedOverlayIn, float partialTicks, HumanoidArm hand) {
        float handOffset = hand == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        float max = maxDuration > 20 ? 5.0f : (float)(maxDuration / 4);
        float progress = Mth.m_14036_((float)(duration / max), (float)0.0f, (float)1.0f);
        float buildupProgress = duration / (float)maxDuration;
        Random random = new Random((int)duration % 5 + 5);
        Vec3 offset = new Vec3((random.nextDouble() * 0.5 - 0.25) * (double)buildupProgress, (random.nextDouble() * 0.5 - 0.25) * (double)buildupProgress, (random.nextDouble() * 0.5 - 0.25) * (double)buildupProgress);
        matrix.m_85836_();
        matrix.m_85845_(new Quaternion(Mth.m_144920_((float)0.0f, (float)-45.0f, (float)progress), 0.0f, Mth.m_144920_((float)0.0f, (float)(35.0f * handOffset), (float)progress), true));
        matrix.m_85837_((double)handOffset + Mth.m_14085_((double)0.0, (double)offset.m_7096_(), (double)partialTicks), -0.5 - (double)(progress / 5.0f) + Mth.m_14085_((double)0.0, (double)offset.m_7098_(), (double)partialTicks), -1.2 + Mth.m_14085_((double)0.0, (double)offset.m_7094_(), (double)partialTicks));
        renderer.m_108829_(stack, ItemTransforms.TransformType.GUI, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85849_();
    }

    public static void forwardWaving(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, int combinedOverlayIn, float partialTicks, HumanoidArm hand) {
        float offset = hand == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        float maxForward = maxDuration > 20 ? 5.0f : (float)(maxDuration / 4);
        float forwardProgress = Mth.m_14036_((float)(duration / maxForward), (float)0.0f, (float)1.0f);
        Vec3 forward = new Vec3((double)Mth.m_144920_((float)0.0f, (float)-45.0f, (float)forwardProgress), 0.0, (double)Mth.m_144920_((float)0.0f, (float)(35.0f * offset), (float)forwardProgress));
        Vec3 waving = new Vec3((double)(Mth.m_14089_((float)(duration / 20.0f * (float)Math.PI * 2.0f)) * 10.0f), 0.0, (double)(Mth.m_14031_((float)(duration / 20.0f * (float)Math.PI * 2.0f)) * 10.0f));
        matrix.m_85836_();
        matrix.m_85837_(0.0, -0.5, 0.0);
        matrix.m_85845_(new Quaternion((float)(forward.f_82479_ + waving.f_82479_), (float)waving.f_82480_, (float)(forward.f_82481_ + waving.f_82481_), true));
        matrix.m_85837_(0.0, 0.5, 0.0);
        matrix.m_85837_((double)offset, -0.5 - (double)(forwardProgress / 5.0f), -1.2);
        renderer.m_108829_(stack, ItemTransforms.TransformType.GUI, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85849_();
    }

    public static void circling(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, int combinedOverlayIn, float partialTicks, HumanoidArm hand) {
        matrix.m_85836_();
        matrix.m_85837_(0.0, -1.0, 0.0);
        matrix.m_85845_(new Quaternion(Mth.m_14089_((float)(duration / 10.0f * (float)Math.PI * 2.0f)) * 10.0f, 0.0f, Mth.m_14031_((float)(duration / 10.0f * (float)Math.PI * 2.0f)) * 10.0f, true));
        matrix.m_85837_(0.0, 1.0, 0.0);
        matrix.m_85837_(hand == HumanoidArm.RIGHT ? 1.0 : -1.0, -1.0, -1.2);
        renderer.m_108829_(stack, ItemTransforms.TransformType.GUI, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85849_();
    }

    public static void surround(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, int combinedOverlayIn, float partialTicks, HumanoidArm hand) {
        matrix.m_85836_();
        matrix.m_85845_(new Quaternion(0.0f, duration / 40.0f * 360.0f, 0.0f, true));
        matrix.m_85845_(new Quaternion(0.0f, 0.0f, duration / 5.0f * 360.0f, true));
        matrix.m_85837_(0.0, 0.0, -1.0);
        renderer.m_108829_(stack, ItemTransforms.TransformType.GUI, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85849_();
    }

    public static void drill(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, int combinedOverlayIn, float partialTicks, HumanoidArm hand) {
        float offset = hand == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        float max = maxDuration > 20 ? 5.0f : (float)(maxDuration / 4);
        float progress = Mth.m_14036_((float)(duration / max), (float)0.0f, (float)1.0f);
        matrix.m_85836_();
        matrix.m_85837_((double)offset, -0.5 - (double)(progress / 5.0f), -1.2);
        matrix.m_85845_(new Quaternion(Mth.m_144920_((float)0.0f, (float)-45.0f, (float)progress), 0.0f, Mth.m_144920_((float)0.0f, (float)(35.0f * offset), (float)progress), true));
        float maxRotate = maxDuration > 20 ? 20.0f : (float)maxDuration;
        float rotation = duration < maxRotate ? duration * duration : maxRotate * maxRotate + maxRotate * 2.0f * (duration - maxRotate);
        matrix.m_85845_(new Quaternion(0.0f, rotation, 0.0f, true));
        renderer.m_108829_(stack, ItemTransforms.TransformType.GUI, matrix, buffer, light, combinedOverlayIn);
        matrix.m_85849_();
    }

    public static void noRender(WizardStaffTileEntityRenderer renderer, float duration, int maxDuration, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int light, int combinedOverlayIn, float partialTicks, HumanoidArm hand) {
    }

    @FunctionalInterface
    public static interface RenderFirstPersonMagic {
        public void render(WizardStaffTileEntityRenderer var1, float var2, int var3, ItemStack var4, PoseStack var5, MultiBufferSource var6, int var7, int var8, float var9, HumanoidArm var10);
    }
}

