/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.staff;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.Magics;
import mod.vemerion.wizardstaff.staff.WizardStaffScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;

public class SpellbookGui
extends GuiComponent
implements Widget,
GuiEventListener {
    private static final Component SEARCH_HINT = new TranslatableComponent("gui.wizardstaff.search_hint").m_130940_(ChatFormatting.ITALIC);
    private static final ResourceLocation GUI = new ResourceLocation("wizardstaff", "textures/gui/spellbook.png");
    private static final int X_OFFSET = 86;
    private static final int X_SIZE = 147;
    private static final int Y_SIZE = 166;
    private static final int BORDER_X = 16;
    private static final int BORDER_Y = 12;
    private static final int ITEM_BORDER_Y = 24;
    private static final int ITEM_SIZE = 20;
    private static final int ITEMS_PER_ROW = 6;
    private static final int ITEMS_PER_COLUMN = 6;
    private static final int ITEMS_PER_PAGE = 36;
    private static final int BUTTON_SIZE = 20;
    private static final int BUTTON_BOTTOM_OFFSET = 26;
    private static final int SEARCH_WIDTH = 107;
    private static final int SEARCH_HEIGHT = 14;
    private boolean isActive;
    private int left;
    private int top;
    private List<ItemButton> buttons;
    private List<ItemButton> searched;
    private Button next;
    private Button prev;
    private int page;
    private SpellDescription description;
    private EditBox search;
    WizardStaffScreen parent;
    Minecraft mc;
    private static final TranslatableComponent COST = new TranslatableComponent("gui.wizardstaff.cost");
    private static final TranslatableComponent EXP = new TranslatableComponent("gui.wizardstaff.exp");
    private static final TranslatableComponent DURATION = new TranslatableComponent("gui.wizardstaff.duration");
    private static final TranslatableComponent INFINITY = new TranslatableComponent("gui.wizardstaff.infinity");
    private static final TranslatableComponent SECONDS = new TranslatableComponent("gui.wizardstaff.seconds");

    public void init(WizardStaffScreen parent, int width, int height) {
        this.parent = parent;
        this.mc = parent.getMinecraft();
        this.left = (width - 147) / 2 - 86;
        this.top = (height - 166) / 2;
        this.buttons = new ArrayList<ItemButton>();
        this.searched = new ArrayList<ItemButton>();
        int i = 0;
        for (ItemStack stack : Magics.getInstance(true).getMagicItems()) {
            this.buttons.add(new ItemButton(this.left + 16 + i % 6 * 20, this.top + 24 + i / 6 * 20, 20, 20, stack));
            i = (i + 1) % 36;
        }
        this.next = new ImageButton(this.left + 73 + 20, this.top + 166 - 26, 20, 20, 0, 166, 20, GUI, b -> {
            if ((this.page + 1) * 36 < this.searched.size()) {
                ++this.page;
            }
        });
        this.prev = new ImageButton(this.left + 73 - 20 - 20, this.top + 166 - 26, 20, 20, 20, 166, 20, GUI, b -> {
            if (this.page > 0) {
                --this.page;
            }
        });
        this.initSearch();
        this.mc.f_91068_.m_90926_(true);
        if (this.description != null) {
            this.description.init(this.left, this.top);
        }
    }

    private void initSearch() {
        String text = this.search == null ? "" : this.search.m_94155_();
        this.search = new EditBox(this.mc.f_91062_, this.left + 26, this.top + 13, 107, 14, SEARCH_HINT);
        this.search.m_94199_(50);
        this.search.m_94144_(text);
        this.search.m_94182_(false);
        this.search.m_94194_(true);
        this.search.m_94202_(-1);
        this.filterButtons();
    }

    public void tick() {
        this.search.m_94120_();
    }

    public void onClose() {
        this.search = null;
        this.mc.f_91068_.m_90926_(false);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.isActive) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        this.m_93228_(matrixStack, this.left, this.top, 0, 0, 147, 166);
        if (this.description == null) {
            for (int i = this.page * 36; i < Math.min(this.searched.size(), (this.page + 1) * 36); ++i) {
                this.searched.get(i).m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            }
            this.next.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            this.prev.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            SpellbookGui.m_93143_((PoseStack)matrixStack, (int)(this.left + 12), (int)(this.top + 8), (int)0, (float)0.0f, (float)206.0f, (int)16, (int)16, (int)256, (int)256);
            if (!this.search.m_93696_() && this.search.m_94155_().isEmpty()) {
                SpellbookGui.m_93243_((PoseStack)matrixStack, (Font)this.mc.f_91062_, (Component)SEARCH_HINT, (int)(this.left + 26), (int)(this.top + 13), (int)-1);
            } else {
                this.search.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            }
            int maxPageNbr = Math.max(1, (int)Math.ceil((float)this.searched.size() / 36.0f));
            String pageText = this.page + 1 + "/" + maxPageNbr;
            int textWidth = this.mc.f_91062_.m_92895_(pageText);
            this.mc.f_91062_.m_92883_(matrixStack, pageText, (float)(this.left + 73) - (float)textWidth / 2.0f, (float)(this.top + 166 - 22), -1);
        } else {
            this.description.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.isActive) {
            return false;
        }
        if (this.description == null) {
            for (int i = this.page * 36; i < Math.min(this.searched.size(), (this.page + 1) * 36); ++i) {
                if (!this.searched.get(i).m_6375_(mouseX, mouseY, button)) continue;
                return true;
            }
            if (this.search.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            if (this.next.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            if (this.prev.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
        } else if (this.description.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.description == null) {
            if (this.search.m_7933_(keyCode, scanCode, modifiers)) {
                this.filterButtons();
                return true;
            }
            if (this.search.m_93696_() && keyCode != 256) {
                return true;
            }
        }
        return false;
    }

    private void filterButtons() {
        String filter = this.search.m_94155_().toLowerCase();
        this.searched = new ArrayList<ItemButton>();
        int i = 0;
        for (ItemButton b : this.buttons) {
            if (!b.stack.m_41786_().getString().toLowerCase().contains(filter) && !b.magicDescr.getName().getString().toLowerCase().contains(filter)) continue;
            this.searched.add(b);
            b.f_93620_ = this.left + 16 + i % 6 * 20;
            b.f_93621_ = this.top + 24 + i / 6 * 20;
            i = (i + 1) % 36;
        }
        this.page = 0;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.description == null && this.search.m_5534_(codePoint, modifiers)) {
            this.filterButtons();
            return true;
        }
        return false;
    }

    public void toggleActive() {
        this.isActive = !this.isActive;
    }

    public int updatePosition(int width, int sizeX) {
        if (this.isActive) {
            return 86 + (width - sizeX) / 2;
        }
        return (width - sizeX) / 2;
    }

    private class ItemButton
    extends AbstractButton {
        private ItemStack stack;
        private Magic.Description magicDescr;

        public ItemButton(int x, int y, int width, int height, ItemStack stack) {
            super(x, y, width, height, stack.m_41786_());
            this.stack = stack;
            this.magicDescr = Magics.getInstance(true).get(stack).getDescription();
        }

        public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.m_198029_()) {
                SpellbookGui.this.parent.m_96602_(matrixStack, this.m_6035_(), mouseX, mouseY);
            }
            SpellbookGui.this.mc.m_91291_().m_115203_(this.stack, this.f_93620_, this.f_93621_);
        }

        public void m_5691_() {
            SpellbookGui.this.description = new SpellDescription(this.magicDescr, this.stack, SpellbookGui.this.left, SpellbookGui.this.top);
        }

        public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
        }
    }

    private class SpellDescription
    implements Widget,
    GuiEventListener {
        private ItemStack stack;
        private Button back;
        private int left;
        private Button next;
        private Button prev;
        private int top;
        private Magic.Description magicDescr;
        private int page;
        List<FormattedCharSequence> title;
        List<FormattedCharSequence> text;
        String cost;
        String duration;
        private int linesPerPage;
        private int pageCount;

        public SpellDescription(Magic.Description magicDescr, ItemStack stack, int left, int top) {
            this.magicDescr = magicDescr;
            this.stack = stack;
            this.init(left, top);
        }

        public void init(int left, int top) {
            this.left = left;
            this.top = top;
            this.back = new ImageButton(left + 16, top + 12, 20, 20, 20, 166, 20, GUI, b -> {
                SpellbookGui.this.description = null;
            });
            this.next = new ImageButton(left + 73 + 20, top + 166 - 26, 20, 20, 0, 166, 20, GUI, b -> {
                if (this.page < this.pageCount - 1) {
                    ++this.page;
                }
            });
            this.prev = new ImageButton(left + 73 - 20 - 20, top + 166 - 26, 20, 20, 20, 166, 20, GUI, b -> {
                if (this.page > 0) {
                    --this.page;
                }
            });
            this.title = SpellbookGui.this.mc.f_91062_.m_92923_((FormattedText)this.magicDescr.getName(), 115);
            this.text = SpellbookGui.this.mc.f_91062_.m_92923_((FormattedText)this.magicDescr.getDescription(), 115);
            this.linesPerPage = 7 - this.title.size();
            this.pageCount = (int)Math.ceil((float)this.text.size() / (float)this.linesPerPage);
            DecimalFormat decimalFormat = new DecimalFormat("#.#");
            this.cost = COST.getString() + ": " + decimalFormat.format(this.magicDescr.getCost()) + " " + EXP.getString();
            float durationSeconds = (float)this.magicDescr.getDuration() / 20.0f;
            String durationTime = this.magicDescr.getDuration() >= 72000 ? INFINITY.getString() : decimalFormat.format(durationSeconds);
            this.duration = DURATION.getString() + ": " + durationTime + " " + SECONDS.getString();
        }

        public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.back.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            if (this.pageCount > 1) {
                this.next.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
                this.prev.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            }
            int y = this.top + 12;
            int textWidth = 0;
            SpellbookGui.this.mc.m_91291_().m_115203_(this.stack, this.left + 73 - 8, y);
            y += 20;
            for (FormattedCharSequence line : this.title) {
                textWidth = SpellbookGui.this.mc.f_91062_.m_92724_(line);
                SpellbookGui.this.mc.f_91062_.m_92877_(matrixStack, line, (float)(this.left + 73) - (float)textWidth / 2.0f, (float)y, -1);
                Objects.requireNonNull(SpellbookGui.this.mc.f_91062_);
                y += 9;
            }
            SpellbookGui.this.mc.f_91062_.m_92883_(matrixStack, this.cost, (float)(this.left + 16), (float)(y += 10), -1);
            SpellbookGui.this.mc.f_91062_.m_92883_(matrixStack, this.duration, (float)(this.left + 16), (float)(y += 10), -1);
            y += 20;
            for (int i = this.page * this.linesPerPage; i < Math.min(this.page * this.linesPerPage + this.linesPerPage, this.text.size()); ++i) {
                SpellbookGui.this.mc.f_91062_.m_92877_(matrixStack, this.text.get(i), (float)(this.left + 16), (float)y, -1);
                Objects.requireNonNull(SpellbookGui.this.mc.f_91062_);
                y += 9;
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.back.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            if (this.pageCount > 1 && this.next.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            return this.pageCount > 1 && this.prev.m_6375_(mouseX, mouseY, button);
        }
    }
}

