/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.staff;

import mod.vemerion.wizardstaff.staff.WizardStaffItemHandler;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class WizardStaffCapabilityProvider
implements ICapabilitySerializable<Tag> {
    private ItemStack staff;
    private LazyOptional<IItemHandler> instance = LazyOptional.of(this::getInteractionHandler);
    private WizardStaffItemHandler handler;

    public WizardStaffCapabilityProvider(ItemStack staff) {
        this.staff = staff;
    }

    private WizardStaffItemHandler getInteractionHandler() {
        if (this.handler == null) {
            this.handler = new WizardStaffItemHandler(this.staff);
        }
        return this.handler;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.instance);
    }

    public Tag serializeNBT() {
        return this.getInteractionHandler().serializeNBT();
    }

    public void deserializeNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            this.getInteractionHandler().deserializeNBT((CompoundTag)nbt);
        } else if (nbt instanceof ListTag) {
            this.legacyDeserialize((ListTag)nbt);
        }
    }

    private void legacyDeserialize(ListTag nbt) {
        if (nbt.size() < 1) {
            return;
        }
        CompoundTag compound = nbt.m_128728_(0);
        this.getInteractionHandler().insertItem(0, ItemStack.m_41712_((CompoundTag)compound), false);
    }
}

