/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.staff;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import mod.vemerion.wizardstaff.Magic.Magics;
import mod.vemerion.wizardstaff.capability.ScreenAnimations;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import mod.vemerion.wizardstaff.staff.WizardStaffCapabilityProvider;
import mod.vemerion.wizardstaff.staff.WizardStaffContainer;
import mod.vemerion.wizardstaff.staff.WizardStaffItemHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.network.NetworkHooks;

public class WizardStaffItem
extends Item {
    public WizardStaffItem(Item.Properties properties) {
        super(properties);
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new RenderProperties());
    }

    public static boolean magicPreventOtherUse(Level level, Player player, ItemStack staff) {
        return Magics.getInstance(level).get(WizardStaffItem.getMagic(staff)).magicPreventOtherUse(level, player, staff);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (playerIn.m_6047_()) {
            if (!worldIn.f_46443_) {
                boolean shouldAnimate = ScreenAnimations.getScreenAnimations(playerIn).shouldAnimate();
                SimpleMenuProvider provider = new SimpleMenuProvider((id, inventory, player) -> new WizardStaffContainer(id, inventory, WizardStaffItemHandler.get(itemstack), itemstack, shouldAnimate, handIn), this.m_7626_(itemstack));
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)provider, buffer -> {
                    buffer.writeBoolean(handIn == InteractionHand.MAIN_HAND);
                    buffer.writeBoolean(shouldAnimate);
                });
            }
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        playerIn.m_6672_(handIn);
        Magics.getInstance(worldIn).get(WizardStaffItem.getMagic(itemstack)).magicStart(worldIn, playerIn, itemstack);
        if (WizardStaffItem.magicPreventOtherUse(worldIn, playerIn, itemstack)) {
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public static ItemStack getMagic(ItemStack itemstack) {
        WizardStaffItemHandler handler = WizardStaffItemHandler.get(itemstack);
        return handler == null ? ItemStack.f_41583_ : handler.getCurrent();
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return oldStack == newStack;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new WizardStaffCapabilityProvider(stack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        if (EffectiveSide.get().isClient()) {
            ItemStack magic = WizardStaffItem.getMagic(stack);
            return Magics.getInstance(true).get(magic).getUseAnim(stack);
        }
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack stack) {
        ItemStack magic = WizardStaffItem.getMagic(stack);
        return Magics.getInstance(EffectiveSide.get().isClient()).get(magic).getUseDuration(stack);
    }

    public void m_5929_(Level worldIn, LivingEntity livingEntityIn, ItemStack stack, int count) {
        ItemStack magic = WizardStaffItem.getMagic(stack);
        if (livingEntityIn instanceof Player) {
            Magics.getInstance(worldIn).get(magic).magicTick(worldIn, (Player)livingEntityIn, stack, count);
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        ItemStack magic = WizardStaffItem.getMagic(stack);
        if (entityLiving instanceof Player) {
            return Magics.getInstance(worldIn).get(magic).magicFinish(worldIn, (Player)entityLiving, stack);
        }
        return stack;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack magic = WizardStaffItem.getMagic(context.m_43722_());
        if (context.m_43723_() == null) {
            return InteractionResult.PASS;
        }
        return Magics.getInstance(context.m_43725_()).get(magic).magicInteractBlock(context);
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        ItemStack magic = WizardStaffItem.getMagic(stack);
        if (entityLiving instanceof Player) {
            Magics.getInstance(worldIn).get(magic).magicCancel(worldIn, (Player)entityLiving, stack, timeLeft);
        }
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag result = new CompoundTag();
        CompoundTag tag = super.getShareTag(stack);
        CompoundTag cap = WizardStaffItemHandler.get(stack).serializeNBT();
        if (tag != null) {
            result.m_128365_("tag", (Tag)tag);
        }
        if (cap != null) {
            result.m_128365_("cap", (Tag)cap);
        }
        return result;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt == null) {
            stack.m_41751_(nbt);
        } else {
            stack.m_41751_(nbt.m_128469_("tag"));
            WizardStaffItemHandler.get(stack).deserializeNBT(nbt.m_128469_("cap"));
        }
    }

    private static class RenderProperties
    implements IItemRenderProperties {
        private RenderProperties() {
        }

        public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
            Minecraft mc = Minecraft.m_91087_();
            return new WizardStaffTileEntityRenderer(mc.m_167982_(), mc.m_167973_());
        }
    }
}

