/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.staff;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class WizardStaffItemHandler
extends ItemStackHandler {
    public static final int SLOT_COUNT = 3;
    private boolean isVisible = true;
    private ItemStack staff;
    private int current;

    public WizardStaffItemHandler(ItemStack staff) {
        super(3);
        this.staff = staff;
    }

    public void cycleCurrent() {
        int start = this.current;
        do {
            this.current = (this.current + 1) % 3;
        } while (this.getCurrent().m_41619_() && this.current != start);
    }

    public ItemStack extractCurrent() {
        return this.extractItem(this.current, 1, false);
    }

    public ItemStack insertCurrent(ItemStack insert) {
        return this.insertItem(this.current, insert, false);
    }

    public ItemStack getCurrent() {
        return this.getStackInSlot(this.current);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128405_("current", this.current);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        if (nbt.m_128441_("current")) {
            this.current = nbt.m_128451_("current");
        }
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    protected void onContentsChanged(int slot) {
        CompoundTag nbt;
        nbt.m_128379_("wizardstaff-dirty", !(nbt = this.staff.m_41784_()).m_128471_("wizardstaff-dirty"));
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public static WizardStaffItemHandler orNull(ItemStack staff) {
        return (WizardStaffItemHandler)((Object)staff.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null));
    }

    public static LazyOptional<WizardStaffItemHandler> getOptional(ItemStack staff) {
        IItemHandler handler;
        LazyOptional itemInteractionHandlerOpt = staff.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (itemInteractionHandlerOpt.isPresent() && (handler = (IItemHandler)itemInteractionHandlerOpt.orElse(null)) instanceof WizardStaffItemHandler) {
            return LazyOptional.of(() -> (WizardStaffItemHandler)handler);
        }
        return LazyOptional.empty();
    }

    public static WizardStaffItemHandler get(ItemStack staff) {
        IItemHandler handler = (IItemHandler)staff.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(() -> new IllegalArgumentException("ItemStack is missing wizard staff capability"));
        return (WizardStaffItemHandler)handler;
    }
}

