/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.staff;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import mod.vemerion.wizardstaff.capability.ScreenAnimations;
import mod.vemerion.wizardstaff.staff.SpellbookGui;
import mod.vemerion.wizardstaff.staff.WizardStaffContainer;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class WizardStaffScreen
extends AbstractContainerScreen<WizardStaffContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("wizardstaff", "textures/gui/staff_screen_new.png");
    private static final ResourceLocation ANIMATION_BUTTON = new ResourceLocation("wizardstaff", "textures/gui/animation_button.png");
    private static final ResourceLocation SPELLBOOK_BUTTON = new ResourceLocation("wizardstaff", "textures/gui/spellbook_button.png");
    private static final int ANIMATION_BOOK_Y = 173;
    private static final int BOOK_WIDTH = 50;
    private static final int BOOK_HEIGHT = 34;
    private static final int BOOK_X = 113;
    private static final int BOOK_Y = 16;
    private static final int ANIMATION_FACE_X = 176;
    private static final int FACE_WIDTH = 13;
    private static final int FACE_HEIGHT = 16;
    private static final int FACE_X = 27;
    private static final int FACE_Y = 40;
    private boolean buttonPressed;
    private boolean shouldAnimate;
    private Button toggleAnimationsButton;
    private Button spellbookButton;
    private SpellbookGui spellbook;

    public WizardStaffScreen(WizardStaffContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.shouldAnimate = ((WizardStaffContainer)this.f_97732_).shouldAnimate();
        this.spellbook = new SpellbookGui();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.spellbook.init(this, this.f_96543_, this.f_96544_);
        this.f_97735_ = this.spellbook.updatePosition(this.f_96543_, this.f_97726_);
        this.toggleAnimationsButton = (Button)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + this.f_97726_ - 18, this.f_97736_ + 9, 9, 9, 0, 0, 9, ANIMATION_BUTTON, button -> {
            this.buttonPressed = true;
            this.shouldAnimate = !this.shouldAnimate;
        }));
        this.spellbookButton = (Button)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + this.f_97726_ / 2 - 8, (int)((double)this.f_97736_ + (double)this.f_97727_ * 0.37), 16, 16, 0, 0, 16, SPELLBOOK_BUTTON, button -> {
            this.spellbook.toggleActive();
            this.f_97735_ = this.spellbook.updatePosition(this.f_96543_, this.f_97726_);
            ((ImageButton)button).m_94278_(this.f_97735_ + this.f_97726_ / 2 - 8, (int)((double)this.f_97736_ + (double)this.f_97727_ * 0.37));
            ((ImageButton)this.toggleAnimationsButton).m_94278_(this.f_97735_ + this.f_97726_ - 18, this.f_97736_ + 9);
        }));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.spellbook.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.spellbook.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.spellbook.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public void m_7861_() {
        if (this.buttonPressed && this.shouldAnimate != ((WizardStaffContainer)this.f_97732_).shouldAnimate()) {
            ScreenAnimations.sendMessage((Player)this.f_96541_.f_91074_, this.shouldAnimate);
        }
        this.spellbook.onClose();
        super.m_7861_();
    }

    public void m_181908_() {
        super.m_181908_();
        this.spellbook.tick();
    }

    protected void m_7286_(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(matrix, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (!this.buttonPressed && ((WizardStaffContainer)this.f_97732_).shouldAnimate() || this.buttonPressed && this.shouldAnimate) {
            this.animations(matrix, partialTicks);
        }
    }

    private void animations(PoseStack matrix, float partialTicks) {
        int ticks = this.f_96541_.f_91074_.f_19797_;
        if (ticks / 10 % 10 == 0) {
            this.m_93228_(matrix, this.f_97735_ + 113, this.f_97736_ + 16, 0 + 50 * (ticks % 5), 173 + ticks % 10 / 5 * 34, 50, 34);
        }
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.max(0.0f, Mth.m_14031_((float)(((float)ticks + partialTicks) / 160.0f * (float)Math.PI * 2.0f)) * 0.3f));
        this.m_93228_(matrix, this.f_97735_ + 27, this.f_97736_ + 40, 176, 0, 13, 16);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
    }

    protected void m_7027_(PoseStack matrix, int mouseX, int mouseY) {
        this.f_96547_.m_92883_(matrix, this.f_96539_.getString(), 6.0f, 12.0f, Color.DARK_GRAY.getRGB());
        this.f_96547_.m_92883_(matrix, this.f_169604_.getString(), 6.0f, 70.0f, Color.DARK_GRAY.getRGB());
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        this.m_7025_(matrix, mouseX, mouseY);
        this.spellbook.m_6305_(matrix, mouseX, mouseY, partialTicks);
        if (this.toggleAnimationsButton.m_198029_()) {
            this.m_96602_(matrix, WizardStaffScreen.guiComponent("toggle_animations"), mouseX, mouseY);
        }
        if (this.spellbookButton.m_198029_()) {
            this.m_96602_(matrix, WizardStaffScreen.guiComponent("toggle_spellbook"), mouseX, mouseY);
        }
    }

    static Component guiComponent(String key) {
        return new TranslatableComponent("gui.wizardstaff." + key);
    }
}

