/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2680;
import twilightforest.world.components.feature.BlockSpikeFeature;

public class IMCHandler {
    private static final ImmutableList.Builder<class_2680> ORE_BLOCKS_BUILDER = ImmutableList.builder();
    private static final ImmutableList.Builder<class_1799> LOADING_ICONS_BUILDER = ImmutableList.builder();
    private static final ImmutableMultimap.Builder<class_2680, class_2680> CRUMBLE_BLOCKS_BUILDER = ImmutableMultimap.builder();
    private static final ImmutableMultimap.Builder<Integer, BlockSpikeFeature.StalactiteEntry> STALACTITE_BUILDER = ImmutableMultimap.builder();

    private static void readFromTagList(class_2499 list, Consumer<class_2487> consumer) {
        for (int i = 0; i < list.size(); ++i) {
            consumer.accept(list.method_10602(i));
        }
    }

    private static void readStatesFromTagList(class_2499 list, Consumer<class_2680> consumer) {
        for (int i = 0; i < list.size(); ++i) {
            class_2680 state = class_2512.method_10681((class_2487)list.method_10602(i));
            if (state.method_26204() == class_2246.field_10124) continue;
            consumer.accept(state);
        }
    }

    private static void handleCrumble(class_2487 nbt) {
        class_2680 key = class_2512.method_10681((class_2487)nbt);
        if (key.method_26204() != class_2246.field_10124) {
            IMCHandler.readStatesFromTagList(nbt.method_10554("Crumbling", 10), value -> CRUMBLE_BLOCKS_BUILDER.put((Object)key, value));
        }
    }

    private static void handleOre(class_2487 nbt) {
        class_2680 nbtState = class_2512.method_10681((class_2487)nbt);
        if (nbtState.method_26204() != class_2246.field_10124) {
            ORE_BLOCKS_BUILDER.add((Object)nbtState);
            if (nbt.method_10573("Stalactite_Settings", 10)) {
                class_2487 settings = nbt.method_10562("Stalactite_Settings");
                int weight = IMCHandler.readInt(settings, "Weight", 15);
                int hillSize = IMCHandler.readInt(settings, "Hill_Size", 3);
                float size = IMCHandler.readFloat(settings, "Size", 0.7f);
                int maxLength = IMCHandler.readInt(settings, "Max_Length", 8);
                int minHeight = IMCHandler.readInt(settings, "Min_Height", 1);
                STALACTITE_BUILDER.put((Object)hillSize, (Object)new BlockSpikeFeature.StalactiteEntry(nbtState, size, maxLength, weight));
            }
        }
    }

    private static int readInt(class_2487 tag, String key, int defaultValue) {
        return tag.method_10573(key, 99) ? tag.method_10550(key) : defaultValue;
    }

    private static float readFloat(class_2487 tag, String key, float defaultValue) {
        return tag.method_10573(key, 99) ? tag.method_10583(key) : defaultValue;
    }

    public static ImmutableList<class_1799> getLoadingIconStacks() {
        return LOADING_ICONS_BUILDER.build();
    }

    public static ImmutableMultimap<Integer, BlockSpikeFeature.StalactiteEntry> getStalactites() {
        return STALACTITE_BUILDER.build();
    }
}

