/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import twilightforest.IMCHandler;
import twilightforest.TwilightForestMod;
import twilightforest.world.components.feature.BlockSpikeFeature;

public class TFConfig {
    public static Common COMMON_CONFIG;
    public static Client CLIENT_CONFIG;
    private static final String config = "twilightforest.config.";

    public static void onConfigChanged(ModConfig config) {
        if (config.getModId().equals("twilightforest")) {
            TFConfig.COMMON_CONFIG.portalLockingAdvancement = new class_2960((String)TFConfig.COMMON_CONFIG.portalAdvancementLock.get());
            TFConfig.build();
        }
    }

    @Deprecated
    public static class_2960 getPortalLockingAdvancement() {
        if (TFConfig.COMMON_CONFIG.portalLockingAdvancement == null) {
            TFConfig.COMMON_CONFIG.portalLockingAdvancement = new class_2960((String)TFConfig.COMMON_CONFIG.portalAdvancementLock.get());
        }
        return TFConfig.COMMON_CONFIG.portalLockingAdvancement;
    }

    public static void build() {
        TFConfig.CLIENT_CONFIG.LOADING_SCREEN.loadLoadingScreenIcons();
    }

    private static Optional<class_1799> parseItemStack(String string) {
        class_2960 id = class_2960.method_12829((String)string);
        if (id == null || !class_2378.field_11142.method_10250(id)) {
            return Optional.empty();
        }
        return Optional.of(new class_1799((class_1935)class_2378.field_11142.method_10223(id)));
    }

    private static Optional<class_2248> parseBlock(String string) {
        class_2960 id = class_2960.method_12829((String)string);
        if (id == null || !class_2378.field_11146.method_10250(id)) {
            return Optional.empty();
        }
        return Optional.ofNullable((class_2248)class_2378.field_11146.method_10223(id));
    }

    public static class Common {
        public Dimension DIMENSION = new Dimension();
        public ForgeConfigSpec.BooleanValue doCompat;
        public ForgeConfigSpec.ConfigValue<String> originDimension;
        public ForgeConfigSpec.BooleanValue allowPortalsInOtherDimensions;
        public ForgeConfigSpec.BooleanValue adminOnlyPortals;
        public ForgeConfigSpec.BooleanValue disablePortalCreation;
        public ForgeConfigSpec.BooleanValue checkPortalDestination;
        public ForgeConfigSpec.BooleanValue portalLightning;
        public ForgeConfigSpec.BooleanValue shouldReturnPortalBeUsable;
        public ForgeConfigSpec.ConfigValue<String> portalAdvancementLock;
        public ForgeConfigSpec.BooleanValue casketUUIDLocking;
        public ForgeConfigSpec.BooleanValue disableSkullCandles;
        public UncraftingStuff UNCRAFTING_STUFFS = new UncraftingStuff();
        public ShieldInteractions SHIELD_INTERACTIONS = new ShieldInteractions();
        public class_2960 portalLockingAdvancement;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings that are not reversible without consequences.").push("Dimension Settings");
            this.DIMENSION.newPlayersSpawnInTF = builder.translation("twilightforest.config.spawn_in_tf").comment("If true, players spawning for the first time will spawn in the Twilight Forest.").define("newPlayersSpawnInTF", false);
            this.DIMENSION.portalForNewPlayerSpawn = builder.translation("twilightforest.config.portal_for_new_player").comment("If true, the return portal will spawn for new players that were sent to the TF if `spawn_in_tf` is true.").define("portalForNewPlayer", true);
            this.DIMENSION.skylightForest = builder.translation("twilightforest.config.skylight_forest").worldRestart().comment("If true, Twilight Forest will generate as a void except for Major Structures").define("skylightForest", false);
            this.DIMENSION.skylightOaks = builder.translation("twilightforest.config.skylight_oaks").worldRestart().comment("If true, giant Twilight Oaks will also spawn in void worlds").define("skylightOaks", true);
            builder.pop().comment("Defines custom stalactites generated in hollow hills.\nFormat is \"modid:block size maxLength minHeight weight\", where the properties are:\nSize - the maximum length of the stalactite relative to the space between hill floor and ceiling,\nMax length - maximum length of a stalactite in blocks,\nMin height - minimum space between the hill floor and the stalactite to let it generate,\nWeight - how often it generates.\n\nFor example: \"minecraft:iron_ore 0.7 8 1 24\" would add a stalactite equal to the default iron ore stalactite.").push("Custom Hollow Hill Stalactites");
            this.DIMENSION.hollowHillStalactites.largeHill = builder.translation("twilightforest.config.large_hill").worldRestart().comment("Blocks generating as stalactites in large hills only").defineList("largeHill", new ArrayList(), s -> s instanceof String);
            this.DIMENSION.hollowHillStalactites.mediumHill = builder.translation("twilightforest.config.medium_hill").worldRestart().comment("Blocks generating as stalactites in medium and large hills").defineList("mediumHill", new ArrayList(), s -> s instanceof String);
            this.DIMENSION.hollowHillStalactites.smallHill = builder.translation("twilightforest.config.small_hill").worldRestart().comment("Blocks generating as stalactites in all hills").defineList("smallHill", new ArrayList(), s -> s instanceof String);
            this.DIMENSION.hollowHillStalactites.useConfigOnly = builder.translation("twilightforest.config.stalactite_config_only").worldRestart().comment("If true, default stalactites and stalactites defined by other mods will not be used.").define("useConfigOnly", false);
            builder.pop();
            this.doCompat = builder.worldRestart().comment("Should TF Compatibility load? Turn off if TF's Compatibility is causing crashes or if not desired.").define("doCompat", true);
            this.originDimension = builder.translation("twilightforest.config.origin_dimension").comment("The dimension you can always travel to the Twilight Forest from, as well as the dimension you will return to. Defaults to the overworld. (domain:regname).").define("originDimension", (Object)"minecraft:overworld");
            this.allowPortalsInOtherDimensions = builder.translation("twilightforest.config.portals_in_other_dimensions").comment("Allow portals to the Twilight Forest to be made outside of the 'origin' dimension. May be considered an exploit.").define("allowPortalsInOtherDimensions", false);
            this.adminOnlyPortals = builder.translation("twilightforest.config.admin_portals").comment("Allow portals only for admins (Operators). This severely reduces the range in which the mod usually scans for valid portal conditions, and it scans near ops only.").define("adminOnlyPortals", false);
            this.disablePortalCreation = builder.translation("twilightforest.config.portals").comment("Disable Twilight Forest portal creation entirely. Provided for server operators looking to restrict action to the dimension.").define("disablePortalCreation", false);
            this.checkPortalDestination = builder.translation("twilightforest.config.check_portal_destination").comment("Determines if new portals should be pre-checked for safety. If enabled, portals will fail to form rather than redirect to a safe alternate destination.\nNote that enabling this also reduces the rate at which portal formation checks are performed.").define("checkPortalDestination", false);
            this.portalLightning = builder.translation("twilightforest.config.portal_lighting").comment("Set this true if you want the lightning that zaps the portal to not set things on fire. For those who don't like fun.").define("portalLightning", false);
            this.shouldReturnPortalBeUsable = builder.translation("twilightforest.config.portal_return").comment("If false, the return portal will require the activation item.").define("shouldReturnPortalBeUsable", true);
            this.portalAdvancementLock = builder.translation("twilightforest.config.portal_unlocked_by_advancement").comment("Use a valid advancement resource location as a string. For example, using the string \"minecraft:story/mine_diamond\" will lock the portal behind the \"Diamonds!\" advancement. Invalid/Empty Advancement resource IDs will leave the portal entirely unlocked.").define("portalUnlockedByAdvancement", (Object)"");
            this.casketUUIDLocking = builder.worldRestart().translation("twilightforest.config.casket_uuid_locking").comment("If true, Keepsake Caskets that are spawned when a player dies will not be accessible by other players. Use this if you dont want people taking from other people's death caskets. NOTE: server operators will still be able to open locked caskets.").define("uuid_locking", false);
            this.disableSkullCandles = builder.translation("twilightforest.config.disable_skull_candles").comment("If true, disables the ability to make Skull Candles by right clicking a vanilla skull with a candle. Turn this on if you're having mod conflict issues for some reason.").define("skull_candles", false);
            builder.comment("Settings for all things related to the uncrafting table.").push("Uncrafting Table");
            this.UNCRAFTING_STUFFS.disableUncraftingRecipes = builder.worldRestart().translation("twilightforest.config.uncrafting_recipes").comment("If you don't want to disable uncrafting altogether, and would rather disable certain recipes, this is for you.\nTo add a recipe, add the mod id followed by the name of the recipe. You can check this in things like JEI.\nExample: \"twilightforest:moonworm_queen\" will disable uncrafting the moonworm queen into itself and 3 torchberries.\nIf an item has multiple crafting recipes and you wish to disable them all, add the item to the \"twilightforest:banned_uncraftables\" item tag.\nIf you have a problematic ingredient, like infested towerwood for example, add the item to the \"twilightforest:banned_uncrafting_ingredients\" item tag.").defineList("disableUncraftingRecipes", new ArrayList(), s -> s instanceof String);
            this.UNCRAFTING_STUFFS.blacklistedUncraftingModIds = builder.worldRestart().translation("twilightforest.config.uncrafting_mod_ids").comment("Here, you can disable all items from certain mods from being uncrafted.\nInput a valid mod id to disable all uncrafting recipes from that mod.\nExample: \"twilightforest\" will disable all uncrafting recipes from this mod.").defineList("blacklistedUncraftingModIds", new ArrayList(), s -> s instanceof String);
            this.UNCRAFTING_STUFFS.flipUncraftingModIdList = builder.worldRestart().translation("twilightforest.config.uncrafting_mod_id_flip").comment("If true, this will invert the above option from a blacklist to a whitelist.").define("flipIdList", false);
            this.UNCRAFTING_STUFFS.disableUncrafting = builder.worldRestart().translation("twilightforest.config.uncrafting").comment("Disable the uncrafting function of the uncrafting table. Recommended as a last resort if there's too many things to change about its behavior.").define("disableUncrafting", false);
            builder.pop();
            builder.comment("We recommend downloading the Shield Parry mod for parrying, but these controls remain for without.").push("Shield Parrying");
            this.SHIELD_INTERACTIONS.parryNonTwilightAttacks = builder.translation("twilightforest.config.parry_non_twilight").comment("Set to true to parry non-Twilight projectiles.").define("parryNonTwilightAttacks", false);
            this.SHIELD_INTERACTIONS.shieldParryTicksArrow = builder.translation("twilightforest.config.parry_window_arrow").comment("The amount of ticks after raising a shield that makes it OK to parry an arrow.").defineInRange("shieldParryTicksArrow", 40, 0, Integer.MAX_VALUE);
            this.SHIELD_INTERACTIONS.shieldParryTicksFireball = builder.translation("twilightforest.config.parry_window_fireball").comment("The amount of ticks after raising a shield that makes it OK to parry a fireball.").defineInRange("shieldParryTicksFireball", 40, 0, Integer.MAX_VALUE);
            this.SHIELD_INTERACTIONS.shieldParryTicksThrowable = builder.translation("twilightforest.config.parry_window_throwable").comment("The amount of ticks after raising a shield that makes it OK to parry a thrown item.").defineInRange("shieldParryTicksThrowable", 40, 0, Integer.MAX_VALUE);
            this.SHIELD_INTERACTIONS.shieldParryTicksBeam = builder.translation("twilightforest.config.parry_window_beam").defineInRange("shieldParryTicksBeam", 10, 0, Integer.MAX_VALUE);
            builder.pop();
        }

        public static class Dimension {
            public ForgeConfigSpec.BooleanValue newPlayersSpawnInTF;
            public ForgeConfigSpec.BooleanValue portalForNewPlayerSpawn;
            public ForgeConfigSpec.BooleanValue skylightForest;
            public ForgeConfigSpec.BooleanValue skylightOaks;
            public HollowHillStalactites hollowHillStalactites = new HollowHillStalactites();

            public static class HollowHillStalactites {
                public ForgeConfigSpec.ConfigValue<List<? extends String>> largeHill;
                public ForgeConfigSpec.ConfigValue<List<? extends String>> mediumHill;
                public ForgeConfigSpec.ConfigValue<List<? extends String>> smallHill;
                public ForgeConfigSpec.BooleanValue useConfigOnly;

                public void load() {
                    this.registerHill((List)this.smallHill.get(), 1);
                    this.registerHill((List)this.mediumHill.get(), 2);
                    this.registerHill((List)this.largeHill.get(), 3);
                }

                private void registerHill(List<? extends String> definitions, int tier) {
                    for (String string : definitions) {
                        if (this.parseStalactite(string, tier)) continue;
                        TwilightForestMod.LOGGER.warn("Invalid hollow hill stalactite definition: {}", (Object)string);
                    }
                }

                private boolean parseStalactite(String definition, int tier) {
                    String[] split = definition.split(" ");
                    if (split.length != 5) {
                        return false;
                    }
                    Optional<class_2248> block = TFConfig.parseBlock(split[0]);
                    if (block.isEmpty()) {
                        return false;
                    }
                    try {
                        BlockSpikeFeature.registerStalactite(tier, block.get().method_9564(), Float.parseFloat(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]));
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                    return true;
                }
            }
        }

        public static class UncraftingStuff {
            public ForgeConfigSpec.BooleanValue disableUncrafting;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> disableUncraftingRecipes;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedUncraftingModIds;
            public ForgeConfigSpec.BooleanValue flipUncraftingModIdList;
        }

        public static class ShieldInteractions {
            public ForgeConfigSpec.BooleanValue parryNonTwilightAttacks;
            public ForgeConfigSpec.IntValue shieldParryTicksArrow;
            public ForgeConfigSpec.IntValue shieldParryTicksFireball;
            public ForgeConfigSpec.IntValue shieldParryTicksThrowable;
            public ForgeConfigSpec.IntValue shieldParryTicksBeam;
        }
    }

    public static class Client {
        public ForgeConfigSpec.BooleanValue silentCicadas;
        public ForgeConfigSpec.BooleanValue firstPersonEffects;
        public ForgeConfigSpec.BooleanValue rotateTrophyHeadsGui;
        public ForgeConfigSpec.BooleanValue disableOptifineNagScreen;
        public ForgeConfigSpec.BooleanValue disableLockedBiomeToasts;
        public final LoadingScreen LOADING_SCREEN = new LoadingScreen();

        public Client(ForgeConfigSpec.Builder builder) {
            this.silentCicadas = builder.translation("twilightforest.config.silent_cicadas").comment("Make cicadas silent for those having sound library problems, or otherwise finding them annoying.").define("silentCicadas", false);
            this.firstPersonEffects = builder.translation("twilightforest.config.first_person_effects").comment("Controls whether various effects from the mod are rendered while in first-person view. Turn this off if you find them distracting.").define("firstPersonEffects", true);
            this.rotateTrophyHeadsGui = builder.translation("twilightforest.config.animate_trophyitem").comment("Rotate trophy heads on item model. Has no performance impact at all. For those who don't like fun.").define("rotateTrophyHeadsGui", true);
            this.disableOptifineNagScreen = builder.translation("twilightforest.config.optifine").comment("Disable the nag screen when Optifine is installed.").define("disableOptifineNagScreen", false);
            this.disableLockedBiomeToasts = builder.translation("twilightforest.config.locked_toasts").comment("Disables the toasts that appear when a biome is locked. Not recommended if you're not familiar with progression.").define("disableLockedBiomeToasts", false);
            builder.comment("Client only: Controls for the Loading screen").push("Loading Screen");
            this.LOADING_SCREEN.enable = builder.translation("twilightforest.config.loading_icon_enable").comment("Wobble the Loading icon. Has no performance impact at all. For those who don't like fun.").define("enable", true);
            this.LOADING_SCREEN.cycleLoadingScreenFrequency = builder.translation("twilightforest.config.loading_screen_swap_frequency").comment("How many ticks between each loading screen change. Set to 0 to not cycle at all.").defineInRange("cycleLoadingScreenFrequency", 0, 0, Integer.MAX_VALUE);
            this.LOADING_SCREEN.frequency = builder.translation("twilightforest.config.loading_icon_wobble_bounce_frequency").comment("Frequency of wobble and bounce.").defineInRange("frequency", 5.0, 0.0, Double.MAX_VALUE);
            this.LOADING_SCREEN.scale = builder.translation("twilightforest.config.loading_icon_scale").comment("Scale of whole bouncy loading icon.").defineInRange("scale", 3.0, 0.0, Double.MAX_VALUE);
            this.LOADING_SCREEN.scaleDeviation = builder.translation("twilightforest.config.loading_icon_bounciness").comment("How much the loading icon bounces.").defineInRange("scaleDeviation", 5.25, 0.0, Double.MAX_VALUE);
            this.LOADING_SCREEN.tiltRange = builder.translation("twilightforest.config.loading_icon_tilting").comment("How far the loading icon wobbles.").defineInRange("tiltRange", 11.25, 0.0, 360.0);
            this.LOADING_SCREEN.tiltConstant = builder.translation("twilightforest.config.loading_icon_tilt_pushback").comment("Pushback value to re-center the wobble of loading icon.").defineInRange("tiltConstant", 22.5, 0.0, 360.0);
            this.LOADING_SCREEN.loadingIconStacks = builder.translation("twilightforest.config.loading_icon_stacks").comment("List of items to be used for the wobbling Loading Icon. (domain:item).").defineList("loadingIconStacks", Arrays.asList("twilightforest:experiment_115", "twilightforest:magic_map", "twilightforest:charm_of_life_2", "twilightforest:charm_of_keeping_3", "twilightforest:phantom_helmet", "twilightforest:lamp_of_cinders", "twilightforest:carminite", "twilightforest:block_and_chain", "twilightforest:yeti_helmet", "twilightforest:hydra_chop", "twilightforest:magic_beans", "twilightforest:ironwood_raw", "twilightforest:naga_scale", "twilightforest:twilight_portal_miniature_structure", "twilightforest:lich_tower_miniature_structure", "twilightforest:knightmetal_block", "twilightforest:ghast_trap", "twilightforest:time_sapling", "twilightforest:transformation_sapling", "twilightforest:mining_sapling", "twilightforest:sorting_sapling", "twilightforest:rainboak_sapling", "twilightforest:borer_essence"), s -> s instanceof String && class_2960.method_12829((String)((String)s)) != null);
            builder.pop();
        }

        public static class LoadingScreen {
            public ForgeConfigSpec.BooleanValue enable;
            public ForgeConfigSpec.IntValue cycleLoadingScreenFrequency;
            public ForgeConfigSpec.DoubleValue frequency;
            public ForgeConfigSpec.DoubleValue scale;
            public ForgeConfigSpec.DoubleValue scaleDeviation;
            public ForgeConfigSpec.DoubleValue tiltRange;
            public ForgeConfigSpec.DoubleValue tiltConstant;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> loadingIconStacks;
            private ImmutableList<class_1799> loadingScreenIcons;

            public ImmutableList<class_1799> getLoadingScreenIcons() {
                return this.loadingScreenIcons;
            }

            void loadLoadingScreenIcons() {
                ImmutableList.Builder iconList = ImmutableList.builder();
                iconList.addAll(IMCHandler.getLoadingIconStacks());
                for (String s : (List)this.loadingIconStacks.get()) {
                    TFConfig.parseItemStack(s).ifPresent(arg_0 -> ((ImmutableList.Builder)iconList).add(arg_0));
                }
                this.loadingScreenIcons = iconList.build();
            }
        }
    }
}

