/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import io.github.fabricators_of_create.porting_lib.extensions.ITeleporter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_185;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2373;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2402;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import org.apache.commons.lang3.mutable.MutableInt;
import twilightforest.TFConfig;
import twilightforest.TFSounds;
import twilightforest.block.TFBlocks;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.network.MissingAdvancementToastPacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.PlayerHelper;
import twilightforest.world.NoReturnTeleporter;
import twilightforest.world.TFTeleporter;
import twilightforest.world.registration.TFGenerationSettings;

public class TFPortalBlock
extends class_2373
implements class_2402 {
    public static final class_2746 DISALLOW_RETURN = class_2746.method_11825((String)"is_one_way");
    private static final class_265 AABB = class_259.method_1078((class_238)new class_238(0.0, 0.0, 0.0, 1.0, 0.8125, 1.0));
    private static final int MIN_PORTAL_SIZE = 4;
    private static final int MAX_PORTAL_SIZE = 64;
    private static final HashSet<class_3222> playersNotified = new HashSet();
    private static final class_2588 PORTAL_UNWORTHY = new class_2588("twilightforest.ui.portal.unworthy");

    public TFPortalBlock(class_4970.class_2251 props) {
        super(props);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)DISALLOW_RETURN, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{DISALLOW_RETURN});
    }

    @Deprecated
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return AABB;
    }

    @Deprecated
    public class_265 method_9549(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return (Boolean)state.method_11654((class_2769)DISALLOW_RETURN) != false ? AABB : class_259.method_1073();
    }

    public class_3610 method_9545(class_2680 state) {
        return class_3612.field_15910.method_15728(1, false);
    }

    public boolean tryToCreatePortal(class_1937 world, class_2338 pos, class_1542 catalyst, @Nullable class_1657 player) {
        class_2680 state = world.method_8320(pos);
        if (this.canFormPortal(state) && world.method_8320(pos.method_10074()).method_26225()) {
            HashMap<class_2338, Boolean> blocksChecked = new HashMap<class_2338, Boolean>();
            blocksChecked.put(pos, true);
            MutableInt size = new MutableInt(0);
            if (TFPortalBlock.recursivelyValidatePortal(world, pos, blocksChecked, size, state) && size.intValue() >= 4) {
                boolean checkProgression;
                if (((Boolean)TFConfig.COMMON_CONFIG.checkPortalDestination.get()).booleanValue() && !TFTeleporter.isSafeAround(world, pos, (class_1297)catalyst, checkProgression = TFGenerationSettings.isProgressionEnforced(catalyst.field_6002))) {
                    if (player != null) {
                        player.method_7353((class_2561)new class_2588("twilightforest.twilight_portal.unsafe"), true);
                    }
                    return false;
                }
                catalyst.method_6983().method_7934(1);
                TFPortalBlock.causeLightning(world, pos, (Boolean)TFConfig.COMMON_CONFIG.portalLightning.get());
                for (Map.Entry checkedPos : blocksChecked.entrySet()) {
                    if (!((Boolean)checkedPos.getValue()).booleanValue()) continue;
                    world.method_8652((class_2338)checkedPos.getKey(), ((TFPortalBlock)((Object)TFBlocks.TWILIGHT_PORTAL.get())).method_9564(), 2);
                }
                return true;
            }
        }
        return false;
    }

    public boolean canFormPortal(class_2680 state) {
        return state.method_26164(BlockTagGenerator.PORTAL_POOL) || state.method_26204() == this && (Boolean)state.method_11654((class_2769)DISALLOW_RETURN) != false;
    }

    private static void causeLightning(class_1937 world, class_2338 pos, boolean fake) {
        class_1538 bolt = new class_1538(class_1299.field_6112, world);
        bolt.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
        bolt.method_29498(fake);
        world.method_8649((class_1297)bolt);
        if (fake && world instanceof class_3218) {
            double range = 3.0;
            List list = world.method_18467(class_1297.class, new class_238(pos).method_1014(range));
            for (class_1297 victim : list) {
                victim.method_5800((class_3218)world, bolt);
            }
        }
    }

    private static boolean recursivelyValidatePortal(class_1937 world, class_2338 pos, Map<class_2338, Boolean> blocksChecked, MutableInt portalSize, class_2680 poolBlock) {
        if (portalSize.incrementAndGet() > 64) {
            return false;
        }
        boolean isPoolProbablyEnclosed = true;
        for (int i = 0; i < 4 && portalSize.intValue() <= 64; ++i) {
            class_2338 positionCheck = pos.method_10093(class_2350.method_10139((int)i));
            if (blocksChecked.containsKey(positionCheck)) continue;
            class_2680 state = world.method_8320(positionCheck);
            if (state == poolBlock && world.method_8320(positionCheck.method_10074()).method_26225()) {
                blocksChecked.put(positionCheck, true);
                if (!isPoolProbablyEnclosed) continue;
                isPoolProbablyEnclosed = TFPortalBlock.recursivelyValidatePortal(world, positionCheck, blocksChecked, portalSize, poolBlock);
                continue;
            }
            if (TFPortalBlock.isGrassOrDirt(state) && TFPortalBlock.isNatureBlock(world.method_8320(positionCheck.method_10084()))) {
                blocksChecked.put(positionCheck, false);
                continue;
            }
            return false;
        }
        return isPoolProbablyEnclosed;
    }

    private static boolean isNatureBlock(class_2680 state) {
        return state.method_26164(BlockTagGenerator.PORTAL_DECO);
    }

    private static boolean isGrassOrDirt(class_2680 state) {
        return state.method_26164(BlockTagGenerator.PORTAL_EDGE);
    }

    @Deprecated
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 blockIn, class_2338 fromPos, boolean isMoving) {
        boolean good = world.method_8320(pos.method_10074()).method_26225();
        for (class_2350 facing : class_2350.class_2353.field_11062) {
            if (!good) break;
            class_2680 neighboringState = world.method_8320(pos.method_10093(facing));
            good = TFPortalBlock.isGrassOrDirt(neighboringState) || neighboringState == state;
        }
        if (!good) {
            world.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
            world.method_8652(pos, class_2246.field_10382.method_9564(), 3);
        }
    }

    public void method_9548(class_2680 state, class_1937 worldIn, class_2338 pos, class_1297 entity) {
        if (state == this.method_9564()) {
            class_161 requirement;
            class_3222 player;
            if (entity instanceof class_3222 && !(player = (class_3222)entity).method_7337() && !player.method_7325() && (requirement = PlayerHelper.getAdvancement((class_1657)player, TFConfig.getPortalLockingAdvancement())) != null && !PlayerHelper.doesPlayerHaveRequiredAdvancement((class_1657)player, requirement)) {
                player.method_7353((class_2561)PORTAL_UNWORTHY, true);
                if (!TFPortalBlock.isPlayerNotifiedOfRequirement(player)) {
                    class_185 info = requirement.method_686();
                    TFPacketHandler.CHANNEL.sendToClient((S2CPacket)(info == null ? new MissingAdvancementToastPacket((class_2561)new class_2588(".ui.advancement.no_title"), new class_1799((class_1935)TFBlocks.TWILIGHT_PORTAL_MINIATURE_STRUCTURE.get())) : new MissingAdvancementToastPacket(info.method_811(), info.method_821())), player);
                    TFPortalBlock.playerNotifiedOfRequirement(player);
                }
                return;
            }
            TFPortalBlock.attemptSendEntity(entity, false, true);
        }
    }

    public static boolean isPlayerNotifiedOfRequirement(class_3222 player) {
        return playersNotified.contains(player);
    }

    public static void playerNotifiedOfRequirement(class_3222 player) {
        playersNotified.add(player);
    }

    private static class_5321<class_1937> getDestination(class_1297 entity) {
        return !entity.method_5770().method_27983().method_29177().equals((Object)TFGenerationSettings.DIMENSION) ? TFGenerationSettings.DIMENSION_KEY : class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960((String)TFConfig.COMMON_CONFIG.originDimension.get()));
    }

    public static void attemptSendEntity(class_1297 entity, boolean forcedEntry, boolean makeReturnPortal) {
        if (!entity.method_5805() || entity.field_6002.field_9236) {
            return;
        }
        if (entity.method_5765() || entity.method_5782() || !entity.method_5822()) {
            return;
        }
        class_5321<class_1937> destination = TFPortalBlock.getDestination(entity);
        class_3218 serverWorld = entity.method_5770().method_8503().method_3847(destination);
        if (serverWorld == null) {
            return;
        }
        entity.changeDimension(serverWorld, (ITeleporter)(makeReturnPortal ? new TFTeleporter(forcedEntry) : new NoReturnTeleporter()));
        if (destination == TFGenerationSettings.DIMENSION_KEY && entity instanceof class_3222 && forcedEntry) {
            class_3222 playerMP = (class_3222)entity;
            playerMP.method_26284(destination, playerMP.method_24515(), playerMP.method_36454(), true, false);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 stateIn, class_1937 worldIn, class_2338 pos, Random rand) {
        int random = rand.nextInt(100);
        if (((Boolean)stateIn.method_11654((class_2769)DISALLOW_RETURN)).booleanValue() && random < 80) {
            return;
        }
        if (random == 0) {
            worldIn.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, TFSounds.PORTAL_WOOSH, class_3419.field_15245, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double xPos = (float)pos.method_10263() + rand.nextFloat();
            double yPos = (double)pos.method_10264() + 1.0;
            double zPos = (float)pos.method_10260() + rand.nextFloat();
            double xSpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            double ySpeed = rand.nextFloat();
            double zSpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            worldIn.method_8406((class_2394)class_2398.field_11214, xPos, yPos, zPos, xSpeed, ySpeed, zSpeed);
        }
    }

    public boolean method_10310(class_1922 iBlockReader, class_2338 blockPos, class_2680 blockState, class_3611 fluid) {
        return false;
    }

    public boolean method_10311(class_1936 iWorld, class_2338 blockPos, class_2680 blockState, class_3610 fluidState) {
        return false;
    }
}

