/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1571;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import twilightforest.TFSounds;
import twilightforest.block.GhastTrapBlock;
import twilightforest.block.TFBlocks;
import twilightforest.block.entity.TFBlockEntities;
import twilightforest.client.particle.TFParticleType;
import twilightforest.entity.boss.UrGhast;
import twilightforest.entity.monster.CarminiteGhastguard;
import twilightforest.entity.monster.CarminiteGhastling;

public class GhastTrapBlockEntity
extends class_2586 {
    private int counter = 0;
    private final List<CarminiteGhastling> dyingGhasts = new ArrayList<CarminiteGhastling>();
    private final Random rand = new Random();

    public GhastTrapBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)TFBlockEntities.GHAST_TRAP.get(), pos, state);
    }

    private static void tickInactive(class_1937 level, class_2338 pos, class_2680 state, GhastTrapBlockEntity te) {
        class_238 aabb = new class_238(pos).method_1009(10.0, 16.0, 10.0);
        List nearbyGhasts = level.method_18467(CarminiteGhastling.class, aabb);
        for (CarminiteGhastling ghast : nearbyGhasts) {
            if (ghast.field_6213 <= 0) continue;
            te.makeParticlesTo((class_1297)ghast);
            if (te.dyingGhasts.contains((Object)ghast)) continue;
            te.dyingGhasts.add(ghast);
        }
        int chargeLevel = Math.min(3, te.dyingGhasts.size());
        ++te.counter;
        if (level.field_9236) {
            if (te.counter % 20 == 0 && nearbyGhasts.size() > 0) {
                CarminiteGhastling highlight = (CarminiteGhastling)((Object)nearbyGhasts.get(te.rand.nextInt(nearbyGhasts.size())));
                te.makeParticlesTo((class_1297)highlight);
            }
            if (chargeLevel >= 1 && te.counter % 10 == 0) {
                ((GhastTrapBlock)((Object)TFBlocks.GHAST_TRAP.get())).sparkle(level, pos);
                level.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.5, (double)pos.method_10260() + 0.5, TFSounds.GHAST_TRAP_AMBIENT, class_3419.field_15245, 1.0f, 1.0f, false);
            }
            if (chargeLevel >= 2) {
                level.method_8406((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.1 + (double)te.rand.nextFloat() * 0.8, (double)pos.method_10264() + 1.05, (double)pos.method_10260() + 0.1 + (double)te.rand.nextFloat() * 0.8, (double)(te.rand.nextFloat() - te.rand.nextFloat()) * 0.05, 0.0, (double)(te.rand.nextFloat() - te.rand.nextFloat()) * 0.05);
                if (te.counter % 10 == 0) {
                    level.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.5, (double)pos.method_10260() + 0.5, TFSounds.GHAST_TRAP_AMBIENT, class_3419.field_15245, 1.2f, 0.8f, false);
                }
            }
            if (chargeLevel >= 3) {
                level.method_8406((class_2394)class_2398.field_11237, (double)pos.method_10263() + 0.1 + (double)te.rand.nextFloat() * 0.8, (double)pos.method_10264() + 1.05, (double)pos.method_10260() + 0.1 + (double)te.rand.nextFloat() * 0.8, (double)(te.rand.nextFloat() - te.rand.nextFloat()) * 0.05, 0.05, (double)(te.rand.nextFloat() - te.rand.nextFloat()) * 0.05);
                ((GhastTrapBlock)((Object)TFBlocks.GHAST_TRAP.get())).sparkle(level, pos);
                if (te.counter % 5 == 0) {
                    level.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.5, (double)pos.method_10260() + 0.5, TFSounds.GHAST_TRAP_AMBIENT, class_3419.field_15245, 1.5f, 2.0f, false);
                }
            }
        }
    }

    private void makeParticlesTo(class_1297 highlight) {
        double sx = (double)this.field_11867.method_10263() + 0.5;
        double sy = (double)this.field_11867.method_10264() + 1.0;
        double sz = (double)this.field_11867.method_10260() + 0.5;
        double dx = sx - highlight.method_23317();
        double dy = sy - highlight.method_23318() - (double)highlight.method_5751();
        double dz = sz - highlight.method_23321();
        for (int i = 0; i < 5; ++i) {
            this.field_11863.method_8406((class_2394)TFParticleType.GHAST_TRAP.get(), sx, sy, sz, -dx, -dy, -dz);
        }
    }

    public boolean isCharged() {
        return this.dyingGhasts.size() >= 3;
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, GhastTrapBlockEntity te) {
        if (((Boolean)state.method_11654((class_2769)GhastTrapBlock.ACTIVE)).booleanValue()) {
            GhastTrapBlockEntity.tickActive(level, pos, state, te);
        } else {
            GhastTrapBlockEntity.tickInactive(level, pos, state, te);
        }
    }

    public boolean method_11004(int event, int payload) {
        if (event == 0) {
            this.counter = 0;
            this.dyingGhasts.clear();
            return true;
        }
        if (event == 1) {
            this.counter = 0;
            return true;
        }
        return false;
    }

    private static void tickActive(class_1937 level, class_2338 pos, class_2680 state, GhastTrapBlockEntity te) {
        ++te.counter;
        if (level.field_9236) {
            if (te.counter > 100 && te.counter % 4 == 0) {
                level.method_8406((class_2394)TFParticleType.HUGE_SMOKE.get(), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.95, (double)pos.method_10260() + 0.5, Math.cos((double)te.counter / 10.0) * 0.05, 0.25, Math.sin((double)te.counter / 10.0) * 0.05);
            } else if (te.counter < 100) {
                double x = (double)pos.method_10263() + 0.5;
                double y = (double)pos.method_10264() + 1.0;
                double z = (double)pos.method_10260() + 0.5;
                double dx = Math.cos((double)te.counter / 10.0) * 2.5;
                double dy = 20.0;
                double dz = Math.sin((double)te.counter / 10.0) * 2.5;
                level.method_8406((class_2394)TFParticleType.GHAST_TRAP.get(), x, y, z, dx, dy, dz);
                level.method_8406((class_2394)TFParticleType.GHAST_TRAP.get(), x, y, z, -dx, dy, -dz);
                level.method_8406((class_2394)TFParticleType.GHAST_TRAP.get(), x, y, z, -dx, dy / 2.0, dz);
                level.method_8406((class_2394)TFParticleType.GHAST_TRAP.get(), x, y, z, dx, dy / 2.0, -dz);
                level.method_8406((class_2394)TFParticleType.GHAST_TRAP.get(), x, y, z, dx / 2.0, dy / 4.0, dz / 2.0);
                level.method_8406((class_2394)TFParticleType.GHAST_TRAP.get(), x, y, z, -dx / 2.0, dy / 4.0, -dz / 2.0);
            }
            if (te.counter < 30) {
                level.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.5, (double)pos.method_10260() + 0.5, TFSounds.GHAST_TRAP_WARMUP, class_3419.field_15245, 1.0f, 4.0f, false);
            } else if (te.counter < 80) {
                level.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.5, (double)pos.method_10260() + 0.5, TFSounds.GHAST_TRAP_ON, class_3419.field_15245, 1.0f, 4.0f, false);
            } else {
                level.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.5, (double)pos.method_10260() + 0.5, TFSounds.GHAST_TRAP_SPINDOWN, class_3419.field_15245, 1.0f, 4.0f, false);
            }
        } else {
            class_238 aabb = new class_238(pos.method_10086(16), pos.method_10086(16).method_10069(1, 1, 1)).method_1009(6.0, 16.0, 6.0);
            List nearbyGhasts = level.method_18467(class_1571.class, aabb);
            for (class_1571 ghast : nearbyGhasts) {
                if (ghast instanceof UrGhast) {
                    UrGhast urghast = (UrGhast)ghast;
                    urghast.setInTantrum(false);
                    ghast.field_5960 = true;
                    mx = (ghast.method_23317() - (double)pos.method_10263() - 0.5) * -0.1;
                    my = (ghast.method_23318() - (double)pos.method_10264() - 2.5) * -0.1;
                    mz = (ghast.method_23321() - (double)pos.method_10260() - 0.5) * -0.1;
                    ghast.method_18800(mx, my, mz);
                    if (te.rand.nextInt(10) == 0) {
                        ghast.method_5643(class_1282.field_5869, 7.0f);
                        urghast.resetDamageUntilNextPhase();
                    }
                } else {
                    mx = (ghast.method_23317() - (double)pos.method_10263() - 0.5) * -0.1;
                    my = (ghast.method_23318() - (double)pos.method_10264() - 1.5) * -0.1;
                    mz = (ghast.method_23321() - (double)pos.method_10260() - 0.5) * -0.1;
                    ghast.method_18800(mx, my, mz);
                    if (te.rand.nextInt(10) == 0) {
                        ghast.method_5643(class_1282.field_5869, 10.0f);
                    }
                }
                if (!(ghast instanceof CarminiteGhastguard)) continue;
                ((CarminiteGhastguard)ghast).setInTrap();
            }
            if (te.counter >= 120) {
                level.method_8501(pos, (class_2680)state.method_11657((class_2769)GhastTrapBlock.ACTIVE, (Comparable)Boolean.valueOf(false)));
                level.method_8427(pos, state.method_26204(), 1, 0);
            }
        }
    }
}

