/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import io.github.fabricators_of_create.porting_lib.event.client.FOVModifierCallback;
import io.github.fabricators_of_create.porting_lib.event.client.LivingEntityRenderEvents;
import io.github.fabricators_of_create.porting_lib.event.client.ModelsBakedCallback;
import io.github.fabricators_of_create.porting_lib.event.client.RenderTickStartCallback;
import io.github.fabricators_of_create.porting_lib.event.client.TextureStitchCallback;
import io.github.fabricators_of_create.porting_lib.util.RegistryObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1092;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3882;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5250;
import net.minecraft.class_5294;
import net.minecraft.class_5498;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_757;
import net.minecraft.class_897;
import net.minecraft.class_922;
import twilightforest.TFConfig;
import twilightforest.TFEventListener;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.client.BugModelAnimationHelper;
import twilightforest.client.PatchModelLoader;
import twilightforest.client.RenderEffect;
import twilightforest.client.TwilightForestRenderInfo;
import twilightforest.client.model.item.FullbrightBakedModel;
import twilightforest.client.model.item.TintIndexAwareFullbrightBakedModel;
import twilightforest.client.renderer.TFWeatherRenderer;
import twilightforest.client.renderer.entity.ShieldLayer;
import twilightforest.client.renderer.tileentity.TwilightChestRenderer;
import twilightforest.compat.TrinketsCompat;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.item.EnderBowItem;
import twilightforest.item.IceBowItem;
import twilightforest.item.SeekerBowItem;
import twilightforest.item.SkullCandleItem;
import twilightforest.item.TFItems;
import twilightforest.item.TripleBowItem;
import twilightforest.item.TrophyItem;

@Environment(value=EnvType.CLIENT)
public class TFClientEvents {
    private static final class_5250 WIP_TEXT_0 = new class_2588("twilightforest.misc.wip0").method_10862(class_2583.field_24360.method_10977(class_124.field_1061));
    private static final class_5250 WIP_TEXT_1 = new class_2588("twilightforest.misc.wip1").method_10862(class_2583.field_24360.method_10977(class_124.field_1061));
    private static final class_5250 NYI_TEXT = new class_2588("twilightforest.misc.nyi").method_10862(class_2583.field_24360.method_10977(class_124.field_1061));
    public static int time = 0;
    private static int rotationTickerI = 0;
    private static int sineTickerI = 0;
    public static float rotationTicker = 0.0f;
    public static float sineTicker = 0.0f;
    public static final float PI = (float)Math.PI;
    private static final int SINE_TICKER_BOUND = 627;

    public static void init() {
        ModBusEvents.registerModels();
        ModBusEvents.registerLoaders();
        WorldRenderEvents.LAST.register(TFClientEvents::renderWorldLast);
        ModelsBakedCallback.EVENT.register(ModBusEvents::modelBake);
        TextureStitchCallback.PRE.register(ModBusEvents::texStitch);
        RenderTickStartCallback.EVENT.register(TFClientEvents::renderTick);
        ClientTickEvents.END_CLIENT_TICK.register(TFClientEvents::clientTick);
        ItemTooltipCallback.EVENT.register(TFClientEvents::tooltipEvent);
        FOVModifierCallback.PARTIAL_FOV.register(TFClientEvents::FOVUpdate);
        LivingEntityRenderEvents.PRE.register((entity, renderer, partialRenderTick, matrixStack, buffers, light) -> {
            TFClientEvents.unrenderHeadWithTrophies(entity, renderer, partialRenderTick, matrixStack, buffers, light);
            return false;
        });
        LivingEntityRenderEvents.POST.register(TFClientEvents::unrenderHeadWithTrophies);
    }

    public static void renderWorldLast(WorldRenderContext context) {
        class_897 renderer;
        if (!((Boolean)TFConfig.CLIENT_CONFIG.firstPersonEffects.get()).booleanValue()) {
            return;
        }
        class_315 settings = class_310.method_1551().field_1690;
        if (settings.method_31044() != class_5498.field_26664 || settings.field_1842) {
            return;
        }
        class_1297 entity = class_310.method_1551().method_1560();
        if (entity instanceof class_1309 && (renderer = class_310.method_1551().method_1561().method_3953(entity)) instanceof class_922) {
            for (RenderEffect effect : RenderEffect.VALUES) {
                if (!effect.shouldRender((class_1309)entity, true)) continue;
                effect.render((class_1309)entity, (class_583<? extends class_1309>)((class_922)renderer).method_4038(), 0.0, 0.0, 0.0, context.tickDelta(), true);
            }
        }
    }

    public static void renderTick() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 != null && "twilightforest".equals(minecraft.field_1687.method_27983().method_29177().method_12836()) && minecraft.field_1705 != null) {
            minecraft.field_1705.field_2013 = 0.0f;
        }
        if (minecraft.field_1724 != null && TFEventListener.isRidingUnfriendly((class_1309)minecraft.field_1724) && minecraft.field_1705 != null) {
            minecraft.field_1705.method_1758(class_2585.field_24366, false);
        }
    }

    public static void clientTick(class_310 client) {
        TwilightForestRenderInfo tf;
        TFWeatherRenderer weatherRenderer;
        if (class_310.method_1551().method_1493()) {
            return;
        }
        ++time;
        class_310 mc = class_310.method_1551();
        float partial = mc.method_1488();
        rotationTickerI = rotationTickerI >= 359 ? 0 : rotationTickerI + 1;
        sineTickerI = sineTickerI >= 627 ? 0 : sineTickerI + 1;
        rotationTicker = (float)rotationTickerI + partial;
        sineTicker += partial;
        BugModelAnimationHelper.animate();
        class_5294 info = (class_5294)class_5294.field_24609.get((Object)TwilightForestMod.prefix("renderer"));
        if (!mc.method_1493() && mc.field_1687 != null && info instanceof TwilightForestRenderInfo && (weatherRenderer = (tf = (TwilightForestRenderInfo)info).getWeatherRenderHandler()) instanceof TFWeatherRenderer) {
            weatherRenderer.tick();
        }
    }

    public static void tooltipEvent(class_1799 item, class_1836 context, List<class_2561> lines) {
        if (!item.method_31573(ItemTagGenerator.WIP) && !item.method_31573(ItemTagGenerator.NYI)) {
            return;
        }
        if (item.method_31573(ItemTagGenerator.WIP)) {
            lines.add((class_2561)WIP_TEXT_0);
            lines.add((class_2561)WIP_TEXT_1);
        } else {
            lines.add((class_2561)NYI_TEXT);
        }
    }

    public static double FOVUpdate(class_757 renderer, class_4184 camera, double partialTick, double fov) {
        class_1792 useItem;
        class_1309 living;
        class_1297 class_12972 = camera.method_19331();
        if (class_12972 instanceof class_1309 && (living = (class_1309)class_12972).method_6115() && ((useItem = living.method_6030().method_7909()) instanceof TripleBowItem || useItem instanceof EnderBowItem || useItem instanceof IceBowItem || useItem instanceof SeekerBowItem)) {
            float f = ((float)living.method_6048() + (float)partialTick) / 20.0f;
            f = f > 1.0f ? 1.0f : f * f;
            return fov * (double)(1.0f - f * 0.15f);
        }
        return fov;
    }

    public static void unrenderHeadWithTrophies(class_1309 entity, class_922<?, ?> renderer, float partialRenderTick, class_4587 matrixStack, class_4597 buffers, int light) {
        class_583 class_5832;
        boolean visible;
        class_1799 stack = entity.method_6118(class_1304.field_6169);
        boolean bl = visible = !(stack.method_7909() instanceof TrophyItem) && !(stack.method_7909() instanceof SkullCandleItem) && !TFClientEvents.areCuriosEquipped(entity);
        if (!visible && (class_5832 = renderer.method_4038()) instanceof class_3882) {
            class_3882 headedModel = (class_3882)class_5832;
            headedModel.method_2838().field_3665 = false;
            class_583 class_5833 = renderer.method_4038();
            if (class_5833 instanceof class_572) {
                class_572 humanoidModel = (class_572)class_5833;
                humanoidModel.field_3394.field_3665 = false;
            }
        }
    }

    private static boolean areCuriosEquipped(class_1309 entity) {
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            return TrinketsCompat.isTrophyCurioEquipped(entity) || TrinketsCompat.isSkullCurioEquipped(entity);
        }
        return false;
    }

    public static class ModBusEvents {
        public static void registerLoaders() {
            ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> PatchModelLoader.INSTANCE);
        }

        @Deprecated
        public static void modelBake(class_1092 manager, Map<class_2960, class_1087> models, class_1088 loader) {
            ModBusEvents.fullbrightItem(models, TFItems.FIERY_INGOT);
            ModBusEvents.fullbrightItem(models, TFItems.FIERY_BOOTS);
            ModBusEvents.fullbrightItem(models, TFItems.FIERY_CHESTPLATE);
            ModBusEvents.fullbrightItem(models, TFItems.FIERY_HELMET);
            ModBusEvents.fullbrightItem(models, TFItems.FIERY_LEGGINGS);
            ModBusEvents.fullbrightItem(models, TFItems.FIERY_PICKAXE);
            ModBusEvents.fullbrightItem(models, TFItems.FIERY_SWORD);
            ModBusEvents.fullbrightItem(models, TFItems.RED_THREAD);
            ModBusEvents.fullbrightBlock(models, TFBlocks.FIERY_BLOCK);
            if (!FabricLoader.getInstance().isModLoaded("ctm")) {
                ModBusEvents.tintedFullbrightBlock(models, TFBlocks.PINK_CASTLE_RUNE_BRICK, FullbrightBakedModel::disableCache);
                ModBusEvents.tintedFullbrightBlock(models, TFBlocks.BLUE_CASTLE_RUNE_BRICK, FullbrightBakedModel::disableCache);
                ModBusEvents.tintedFullbrightBlock(models, TFBlocks.YELLOW_CASTLE_RUNE_BRICK, FullbrightBakedModel::disableCache);
                ModBusEvents.tintedFullbrightBlock(models, TFBlocks.VIOLET_CASTLE_RUNE_BRICK, FullbrightBakedModel::disableCache);
            }
            if (FabricLoader.getInstance().isModLoaded("immersiveengineering")) {
                // empty if block
            }
        }

        private static void fullbrightItem(Map<class_2960, class_1087> models, RegistryObject<class_1792> item) {
            ModBusEvents.fullbrightItem(models, item, f -> f);
        }

        private static void fullbrightItem(Map<class_2960, class_1087> models, RegistryObject<class_1792> item, UnaryOperator<FullbrightBakedModel> process) {
            ModBusEvents.fullbright(models, Objects.requireNonNull(item.getId()), "inventory", process);
        }

        private static void fullbrightBlock(Map<class_2960, class_1087> models, RegistryObject<class_2248> block) {
            ModBusEvents.fullbrightBlock(models, block, f -> f);
        }

        private static void fullbrightBlock(Map<class_2960, class_1087> models, RegistryObject<class_2248> block, UnaryOperator<FullbrightBakedModel> process) {
            ModBusEvents.fullbright(models, Objects.requireNonNull(block.getId()), "inventory", process);
            ModBusEvents.fullbright(models, Objects.requireNonNull(block.getId()), "", process);
        }

        private static void fullbright(Map<class_2960, class_1087> models, class_2960 rl, String state, UnaryOperator<FullbrightBakedModel> process) {
            class_1091 mrl = new class_1091(rl, state);
            models.put((class_2960)mrl, (class_1087)process.apply(new FullbrightBakedModel(models.get(mrl))));
        }

        private static void tintedFullbrightItem(Map<class_2960, class_1087> models, RegistryObject<class_1792> item) {
            ModBusEvents.tintedFullbrightItem(models, item, f -> f);
        }

        private static void tintedFullbrightItem(Map<class_2960, class_1087> models, RegistryObject<class_1792> item, UnaryOperator<FullbrightBakedModel> process) {
            ModBusEvents.tintedFullbright(models, Objects.requireNonNull(item.getId()), "inventory", process);
        }

        private static void tintedFullbrightBlock(Map<class_2960, class_1087> models, RegistryObject<class_2248> block) {
            ModBusEvents.tintedFullbrightBlock(models, block, f -> f);
        }

        private static void tintedFullbrightBlock(Map<class_2960, class_1087> models, RegistryObject<class_2248> block, UnaryOperator<FullbrightBakedModel> process) {
            ModBusEvents.tintedFullbright(models, Objects.requireNonNull(block.getId()), "inventory", process);
            ModBusEvents.tintedFullbright(models, Objects.requireNonNull(block.getId()), "", process);
        }

        private static void tintedFullbright(Map<class_2960, class_1087> models, class_2960 rl, String state, UnaryOperator<FullbrightBakedModel> process) {
            class_1091 mrl = new class_1091(rl, state);
            models.put((class_2960)mrl, (class_1087)process.apply(new TintIndexAwareFullbrightBakedModel(models.get(mrl))));
        }

        public static void texStitch(class_1059 map, Consumer<class_2960> spriteAdder) {
            if (class_4722.field_21709.equals((Object)map.method_24106())) {
                TwilightChestRenderer.MATERIALS.values().stream().flatMap(e -> e.values().stream()).map(class_4730::method_24147).forEach(spriteAdder::accept);
            }
            if (class_4722.field_21706.equals((Object)map.method_24106()) || class_4722.field_21707.equals((Object)map.method_24106())) {
                for (class_2582 pattern : class_2582.values()) {
                    if (!pattern.method_10947().startsWith("twilightforest")) continue;
                    spriteAdder.accept(pattern.method_22536(class_4722.field_21706.equals((Object)map.method_24106())));
                }
            }
            spriteAdder.accept(TwilightForestMod.prefix("block/mosspatch"));
        }

        public static void registerModels() {
            ModelLoadingRegistry.INSTANCE.registerModelProvider((manager, out) -> out.accept(ShieldLayer.LOC));
            ModelLoadingRegistry.INSTANCE.registerModelProvider((manager, out) -> out.accept(new class_1091(TwilightForestMod.prefix("trophy"), "inventory")));
            ModelLoadingRegistry.INSTANCE.registerModelProvider((manager, out) -> out.accept(new class_1091(TwilightForestMod.prefix("trophy_minor"), "inventory")));
            ModelLoadingRegistry.INSTANCE.registerModelProvider((manager, out) -> out.accept(new class_1091(TwilightForestMod.prefix("trophy_quest"), "inventory")));
            ModelLoadingRegistry.INSTANCE.registerModelProvider((manager, out) -> out.accept(TwilightForestMod.prefix("block/casket_obsidian")));
            ModelLoadingRegistry.INSTANCE.registerModelProvider((manager, out) -> out.accept(TwilightForestMod.prefix("block/casket_stone")));
            ModelLoadingRegistry.INSTANCE.registerModelProvider((manager, out) -> out.accept(TwilightForestMod.prefix("block/casket_basalt")));
        }
    }
}

