/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import twilightforest.item.MagicMapItem;

public class MapBiomesCommand {
    private static final DecimalFormat numberFormat = new DecimalFormat("#.00");
    private static final HashMap<class_1959, Color> BIOME2COLOR = new HashMap();

    private static void init() {
        if (!BIOME2COLOR.isEmpty()) {
            return;
        }
    }

    public static LiteralArgumentBuilder<class_2168> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"biomepng").requires(cs -> cs.method_9259(2))).executes(MapBiomesCommand::execute);
    }

    private static int execute(CommandContext<class_2168> source) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return -1;
        }
        MapBiomesCommand.init();
        HashMap<class_1959, Integer> biomeCount = new HashMap<class_1959, Integer>();
        BufferedImage img = new BufferedImage(4096, 4096, 1);
        int progressUpdate = img.getHeight() / 8;
        for (int x = 0; x < img.getHeight(); ++x) {
            for (int z = 0; z < img.getWidth(); ++z) {
                class_1959 b = (class_1959)((class_2168)source.getSource()).method_9225().method_16359(x - 2048, 0, z - 2048).comp_349();
                Color color = BIOME2COLOR.get(b);
                if (color == null) {
                    int colorInt = MagicMapItem.getBiomeColor(b);
                    if (colorInt == 0) {
                        colorInt = b.method_8711(0.0, 0.0);
                    }
                    color = new Color(colorInt | 0xFF000000);
                    BIOME2COLOR.put(b, color);
                }
                if (!biomeCount.containsKey(b)) {
                    biomeCount.put(b, 0);
                } else {
                    biomeCount.put(b, (Integer)biomeCount.get(b) + 1);
                }
                img.setRGB(x, z, color.getRGB());
            }
            if (x % progressUpdate != 0) continue;
            ((class_2168)source.getSource()).method_9226((class_2561)new class_2588((double)x / (double)img.getHeight() * 100.0 + "% Done mapping"), true);
        }
        ((class_2168)source.getSource()).method_9226((class_2561)new class_2585("Approximate biome-block counts within an 2048x2048 region"), true);
        int totalCount = biomeCount.values().stream().mapToInt(i -> i).sum();
        biomeCount.forEach((biome, integer) -> ((class_2168)source.getSource()).method_9226((class_2561)new class_2585(biome.toString()).method_27693(": " + integer + class_124.field_1080 + " (" + numberFormat.format((double)integer.intValue() / (double)totalCount * 100.0) + "%)"), true));
        Path p = Paths.get("biomemap.png", new String[0]);
        try {
            ImageIO.write((RenderedImage)img, "png", p.toAbsolutePath().toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
        ((class_2168)source.getSource()).method_9226((class_2561)new class_2585("Image saved!"), true);
        return 1;
    }
}

