/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3754;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_5458;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7059;
import org.slf4j.Logger;
import twilightforest.TwilightForestMod;
import twilightforest.world.components.biomesources.TFBiomeProvider;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;
import twilightforest.world.components.chunkgenerators.warp.TerrainPoint;
import twilightforest.world.registration.TFGenerationSettings;
import twilightforest.world.registration.TFNoiseGenerationSettings;
import twilightforest.world.registration.biomes.BiomeKeys;
import twilightforest.world.registration.biomes.BiomeMaker;

public record WorldGenerator(class_2403 generator) implements class_2405
{
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public void method_10319(class_2408 cache) {
        Path path = this.generator.method_10313();
        class_5455 registryaccess = class_5458.field_36476;
        class_6903 dynamicops = class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_5455)registryaccess);
        class_2378<class_5363> twilight = this.registerTFSettings(registryaccess);
        class_2370 biomeRegistry = new class_2370(class_2378.field_25114, Lifecycle.experimental(), null);
        Map<class_2960, class_1959> biomes = this.getBiomes();
        biomes.forEach((arg_0, arg_1) -> WorldGenerator.lambda$run$0((class_2385)biomeRegistry, arg_0, arg_1));
        StreamSupport.stream(class_5455.method_39674().spliterator(), false).filter(r -> registryaccess.method_30527(r.comp_293()).isPresent() && !r.comp_293().equals(class_2378.field_25114)).forEach(arg_0 -> WorldGenerator.lambda$run$2(cache, path, registryaccess, (DynamicOps)dynamicops, arg_0));
        LOGGER.info("Dumping real BIOME_REGISTRY");
        WorldGenerator.dumpRegistry(path, cache, (DynamicOps<JsonElement>)dynamicops, class_2378.field_25114, biomeRegistry, class_1959.field_25819);
        LOGGER.info("Dumping real LEVEL_STEM_REGISTRY");
        WorldGenerator.dumpRegistry(path, cache, (DynamicOps<JsonElement>)dynamicops, class_2378.field_25490, twilight, class_5363.field_25411);
    }

    private static <T> void dumpRegistryCap(class_2408 cache, Path path, class_5455 access, DynamicOps<JsonElement> ops, class_5455.class_5456<T> data) {
        LOGGER.info("Dumping: {}", (Object)data.comp_293());
        WorldGenerator.dumpRegistry(path, cache, ops, data.comp_293(), access.method_33309(data.comp_293()), data.comp_294());
    }

    private class_2378<class_5363> registerTFSettings(class_5455 access) {
        class_2370 writableregistry = new class_2370(class_2378.field_25490, Lifecycle.experimental(), null);
        class_2378 biomeRegistry = access.method_30530(class_2378.field_25114);
        class_6880 noiseGenSettings = access.method_30530(class_2378.field_26374).method_40268(TFNoiseGenerationSettings.TWILIGHT_NOISE_GEN.getKey());
        class_3754 forestChunkGen = new class_3754(access.method_30530(class_2378.field_37227), access.method_30530(class_2378.field_35433), (class_1966)new TFBiomeProvider(0L, (class_2378<class_1959>)biomeRegistry, this.makeBiomeList((class_2378<class_1959>)biomeRegistry), -1.25f, 2.5f), 0L, noiseGenSettings);
        writableregistry.method_10272(TFGenerationSettings.WORLDGEN_KEY, (Object)new class_5363(class_6880.method_40223((Object)this.twilightDimType()), (class_2794)new ChunkGeneratorTwilight((class_2794)forestChunkGen, (class_2378<class_7059>)access.method_30530(class_2378.field_37227), (class_6880<class_5284>)noiseGenSettings, true, true, Optional.of(12), true)), Lifecycle.experimental());
        return writableregistry;
    }

    private class_2378<class_5363> registerSkylightSettings(class_5455 access) {
        class_2370 writableregistry = new class_2370(class_2378.field_25490, Lifecycle.experimental(), null);
        class_2370 biomeRegistry = new class_2370(class_2378.field_25114, Lifecycle.experimental(), null);
        class_6880 noiseGenSettings = access.method_30530(class_2378.field_26374).method_40268(TFNoiseGenerationSettings.SKYLIGHT_NOISE_GEN.getKey());
        class_3754 forestChunkGen = new class_3754(access.method_30530(class_2378.field_37227), access.method_30530(class_2378.field_35433), (class_1966)new TFBiomeProvider(0L, (class_2378<class_1959>)biomeRegistry, this.makeBiomeList((class_2378<class_1959>)biomeRegistry), -1.25f, 2.5f), 4L, noiseGenSettings);
        writableregistry.method_10272(class_5321.method_29179((class_5321)class_2378.field_25490, (class_2960)TwilightForestMod.prefix("skylight_forest")), (Object)new class_5363(class_6880.method_40223((Object)this.twilightDimType()), (class_2794)new ChunkGeneratorTwilight((class_2794)forestChunkGen, (class_2378<class_7059>)access.method_30530(class_2378.field_37227), (class_6880<class_5284>)noiseGenSettings, true, true, Optional.of(12), true)), Lifecycle.stable());
        return writableregistry;
    }

    private static <E, T extends class_2378<E>> void dumpRegistry(Path path, class_2408 cache, DynamicOps<JsonElement> ops, class_5321<? extends T> key, T registry, Encoder<E> encoder) {
        for (Map.Entry entry : registry.method_29722()) {
            if (!((class_5321)entry.getKey()).method_29177().method_12836().equals("twilightforest")) continue;
            LOGGER.info("\t\t{}", (Object)((class_5321)entry.getKey()).method_29177().method_12832());
            Path otherPath = WorldGenerator.createPath(path, key.method_29177(), ((class_5321)entry.getKey()).method_29177());
            WorldGenerator.dumpValue(otherPath, cache, ops, encoder, entry.getValue());
        }
    }

    private static <E> void dumpValue(Path path, class_2408 cache, DynamicOps<JsonElement> ops, Encoder<E> encoder, E entry) {
        try {
            Optional optional = encoder.encodeStart(ops, entry).resultOrPartial(p_206405_ -> LOGGER.error("Couldn't serialize element {}: {}", (Object)path, p_206405_));
            if (optional.isPresent()) {
                JsonObject object;
                if (((JsonElement)optional.get()).isJsonObject() && (object = ((JsonElement)optional.get()).getAsJsonObject()).has("generator") && object.get("generator").isJsonObject()) {
                    JsonObject wrapped_generator;
                    JsonObject generator = object.getAsJsonObject("generator");
                    if (generator.has("use_overworld_seed")) {
                        generator.remove("use_overworld_seed");
                        generator.addProperty("use_overworld_seed", Boolean.valueOf(true));
                    }
                    if (generator.has("wrapped_generator") && (wrapped_generator = generator.getAsJsonObject("wrapped_generator")).has("biome_source")) {
                        wrapped_generator.getAsJsonObject("biome_source").remove("seed");
                    }
                }
                class_2405.method_10320((Gson)GSON, (class_2408)cache, (JsonElement)((JsonElement)optional.get()), (Path)path);
            }
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't save element {}", (Object)path, (Object)ioexception);
        }
    }

    private static Path createPath(Path path, class_2960 registry, class_2960 entry) {
        return path.resolve("data").resolve(entry.method_12836()).resolve(registry.method_12832()).resolve(entry.method_12832() + ".json");
    }

    public String method_10321() {
        return "Worldgen";
    }

    private class_2874 twilightDimType() {
        return class_2874.method_32922((OptionalLong)OptionalLong.of(13000L), (boolean)true, (boolean)false, (boolean)false, (boolean)true, (double)0.125, (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (int)-32, (int)288, (int)288, (class_6862)class_3481.field_25588, (class_2960)TwilightForestMod.prefix("renderer"), (float)0.0f);
    }

    private Map<class_2960, class_1959> getBiomes() {
        return BiomeMaker.BIOMES.entrySet().stream().collect(Collectors.toMap(entry -> ((class_5321)entry.getKey()).method_29177(), Map.Entry::getValue));
    }

    private List<Pair<TerrainPoint, class_6880<class_1959>>> makeBiomeList(class_2378<class_1959> registry) {
        return List.of(this.pairBiome(registry, 0.025f, 0.05f, BiomeKeys.FOREST), this.pairBiome(registry, 0.1f, 0.2f, BiomeKeys.DENSE_FOREST), this.pairBiome(registry, 0.0625f, 0.05f, BiomeKeys.FIREFLY_FOREST), this.pairBiome(registry, 0.005f, 0.005f, BiomeKeys.CLEARING), this.pairBiome(registry, 0.05f, 0.1f, BiomeKeys.OAK_SAVANNAH), this.pairBiome(registry, -1.65f, 0.25f, BiomeKeys.STREAM), this.pairBiome(registry, -1.97f, 0.0f, BiomeKeys.LAKE), this.pairBiome(registry, 0.025f, 0.05f, BiomeKeys.MUSHROOM_FOREST), this.pairBiome(registry, 0.05f, 0.05f, BiomeKeys.DENSE_MUSHROOM_FOREST), this.pairBiome(registry, 0.025f, 0.05f, BiomeKeys.ENCHANTED_FOREST), this.pairBiome(registry, 0.025f, 0.05f, BiomeKeys.SPOOKY_FOREST), this.pairBiome(registry, -0.9f, 0.15f, BiomeKeys.SWAMP), this.pairBiome(registry, -0.2f, 0.05f, BiomeKeys.FIRE_SWAMP), this.pairBiome(registry, 0.025f, 0.005f, BiomeKeys.DARK_FOREST), this.pairBiome(registry, 0.025f, 0.005f, BiomeKeys.DARK_FOREST_CENTER), this.pairBiome(registry, 0.05f, 0.15f, BiomeKeys.SNOWY_FOREST), this.pairBiome(registry, 0.025f, 0.05f, BiomeKeys.GLACIER), this.pairBiome(registry, 3.0f, 0.25f, BiomeKeys.HIGHLANDS), this.pairBiome(registry, 7.0f, 0.1f, BiomeKeys.THORNLANDS), this.pairBiome(registry, 13.75f, 0.025f, BiomeKeys.FINAL_PLATEAU));
    }

    private Pair<TerrainPoint, class_6880<class_1959>> pairBiome(class_2378<class_1959> registry, float depth, float scale, class_5321<class_1959> key) {
        return Pair.of((Object)new TerrainPoint(depth, scale), (Object)class_6880.class_6883.method_40234(registry, key));
    }

    private static /* synthetic */ void lambda$run$2(class_2408 cache, Path path, class_5455 registryaccess, DynamicOps dynamicops, class_5455.class_5456 data) {
        WorldGenerator.dumpRegistryCap(cache, path, registryaccess, (DynamicOps<JsonElement>)dynamicops, data);
    }

    private static /* synthetic */ void lambda$run$0(class_2385 biomeRegistry, class_2960 rl, class_1959 biome) {
        biomeRegistry.method_10272(class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)rl), (Object)biome, Lifecycle.experimental());
    }
}

