/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import io.github.fabricators_of_create.porting_lib.util.CustomMapItem;
import javax.annotation.Nullable;
import me.alphamode.forgetags.Tags;
import me.pepperbell.simplenetworking.S2CPacket;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2683;
import net.minecraft.class_2818;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3620;
import net.minecraft.class_5321;
import twilightforest.TFMazeMapData;
import twilightforest.item.TFItems;
import twilightforest.network.MazeMapPacket;
import twilightforest.network.TFPacketHandler;

public class MazeMapItem
extends class_1806
implements CustomMapItem {
    public static final String STR_ID = "mazemap";
    private static final int YSEARCH = 3;
    protected final boolean mapOres;

    protected MazeMapItem(boolean mapOres, class_1792.class_1793 props) {
        super(props);
        this.mapOres = mapOres;
    }

    public static class_1799 setupNewMap(class_1937 world, int worldX, int worldZ, byte scale, boolean trackingPosition, boolean unlimitedTracking, int worldY, boolean mapOres) {
        class_1799 itemstack = new class_1799(mapOres ? (class_1935)TFItems.FILLED_ORE_MAP.get() : (class_1935)TFItems.FILLED_MAZE_MAP.get());
        MazeMapItem.createMapData(itemstack, world, worldX, worldZ, scale, trackingPosition, unlimitedTracking, (class_5321<class_1937>)world.method_27983(), worldY);
        return itemstack;
    }

    @Nullable
    public static TFMazeMapData getData(class_1799 stack, class_1937 world) {
        Integer id = MazeMapItem.method_8003((class_1799)stack);
        return id == null ? null : TFMazeMapData.getMazeMapData(world, MazeMapItem.getMapName(id));
    }

    @Nullable
    public TFMazeMapData getCustomMapData(class_1799 stack, class_1937 world) {
        TFMazeMapData mapdata = MazeMapItem.getData(stack, world);
        if (mapdata == null && !world.field_9236) {
            mapdata = MazeMapItem.createMapData(stack, world, world.method_8401().method_215(), world.method_8401().method_166(), 0, false, false, (class_5321<class_1937>)world.method_27983(), world.method_8401().method_144());
        }
        return mapdata;
    }

    private static TFMazeMapData createMapData(class_1799 stack, class_1937 world, int x, int z, int scale, boolean trackingPosition, boolean unlimitedTracking, class_5321<class_1937> dimension, int y) {
        int i = world.method_17889();
        int mapSize = 128 * (1 << scale);
        int roundX = class_3532.method_15357((double)(((double)x + 64.0) / (double)mapSize));
        int roundZ = class_3532.method_15357((double)(((double)z + 64.0) / (double)mapSize));
        int scaledX = roundX * mapSize + mapSize / 2 - 64;
        int scaledZ = roundZ * mapSize + mapSize / 2 - 64;
        TFMazeMapData mapdata = new TFMazeMapData(scaledX, scaledZ, (byte)scale, trackingPosition, unlimitedTracking, false, dimension);
        mapdata.calculateMapCenter(world, x, y, z);
        TFMazeMapData.registerMazeMapData(world, mapdata, MazeMapItem.getMapName(i));
        stack.method_7948().method_10569("map", i);
        return mapdata;
    }

    public static String getMapName(int id) {
        return "mazemap_" + id;
    }

    public void method_7998(class_1937 world, class_1297 viewer, class_22 data) {
        if (world.method_27983() == data.field_118 && viewer instanceof class_1657) {
            int blocksPerPixel = 1 << data.field_119;
            int centerX = data.field_116;
            int centerZ = data.field_115;
            int viewerX = class_3532.method_15357((double)(viewer.method_23317() - (double)centerX)) / blocksPerPixel + 64;
            int viewerZ = class_3532.method_15357((double)(viewer.method_23321() - (double)centerZ)) / blocksPerPixel + 64;
            int viewRadiusPixels = 16;
            if (world.method_8597().method_27998()) {
                viewRadiusPixels /= 2;
            }
            class_22.class_23 mapdata$mapinfo = data.method_101((class_1657)viewer);
            ++mapdata$mapinfo.field_131;
            boolean flag = false;
            for (int xPixel = viewerX - viewRadiusPixels + 1; xPixel < viewerX + viewRadiusPixels; ++xPixel) {
                if ((xPixel & 0xF) != (mapdata$mapinfo.field_131 & 0xF) && !flag) continue;
                flag = false;
                for (int zPixel = viewerZ - viewRadiusPixels - 1; zPixel < viewerZ + viewRadiusPixels; ++zPixel) {
                    byte b1;
                    byte b0;
                    if (xPixel < 0 || zPixel < -1 || xPixel >= 128 || zPixel >= 128) continue;
                    int xPixelDist = xPixel - viewerX;
                    int zPixelDist = zPixel - viewerZ;
                    boolean shouldFuzz = xPixelDist * xPixelDist + zPixelDist * zPixelDist > (viewRadiusPixels - 2) * (viewRadiusPixels - 2);
                    int worldX = (centerX / blocksPerPixel + xPixel - 64) * blocksPerPixel;
                    int worldZ = (centerZ / blocksPerPixel + zPixel - 64) * blocksPerPixel;
                    HashMultiset multiset = HashMultiset.create();
                    class_2818 chunk = world.method_8500(new class_2338(worldX, 0, worldZ));
                    int brightness = 1;
                    if (chunk.method_12223()) continue;
                    int worldXRounded = worldX & 0xF;
                    int worldZRounded = worldZ & 0xF;
                    if (world.method_8597().method_27998()) {
                        int l3 = worldX + worldZ * 231871;
                        if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)class_2246.field_10566.method_9564().method_26205((class_1922)world, class_2338.field_10980), 10);
                        } else {
                            multiset.add((Object)class_2246.field_10340.method_9564().method_26205((class_1922)world, class_2338.field_10980), 100);
                        }
                    } else {
                        int yCenter = ((TFMazeMapData)data).yCenter;
                        class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339(worldXRounded, yCenter, worldZRounded);
                        class_2680 state = chunk.method_8320((class_2338)blockpos$mutableblockpos);
                        multiset.add((Object)state.method_26205((class_1922)world, (class_2338)blockpos$mutableblockpos));
                        if (state.method_27852(class_2246.field_10340) || state.method_26215()) {
                            for (int i = -3; i <= 3; ++i) {
                                blockpos$mutableblockpos.method_33098(yCenter + i);
                                class_2680 searchID = chunk.method_8320((class_2338)blockpos$mutableblockpos);
                                if (!searchID.method_27852(class_2246.field_10340) || searchID.method_26215()) continue;
                                state = searchID;
                                if (i > 0) {
                                    brightness = 2;
                                }
                                if (i >= 0) break;
                                brightness = 0;
                                break;
                            }
                        }
                        if (this.mapOres) {
                            if (state.method_26164(class_3481.field_29193)) {
                                multiset.add((Object)class_3620.field_16009, 1000);
                            } else if (state.method_26164(class_3481.field_23062)) {
                                multiset.add((Object)class_3620.field_15994, 1000);
                            } else if (state.method_26164(class_3481.field_28988)) {
                                multiset.add((Object)class_3620.field_16005, 1000);
                            } else if (state.method_26164(class_3481.field_28991)) {
                                multiset.add((Object)class_3620.field_15980, 1000);
                            } else if (state.method_26164(class_3481.field_28990)) {
                                multiset.add((Object)class_3620.field_16020, 1000);
                            } else if (state.method_26164(class_3481.field_28989)) {
                                multiset.add((Object)class_3620.field_15983, 1000);
                            } else if (state.method_26164(class_3481.field_29194)) {
                                multiset.add((Object)class_3620.field_16001, 1000);
                            } else if (state.method_26164(class_3481.field_29195)) {
                                multiset.add((Object)class_3620.field_15987, 1000);
                            } else if (state.method_26204() != class_2246.field_10124 && state.method_26164(Tags.Blocks.ORES)) {
                                multiset.add((Object)class_3620.field_16030, 1000);
                            }
                        }
                    }
                    class_3620 mapcolor = (class_3620)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)class_3620.field_16008);
                    if (zPixel < 0 || xPixelDist * xPixelDist + zPixelDist * zPixelDist >= viewRadiusPixels * viewRadiusPixels || shouldFuzz && (xPixel + zPixel & 1) == 0 || (b0 = data.field_122[xPixel + zPixel * 128]) == (b1 = (byte)(mapcolor.field_16021 * 4 + brightness))) continue;
                    data.method_32370(xPixel, zPixel, b1);
                    data.method_80();
                    flag = true;
                }
            }
        }
    }

    public void method_7888(class_1799 stack, class_1937 worldIn, class_1297 entityIn, int slot, boolean isSelected) {
        TFMazeMapData mapdata;
        if (!worldIn.field_9236 && (mapdata = this.getCustomMapData(stack, worldIn)) != null) {
            class_1657 player;
            if (entityIn instanceof class_1657) {
                class_20 decoration;
                class_1657 entityplayer = (class_1657)entityIn;
                mapdata.method_102(entityplayer, stack);
                int yProximity = class_3532.method_15357((double)(entityplayer.method_23318() - (double)mapdata.yCenter));
                if ((yProximity < -3 || yProximity > 3) && (decoration = (class_20)mapdata.field_117.get(entityplayer.method_5477().getString())) != null) {
                    mapdata.field_117.put(entityplayer.method_5477().getString(), new class_20(class_20.class_21.field_86, decoration.method_90(), decoration.method_91(), decoration.method_89(), null));
                }
            }
            if (!mapdata.field_17403 && (isSelected || entityIn instanceof class_1657 && (player = (class_1657)entityIn).method_6079() == stack)) {
                this.method_7998(worldIn, entityIn, mapdata);
            }
        }
    }

    public void method_7843(class_1799 stack, class_1937 world, class_1657 player) {
    }

    @Nullable
    public class_2596<?> method_7757(class_1799 stack, class_1937 worldIn, class_1657 player) {
        Integer id = MazeMapItem.method_8003((class_1799)stack);
        TFMazeMapData mapdata = this.getCustomMapData(stack, worldIn);
        class_2596 p = id == null || mapdata == null ? null : mapdata.method_100(id, player);
        return p instanceof class_2683 ? TFPacketHandler.CHANNEL.createVanillaPacket((S2CPacket)new MazeMapPacket((class_2683)p)) : p;
    }
}

