/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item.recipe;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import twilightforest.item.recipe.IUncraftingRecipe;
import twilightforest.item.recipe.TFRecipes;

public class UncraftingRecipe
extends class_1869
implements IUncraftingRecipe {
    private final class_2960 recipeID;
    private final int cost;
    private final int width;
    private final int height;
    private final class_1856 ingredient;
    private final int count;
    private final class_2371<class_1856> resultItems;

    public UncraftingRecipe(class_2960 recipeID, int cost, int width, int height, class_1856 ingredient, int count, class_2371<class_1856> resultItems) {
        super(recipeID, "", width, height, resultItems, null);
        this.recipeID = recipeID;
        this.cost = cost;
        this.width = width;
        this.height = height;
        this.ingredient = ingredient;
        this.count = count;
        this.resultItems = resultItems;
    }

    public boolean method_17728(class_1715 pContainer, class_1937 pLevel) {
        return false;
    }

    public class_1799 method_17727(class_1715 pContainer) {
        return class_1799.field_8037;
    }

    public class_1799 method_8110() {
        return new class_1799((class_1935)class_1802.field_8162, this.count);
    }

    public boolean method_8113(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public boolean isItemStackAnIngredient(class_1799 itemStack) {
        return Arrays.stream(this.ingredient.method_8105()).anyMatch(i -> itemStack.method_7909() == i.method_7909() && itemStack.method_7947() >= this.getCount());
    }

    public class_2960 method_8114() {
        return this.recipeID;
    }

    public class_1865<?> method_8119() {
        return (class_1865)TFRecipes.UNCRAFTING_SERIALIZER.get();
    }

    @Override
    public class_3956<?> method_17716() {
        return (class_3956)TFRecipes.UNCRAFTING_RECIPE.get();
    }

    public int getCost() {
        return this.cost;
    }

    public int method_8150() {
        return this.width;
    }

    public int method_8158() {
        return this.height;
    }

    public class_2371<class_1856> method_8117() {
        return this.resultItems;
    }

    public class_1856 getIngredient() {
        return this.ingredient;
    }

    public int getCount() {
        return this.count;
    }

    public static class Serializer
    implements class_1865<UncraftingRecipe> {
        public UncraftingRecipe fromJson(class_2960 id, JsonObject json) {
            int cost = class_3518.method_15260((JsonObject)json, (String)"cost");
            JsonArray jsonelement = class_3518.method_15264((JsonObject)json, (String)"ingredient") ? class_3518.method_15261((JsonObject)json, (String)"ingredient") : class_3518.method_15296((JsonObject)json, (String)"ingredient");
            class_1856 ingredient = class_1856.method_8102((JsonElement)jsonelement);
            int count = class_3518.method_15260((JsonObject)json, (String)"count");
            Map<String, class_1856> key = Serializer.keyFromJson(class_3518.method_15296((JsonObject)json, (String)"key"));
            String[] pattern = Serializer.shrink(Serializer.patternFromJson(class_3518.method_15261((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            class_2371<class_1856> ingredients = Serializer.dissolvePattern(pattern, key, width, height);
            return new UncraftingRecipe(id, cost, width, height, ingredient, count, ingredients);
        }

        private static Map<String, class_1856> keyFromJson(JsonObject json) {
            HashMap map = Maps.newHashMap();
            for (Map.Entry entry : json.entrySet()) {
                if (((String)entry.getKey()).length() != 1) {
                    throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
                }
                if (" ".equals(entry.getKey())) {
                    throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                }
                map.put((String)entry.getKey(), class_1856.method_8102((JsonElement)((JsonElement)entry.getValue())));
            }
            map.put(" ", class_1856.field_9017);
            return map;
        }

        static String[] shrink(String ... prePattern) {
            int i = Integer.MAX_VALUE;
            int j = 0;
            int k = 0;
            int l = 0;
            for (int i1 = 0; i1 < prePattern.length; ++i1) {
                String s = prePattern[i1];
                i = Math.min(i, Serializer.firstNonSpace(s));
                int j1 = Serializer.lastNonSpace(s);
                j = Math.max(j, j1);
                if (j1 < 0) {
                    if (k == i1) {
                        ++k;
                    }
                    ++l;
                    continue;
                }
                l = 0;
            }
            if (prePattern.length == l) {
                return new String[0];
            }
            String[] shrunk = new String[prePattern.length - l - k];
            for (int k1 = 0; k1 < shrunk.length; ++k1) {
                shrunk[k1] = prePattern[k1 + k].substring(i, j + 1);
            }
            return shrunk;
        }

        private static int firstNonSpace(String first) {
            int i;
            for (i = 0; i < first.length() && first.charAt(i) == ' '; ++i) {
            }
            return i;
        }

        private static int lastNonSpace(String last) {
            int i;
            for (i = last.length() - 1; i >= 0 && last.charAt(i) == ' '; --i) {
            }
            return i;
        }

        private static String[] patternFromJson(JsonArray pattern) {
            String[] stringPattern = new String[pattern.size()];
            if (stringPattern.length > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
            }
            if (stringPattern.length == 0) {
                throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
            }
            for (int i = 0; i < stringPattern.length; ++i) {
                String s = class_3518.method_15287((JsonElement)pattern.get(i), (String)("pattern[" + i + "]"));
                if (s.length() > 3) {
                    throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
                }
                if (i > 0 && stringPattern[0].length() != s.length()) {
                    throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
                }
                stringPattern[i] = s;
            }
            return stringPattern;
        }

        private static class_2371<class_1856> dissolvePattern(String[] pattern, Map<String, class_1856> key, int width, int height) {
            class_2371 results = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
            HashSet set = Sets.newHashSet(key.keySet());
            set.remove(" ");
            for (int i = 0; i < pattern.length; ++i) {
                for (int j = 0; j < pattern[i].length(); ++j) {
                    String s = pattern[i].substring(j, j + 1);
                    class_1856 ingredient = key.get(s);
                    if (ingredient == null) {
                        throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                    }
                    set.remove(s);
                    results.set(j + width * i, (Object)ingredient);
                }
            }
            if (!set.isEmpty()) {
                throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
            }
            return results;
        }

        @Nullable
        public UncraftingRecipe fromNetwork(class_2960 id, class_2540 buffer) {
            int cost = buffer.method_10816();
            int width = buffer.method_10816();
            int height = buffer.method_10816();
            class_1856 result = class_1856.method_8086((class_2540)buffer);
            int count = buffer.method_10816();
            class_2371 ingredients = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
            for (int k = 0; k < ingredients.size(); ++k) {
                ingredients.set(k, (Object)class_1856.method_8086((class_2540)buffer));
            }
            return new UncraftingRecipe(id, cost, width, height, result, count, (class_2371<class_1856>)ingredients);
        }

        public void toNetwork(class_2540 buffer, UncraftingRecipe recipe) {
            buffer.method_10804(recipe.cost);
            buffer.method_10804(recipe.width);
            buffer.method_10804(recipe.height);
            recipe.ingredient.method_8088(buffer);
            buffer.method_10804(recipe.count);
            for (class_1856 i : recipe.resultItems) {
                i.method_8088(buffer);
            }
        }
    }
}

