/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.biomesources;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.LongFunction;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import twilightforest.world.components.chunkgenerators.warp.TerrainPoint;
import twilightforest.world.components.layer.GenLayerTFBiomeStabilize;
import twilightforest.world.components.layer.GenLayerTFBiomes;
import twilightforest.world.components.layer.GenLayerTFCompanionBiomes;
import twilightforest.world.components.layer.GenLayerTFKeyBiomes;
import twilightforest.world.components.layer.GenLayerTFRiverMix;
import twilightforest.world.components.layer.GenLayerTFStream;
import twilightforest.world.components.layer.GenLayerTFThornBorder;
import twilightforest.world.components.layer.vanillalegacy.Layer;
import twilightforest.world.components.layer.vanillalegacy.SmoothLayer;
import twilightforest.world.components.layer.vanillalegacy.ZoomLayer;
import twilightforest.world.components.layer.vanillalegacy.area.Area;
import twilightforest.world.components.layer.vanillalegacy.area.AreaFactory;
import twilightforest.world.components.layer.vanillalegacy.context.BigContext;
import twilightforest.world.components.layer.vanillalegacy.context.LazyAreaContext;
import twilightforest.world.registration.TwilightFeatures;
import twilightforest.world.registration.biomes.BiomeKeys;

@Deprecated
public class TFBiomeProvider
extends class_1966 {
    public static final Codec<TFBiomeProvider> TF_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().orElseGet(() -> TwilightFeatures.seed).forGetter(obj -> obj.seed), (App)class_6903.method_40419((class_5321)class_2378.field_25114).forGetter(provider -> provider.registry), (App)RecordCodecBuilder.create(pair -> pair.group((App)TerrainPoint.CODEC.fieldOf("parameters").forGetter(Pair::getFirst), (App)class_1959.field_24677.fieldOf("biome").forGetter(Pair::getSecond)).apply((Applicative)pair, Pair::of)).listOf().fieldOf("biomes").forGetter(obj -> obj.biomeList), (App)Codec.FLOAT.fieldOf("base_offset").forGetter(obj -> Float.valueOf(obj.baseOffset)), (App)Codec.FLOAT.fieldOf("base_factor").forGetter(obj -> Float.valueOf(obj.baseFactor))).apply((Applicative)instance, instance.stable(TFBiomeProvider::new)));
    private static final List<class_5321<class_1959>> BIOMES = ImmutableList.of(BiomeKeys.LAKE, BiomeKeys.FOREST, BiomeKeys.DENSE_FOREST, BiomeKeys.HIGHLANDS, BiomeKeys.MUSHROOM_FOREST, BiomeKeys.SWAMP, BiomeKeys.STREAM, BiomeKeys.SNOWY_FOREST, BiomeKeys.GLACIER, BiomeKeys.CLEARING, BiomeKeys.OAK_SAVANNAH, BiomeKeys.FIREFLY_FOREST, (Object[])new class_5321[]{BiomeKeys.DENSE_MUSHROOM_FOREST, BiomeKeys.DARK_FOREST, BiomeKeys.ENCHANTED_FOREST, BiomeKeys.FIRE_SWAMP, BiomeKeys.DARK_FOREST_CENTER, BiomeKeys.FINAL_PLATEAU, BiomeKeys.THORNLANDS, BiomeKeys.SPOOKY_FOREST});
    private final class_2378<class_1959> registry;
    private final List<Pair<TerrainPoint, class_6880<class_1959>>> biomeList;
    private final Layer genBiomes;
    private final long seed;
    private final float baseOffset;
    private final float baseFactor;

    public TFBiomeProvider(long seed, class_2378<class_1959> registryIn, List<Pair<TerrainPoint, class_6880<class_1959>>> list, float offset, float factor) {
        super(BIOMES.stream().map(arg_0 -> registryIn.method_40264(arg_0)).filter(Optional::isPresent).map(Optional::get));
        this.seed = seed;
        this.baseOffset = offset;
        this.baseFactor = factor;
        this.registry = registryIn;
        this.biomeList = list;
        this.genBiomes = TFBiomeProvider.makeLayers(seed, registryIn);
    }

    public static int getBiomeId(class_5321<class_1959> biome, class_2378<class_1959> registry) {
        return registry.method_10206((Object)((class_1959)registry.method_29107(biome)));
    }

    private static <T extends Area, C extends BigContext<T>> AreaFactory<T> makeLayers(LongFunction<C> seed, class_2378<class_1959> registry, long rawSeed) {
        AreaFactory biomes = GenLayerTFBiomes.INSTANCE.setup(registry).run((BigContext)seed.apply(1L));
        biomes = GenLayerTFKeyBiomes.INSTANCE.setup(registry, rawSeed).run((BigContext)seed.apply(1000L), biomes);
        biomes = GenLayerTFCompanionBiomes.INSTANCE.setup(registry).run((BigContext)seed.apply(1000L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1000L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1001L), biomes);
        biomes = GenLayerTFBiomeStabilize.INSTANCE.run((BigContext)seed.apply(700L), biomes);
        biomes = GenLayerTFThornBorder.INSTANCE.setup(registry).run((BigContext)seed.apply(500L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1002L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1003L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1004L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1005L), biomes);
        AreaFactory riverLayer = GenLayerTFStream.INSTANCE.setup(registry).run((BigContext)seed.apply(1L), biomes);
        riverLayer = SmoothLayer.INSTANCE.run((BigContext)seed.apply(7000L), riverLayer);
        biomes = GenLayerTFRiverMix.INSTANCE.setup(registry).run((BigContext)seed.apply(100L), biomes, riverLayer);
        return biomes;
    }

    public static Layer makeLayers(long seed, class_2378<class_1959> registry) {
        AreaFactory areaFactory = TFBiomeProvider.makeLayers(context -> new LazyAreaContext(25, seed, context), registry, seed);
        return new Layer(areaFactory){

            @Override
            public class_6880<class_1959> get(class_2378<class_1959> registry, int p_242936_2_, int p_242936_3_) {
                int i = this.area.get(p_242936_2_, p_242936_3_);
                Optional biome = registry.method_40265(i);
                if (biome.isEmpty()) {
                    throw new IllegalStateException("Unknown biome id emitted by layers: " + i);
                }
                return (class_6880)biome.get();
            }
        };
    }

    protected Codec<? extends class_1966> method_28442() {
        return TF_CODEC;
    }

    public class_1966 method_27985(long l) {
        return new TFBiomeProvider(l, this.registry, this.biomeList, this.baseOffset, this.baseFactor);
    }

    public float getBaseOffset() {
        return this.baseOffset;
    }

    public float getBaseFactor() {
        return this.baseFactor;
    }

    public float getBiomeDepth(int x, int y, int z, class_6544.class_6552 sampler) {
        class_1959 biome = (class_1959)this.method_38109(x, y, z, sampler).comp_349();
        return this.getBiomeDepth(biome);
    }

    public float getBiomeDepth(class_1959 biome) {
        return this.getBiomeValue(biome, TerrainPoint::depth);
    }

    public float getBiomeScale(int x, int y, int z, class_6544.class_6552 sampler) {
        class_1959 biome = (class_1959)this.method_38109(x, y, z, sampler).comp_349();
        return this.getBiomeScale(biome);
    }

    public float getBiomeScale(class_1959 biome) {
        return this.getBiomeValue(biome, TerrainPoint::scale);
    }

    private float getBiomeValue(class_1959 biome, Function<? super TerrainPoint, Float> function) {
        return this.biomeList.stream().filter(p -> ((class_1959)((class_6880)p.getSecond()).comp_349()).equals(biome)).map(Pair::getFirst).map(function).findFirst().orElse(Float.valueOf(0.0f)).floatValue();
    }

    public class_6880<class_1959> method_38109(int x, int y, int z, class_6544.class_6552 sampler) {
        return this.genBiomes.get(this.registry, x, z);
    }
}

