/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_4651;
import net.minecraft.class_5281;
import net.minecraft.class_5821;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import twilightforest.IMCHandler;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.util.FeatureLogic;
import twilightforest.world.components.feature.config.SpikeConfig;

public class BlockSpikeFeature
extends class_3031<SpikeConfig> {
    private static final List<StalactiteEntry> largeHillStalactites = new ArrayList<StalactiteEntry>();
    private static final List<StalactiteEntry> mediumHillStalactites = new ArrayList<StalactiteEntry>();
    private static final List<StalactiteEntry> smallHillStalactites = new ArrayList<StalactiteEntry>();

    public BlockSpikeFeature(Codec<SpikeConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<SpikeConfig> context) {
        Random random = context.method_33654();
        return BlockSpikeFeature.startSpike(context.method_33652(), context.method_33655(), (SpikeConfig)context.method_33656(), random);
    }

    public static boolean startSpike(class_5281 level, class_2338 startPos, SpikeConfig config, Random random) {
        return BlockSpikeFeature.startSpike(level, startPos, config.blockState, config.lengthBounds.method_35008(random), config.lengthBounds.method_35009(), config.tipClearance.method_35008(random), config.hang, random);
    }

    public static boolean startSpike(class_5281 level, class_2338 startPos, class_4651 blockState, int length, int lengthMinimum, int clearance, boolean hang, Random random) {
        class_2338.class_2339 movingPos = startPos.method_25503();
        int clearedLength = 0;
        int dY = hang ? -1 : 1;
        int i = 0;
        while (i < length) {
            clearedLength = i++;
            if (FeatureLogic.worldGenReplaceable(level.method_8320((class_2338)movingPos))) break;
            movingPos.method_10100(0, dY, 0);
        }
        movingPos.method_10100(0, dY, 0);
        int remainingScanLength = length - clearedLength + clearance;
        int finalLength = clearedLength - clearance;
        for (int i2 = 0; i2 < remainingScanLength; ++i2) {
            finalLength = clearedLength + i2;
            if (!FeatureLogic.worldGenReplaceable(level.method_8320((class_2338)movingPos))) break;
            movingPos.method_10100(0, dY, 0);
        }
        if ((finalLength = Math.min(length, finalLength)) < lengthMinimum) {
            return false;
        }
        return BlockSpikeFeature.makeSpike(level, startPos, blockState, finalLength, dY, random, hang);
    }

    private static boolean makeSpike(class_5281 level, class_2338 startPos, class_4651 blockState, int length, int dY, Random random, boolean hang) {
        int diameter = (int)((float)length / 4.5f);
        if (!hang && !FeatureLogic.worldGenReplaceable(level.method_8320(startPos.method_10074()))) {
            return false;
        }
        for (int dx = -diameter; dx <= diameter; ++dx) {
            for (int dz = -diameter; dz <= diameter; ++dz) {
                int absz;
                int absx = Math.abs(dx);
                int dist = (int)((float)Math.max(absx, absz = Math.abs(dz)) + (float)Math.min(absx, absz) * 0.5f);
                int spikeLength = dist <= 0 ? length : random.nextInt((int)((float)length / ((float)dist + 0.25f)));
                for (int i = -1; i < spikeLength; ++i) {
                    class_2338 placement = startPos.method_10069(dx, i * dY, dz);
                    if (!FeatureLogic.worldGenReplaceable(level.method_8320(placement)) || dY <= 0 && placement.method_10264() >= level.method_8624(class_2902.class_2903.field_13203, placement.method_10263(), placement.method_10260()) - 1) continue;
                    level.method_8652(placement, blockState.method_23455(random, placement), 3);
                }
            }
        }
        return true;
    }

    public static SpikeConfig makeRandomOreStalactite(Random rand, int hillSize) {
        if (hillSize >= 3 || hillSize >= 2 && rand.nextInt(5) == 0) {
            return ((StalactiteEntry)((Object)class_6011.method_34986((Random)rand, BlockSpikeFeature.largeHillStalactites).get())).stalactite;
        }
        if (hillSize >= 2 || hillSize >= 1 && rand.nextInt(5) == 0) {
            return ((StalactiteEntry)((Object)class_6011.method_34986((Random)rand, BlockSpikeFeature.mediumHillStalactites).get())).stalactite;
        }
        return ((StalactiteEntry)((Object)class_6011.method_34986((Random)rand, BlockSpikeFeature.smallHillStalactites).get())).stalactite;
    }

    public static void registerStalactite(int hillSize, class_2680 blockState, float size, int maxLength, int minHeight, int itemWeight) {
        if (itemWeight > 0) {
            BlockSpikeFeature.registerStalactite(hillSize, new StalactiteEntry(blockState, size, maxLength, itemWeight));
        }
    }

    private static void registerStalactite(int hillSize, StalactiteEntry entry) {
        if (hillSize <= 1) {
            smallHillStalactites.add(entry);
        }
        if (hillSize <= 2) {
            mediumHillStalactites.add(entry);
        }
        largeHillStalactites.add(entry);
    }

    private static void addDefaultStalactites() {
        BlockSpikeFeature.registerStalactite(3, class_2246.field_10442.method_9564(), 0.5f, 4, 16, 30);
        BlockSpikeFeature.registerStalactite(3, class_2246.field_10090.method_9564(), 0.8f, 8, 1, 30);
        BlockSpikeFeature.registerStalactite(3, class_2246.field_10013.method_9564(), 0.5f, 3, 12, 15);
        BlockSpikeFeature.registerStalactite(2, class_2246.field_10571.method_9564(), 0.6f, 6, 1, 20);
        BlockSpikeFeature.registerStalactite(2, class_2246.field_10080.method_9564(), 0.8f, 8, 1, 40);
        BlockSpikeFeature.registerStalactite(1, class_2246.field_10212.method_9564(), 0.7f, 8, 1, 24);
        BlockSpikeFeature.registerStalactite(1, class_2246.field_10418.method_9564(), 0.8f, 12, 1, 24);
        BlockSpikeFeature.registerStalactite(1, class_2246.field_27120.method_9564(), 0.6f, 12, 1, 12);
        BlockSpikeFeature.registerStalactite(1, class_2246.field_10171.method_9564(), 0.5f, 8, 1, 12);
    }

    public static void loadStalactites() {
        smallHillStalactites.clear();
        mediumHillStalactites.clear();
        largeHillStalactites.clear();
        TFConfig.COMMON_CONFIG.DIMENSION.hollowHillStalactites.load();
        if (((Boolean)TFConfig.COMMON_CONFIG.DIMENSION.hollowHillStalactites.useConfigOnly.get()).booleanValue()) {
            if (smallHillStalactites.isEmpty()) {
                TwilightForestMod.LOGGER.info("Not all hollow hills are populated with the config, adding fallback");
                BlockSpikeFeature.registerStalactite(1, class_2246.field_10340.method_9564(), 0.7f, 8, 1, 1);
            }
            return;
        }
        BlockSpikeFeature.addDefaultStalactites();
        IMCHandler.getStalactites().forEach(BlockSpikeFeature::registerStalactite);
    }

    public static class StalactiteEntry
    extends class_6008.class_6009 {
        final SpikeConfig stalactite;

        StalactiteEntry(SpikeConfig stalactite, int itemWeight) {
            super(itemWeight);
            this.stalactite = stalactite;
        }

        public StalactiteEntry(class_2680 blockState, float size, int maxLength, int itemWeight) {
            this(new SpikeConfig((class_4651)class_4651.method_38433((class_2680)blockState), (class_6017)class_6019.method_35017((int)((int)((float)maxLength * size)), (int)maxLength), (class_6017)class_6016.method_34998((int)4), true), itemWeight);
        }
    }
}

