/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_3031;
import net.minecraft.class_3746;
import net.minecraft.class_4651;
import net.minecraft.class_5281;
import net.minecraft.class_5821;
import twilightforest.util.FeatureLogic;
import twilightforest.util.FeaturePlacers;
import twilightforest.util.VoxelBresenhamIterator;
import twilightforest.world.components.feature.config.RootConfig;

public class TFGenWoodRoots
extends class_3031<RootConfig> {
    public TFGenWoodRoots(Codec<RootConfig> configIn) {
        super(configIn);
    }

    public boolean method_13151(class_5821<RootConfig> ctx) {
        class_5281 world = ctx.method_33652();
        class_2338 pos = ctx.method_33655();
        Random rand = ctx.method_33654();
        if (world.method_8320(pos).method_26204() != class_2246.field_10340) {
            return false;
        }
        float length = rand.nextFloat() * 6.0f + rand.nextFloat() * 6.0f + 4.0f;
        if (length > (float)pos.method_10264()) {
            length = pos.method_10264();
        }
        float tilt = 0.6f + rand.nextFloat() * 0.3f;
        return this.drawRoot((class_1936)world, rand, pos, pos, length, rand.nextFloat(), tilt, ((RootConfig)ctx.method_33656()).blockRoot(), ((RootConfig)ctx.method_33656()).oreRoot());
    }

    private boolean drawRoot(class_1936 world, Random rand, class_2338 oPos, class_2338 pos, float length, float angle, float tilt, class_4651 rootBlock, class_4651 oreBlock) {
        class_2338 dest = FeatureLogic.translate(pos, length, angle, tilt);
        int limit = 6;
        if (oPos.method_10263() + limit < dest.method_10263()) {
            dest = new class_2338(oPos.method_10263() + limit, dest.method_10264(), dest.method_10260());
        }
        if (oPos.method_10263() - limit > dest.method_10263()) {
            dest = new class_2338(oPos.method_10263() - limit, dest.method_10264(), dest.method_10260());
        }
        if (oPos.method_10260() + limit < dest.method_10260()) {
            dest = new class_2338(dest.method_10263(), dest.method_10264(), oPos.method_10260() + limit);
        }
        if (oPos.method_10260() - limit > dest.method_10260()) {
            dest = new class_2338(dest.method_10263(), dest.method_10264(), oPos.method_10260() - limit);
        }
        if (world.method_8320(dest).method_26204() != class_2246.field_10340) {
            return false;
        }
        FeaturePlacers.traceRoot((class_3746)world, (checkedPos, rootPlacement) -> world.method_8652(checkedPos, rootPlacement, 3), rand, rootBlock, new VoxelBresenhamIterator(pos, dest));
        if (length > 8.0f && rand.nextInt(3) > 0) {
            class_2338 nextSrc = FeatureLogic.translate(pos, length / 2.0f, angle, tilt);
            float nextAngle = (angle + 0.25f + rand.nextFloat() * 0.5f) % 1.0f;
            float nextTilt = 0.6f + rand.nextFloat() * 0.3f;
            this.drawRoot(world, rand, oPos, nextSrc, length / 2.0f, nextAngle, nextTilt, rootBlock, oreBlock);
        }
        if (length > 6.0f && rand.nextInt(4) == 0) {
            class_2338 ballSrc = FeatureLogic.translate(pos, length / 2.0f, angle, tilt);
            class_2338 ballDest = FeatureLogic.translate(ballSrc, 1.5, (angle + 0.5f) % 1.0f, 0.75);
            this.placeRootBlock(world, ballSrc, oreBlock, rand);
            this.placeRootBlock(world, new class_2338(ballSrc.method_10263(), ballSrc.method_10264(), ballDest.method_10260()), oreBlock, rand);
            this.placeRootBlock(world, new class_2338(ballDest.method_10263(), ballSrc.method_10264(), ballSrc.method_10260()), oreBlock, rand);
            this.placeRootBlock(world, new class_2338(ballSrc.method_10263(), ballSrc.method_10264(), ballDest.method_10260()), oreBlock, rand);
            this.placeRootBlock(world, new class_2338(ballSrc.method_10263(), ballDest.method_10264(), ballSrc.method_10260()), oreBlock, rand);
            this.placeRootBlock(world, new class_2338(ballSrc.method_10263(), ballDest.method_10264(), ballDest.method_10260()), oreBlock, rand);
            this.placeRootBlock(world, new class_2338(ballDest.method_10263(), ballDest.method_10264(), ballSrc.method_10260()), oreBlock, rand);
            this.placeRootBlock(world, ballDest, oreBlock, rand);
        }
        return true;
    }

    protected boolean placeRootBlock(class_1936 world, class_2338 pos, class_4651 state, Random random) {
        return FeatureLogic.canRootGrowIn((class_3746)world, pos) && world.method_8652(pos, state.method_23455(random, pos), 3);
    }
}

