/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_244;
import net.minecraft.class_2473;
import net.minecraft.class_251;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_3499;
import net.minecraft.class_3614;
import net.minecraft.class_3746;
import net.minecraft.class_4538;
import net.minecraft.class_4643;
import net.minecraft.class_5281;
import net.minecraft.class_5821;
import twilightforest.block.TFBlocks;

public class TFGenDarkCanopyTree
extends class_3031<class_4643> {
    int difference = 0;
    class_2338 validPos = new class_2338(0, 0, 0);

    public TFGenDarkCanopyTree(Codec<class_4643> config) {
        super(config);
    }

    public boolean method_13151(class_5821<class_4643> ctx) {
        class_5281 reader = ctx.method_33652();
        class_2338 pos = ctx.method_33655();
        Random rand = ctx.method_33654();
        class_4643 config = (class_4643)ctx.method_33656();
        boolean foundDirt = false;
        for (int dy = pos.method_10264(); dy >= reader.method_31607(); --dy) {
            class_3614 materialUnder = reader.method_8320(new class_2338(pos.method_10263(), dy - 1, pos.method_10260())).method_26207();
            if (materialUnder == class_3614.field_15945 || materialUnder == class_3614.field_15941) {
                foundDirt = true;
                this.validPos = pos = new class_2338(pos.method_10263(), dy, pos.method_10260());
                break;
            }
            if (materialUnder == class_3614.field_15914 || materialUnder == class_3614.field_15916) break;
        }
        if (!foundDirt) {
            return false;
        }
        for (class_2350 e : class_2350.class_2353.field_11062) {
            if (reader.method_8320(pos.method_10093(e)).method_26207() != class_3614.field_15932) continue;
            return false;
        }
        HashSet set1 = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        HashSet set3 = Sets.newHashSet();
        class_3341 mutableboundingbox = class_3341.method_14665();
        BiConsumer<class_2338, class_2680> biConsumer = (p_160555_, p_160556_) -> {
            set1.add(p_160555_.method_10062());
            reader.method_8652(p_160555_, p_160556_, 19);
        };
        BiConsumer<class_2338, class_2680> biConsumer1 = (p_160548_, p_160549_) -> {
            set2.add(p_160548_.method_10062());
            reader.method_8652(p_160548_, p_160549_, 19);
        };
        BiConsumer<class_2338, class_2680> biConsumer2 = (p_160543_, p_160544_) -> {
            set3.add(p_160543_.method_10062());
            reader.method_8652(p_160543_, p_160544_, 19);
        };
        boolean flag = this.doPlace(reader, rand, pos, biConsumer, biConsumer1, config);
        this.difference = mutableboundingbox.method_35416() - pos.method_10264();
        mutableboundingbox.method_14661(0, pos.method_10264(), 0);
        if (!(!flag || set1.isEmpty() && set2.isEmpty())) {
            if (!config.field_21290.isEmpty()) {
                ArrayList list1 = Lists.newArrayList((Iterable)set1);
                ArrayList list2 = Lists.newArrayList((Iterable)set2);
                list1.sort(Comparator.comparingInt(class_2382::method_10264));
                list2.sort(Comparator.comparingInt(class_2382::method_10264));
                config.field_21290.forEach(p_160528_ -> p_160528_.method_23469((class_3746)reader, biConsumer2, rand, list1, list2));
            }
            return class_3341.method_35411((Iterable)Iterables.concat((Iterable)set1, (Iterable)set2, (Iterable)set3)).map(p_160521_ -> {
                class_251 shape = TFGenDarkCanopyTree.updateLeaves((class_1936)reader, p_160521_, set1, set3);
                class_3499.method_20532((class_1936)reader, (int)3, (class_251)shape, (int)p_160521_.method_35415(), (int)p_160521_.method_35416(), (int)p_160521_.method_35417());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private boolean doPlace(class_5281 level, Random p_160512_, class_2338 pos, BiConsumer<class_2338, class_2680> consumer1, BiConsumer<class_2338, class_2680> consumer2, class_4643 config) {
        int i = config.field_24136.method_26993(p_160512_);
        int j = config.field_24135.method_26989(p_160512_, i, config);
        int k = i - j;
        int l = config.field_24135.method_23452(p_160512_, k);
        if ((pos = new class_2338(pos.method_10263(), this.validPos.method_10264(), pos.method_10260())).method_10264() >= level.method_31607() + 1 && pos.method_10264() + i + 1 <= level.method_31600()) {
            if (!((class_2473)TFBlocks.DARKWOOD_SAPLING.get()).method_9558(level.method_8320(pos), (class_4538)level, pos)) {
                return false;
            }
            OptionalInt optionalint = config.field_24137.method_27377();
            int i1 = this.getMaxFreeTreeHeight((class_3746)level, i, pos, config);
            if (i1 >= i || optionalint.isPresent() && i1 >= optionalint.getAsInt()) {
                List list = config.field_24136.method_26991((class_3746)level, consumer1, p_160512_, i1, pos, config);
                list.forEach(p_160539_ -> config.field_24135.method_27385((class_3746)level, consumer2, p_160512_, config, i1, p_160539_, j, l));
                return true;
            }
            return false;
        }
        return false;
    }

    private int getMaxFreeTreeHeight(class_3746 level, int trunkHeight, class_2338 pos, class_4643 config) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int i = 0; i <= trunkHeight + 1; ++i) {
            int j = config.field_24137.method_27378(trunkHeight, i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    mutable.method_25504((class_2382)pos, k, i, l);
                    if (TFGenDarkCanopyTree.isFree(level, (class_2338)mutable) && config.field_24138) continue;
                    return i - 2;
                }
            }
        }
        return trunkHeight;
    }

    protected void method_13153(class_1945 world, class_2338 pos, class_2680 state) {
        TFGenDarkCanopyTree.setBlockKnownShape(world, pos, state);
    }

    public static void setBlockKnownShape(class_1945 p_236408_0_, class_2338 p_236408_1_, class_2680 p_236408_2_) {
        p_236408_0_.method_8652(p_236408_1_, p_236408_2_, 19);
    }

    private static class_251 updateLeaves(class_1936 p_67203_, class_3341 p_67204_, Set<class_2338> p_67205_, Set<class_2338> p_67206_) {
        ArrayList list = Lists.newArrayList();
        class_244 discretevoxelshape = new class_244(p_67204_.method_35414(), p_67204_.method_14660(), p_67204_.method_14663());
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339();
        for (class_2338 blockpos : Lists.newArrayList(p_67206_)) {
            if (!p_67204_.method_14662((class_2382)blockpos)) continue;
            discretevoxelshape.method_1049(blockpos.method_10263() - p_67204_.method_35415(), blockpos.method_10264() - p_67204_.method_35416(), blockpos.method_10260() - p_67204_.method_35417());
        }
        for (class_2338 blockpos1 : Lists.newArrayList(p_67205_)) {
            if (p_67204_.method_14662((class_2382)blockpos1)) {
                discretevoxelshape.method_1049(blockpos1.method_10263() - p_67204_.method_35415(), blockpos1.method_10264() - p_67204_.method_35416(), blockpos1.method_10260() - p_67204_.method_35417());
            }
            for (class_2350 direction : class_2350.values()) {
                class_2680 blockstate;
                blockpos$mutableblockpos.method_25505((class_2382)blockpos1, direction);
                if (p_67205_.contains(blockpos$mutableblockpos) || !(blockstate = p_67203_.method_8320((class_2338)blockpos$mutableblockpos)).method_28498((class_2769)class_2741.field_12541)) continue;
                ((Set)list.get(0)).add(blockpos$mutableblockpos.method_10062());
                TFGenDarkCanopyTree.setBlockKnownShape((class_1945)p_67203_, (class_2338)blockpos$mutableblockpos, (class_2680)blockstate.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(1)));
                if (!p_67204_.method_14662((class_2382)blockpos$mutableblockpos)) continue;
                discretevoxelshape.method_1049(blockpos$mutableblockpos.method_10263() - p_67204_.method_35415(), blockpos$mutableblockpos.method_10264() - p_67204_.method_35416(), blockpos$mutableblockpos.method_10260() - p_67204_.method_35417());
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (class_2338 blockpos2 : set) {
                if (p_67204_.method_14662((class_2382)blockpos2)) {
                    discretevoxelshape.method_1049(blockpos2.method_10263() - p_67204_.method_35415(), blockpos2.method_10264() - p_67204_.method_35416(), blockpos2.method_10260() - p_67204_.method_35417());
                }
                for (class_2350 direction1 : class_2350.values()) {
                    int k;
                    class_2680 blockstate1;
                    blockpos$mutableblockpos.method_25505((class_2382)blockpos2, direction1);
                    if (set.contains(blockpos$mutableblockpos) || set1.contains(blockpos$mutableblockpos) || !(blockstate1 = p_67203_.method_8320((class_2338)blockpos$mutableblockpos)).method_28498((class_2769)class_2741.field_12541) || (k = ((Integer)blockstate1.method_11654((class_2769)class_2741.field_12541)).intValue()) <= l + 1) continue;
                    class_2680 blockstate2 = (class_2680)blockstate1.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(l + 1));
                    TFGenDarkCanopyTree.setBlockKnownShape((class_1945)p_67203_, (class_2338)blockpos$mutableblockpos, blockstate2);
                    if (p_67204_.method_14662((class_2382)blockpos$mutableblockpos)) {
                        discretevoxelshape.method_1049(blockpos$mutableblockpos.method_10263() - p_67204_.method_35415(), blockpos$mutableblockpos.method_10264() - p_67204_.method_35416(), blockpos$mutableblockpos.method_10260() - p_67204_.method_35417());
                    }
                    set1.add(blockpos$mutableblockpos.method_10062());
                }
            }
        }
        return discretevoxelshape;
    }

    public static boolean isFree(class_3746 pLevel, class_2338 pPos) {
        return TFGenDarkCanopyTree.validTreePos(pLevel, pPos) || pLevel.method_16358(pPos, p_67281_ -> p_67281_.method_26164(class_3481.field_15475));
    }

    private static boolean isBlockWater(class_3746 pLevel, class_2338 pPos) {
        return pLevel.method_16358(pPos, p_67271_ -> p_67271_.method_27852(class_2246.field_10382));
    }

    public static boolean isAirOrLeaves(class_3746 pLevel, class_2338 pPos) {
        return pLevel.method_16358(pPos, p_67266_ -> p_67266_.method_26215() || p_67266_.method_26164(class_3481.field_15503) || p_67266_.method_27852((class_2248)TFBlocks.HARDENED_DARK_LEAVES.get()));
    }

    private static boolean isReplaceablePlant(class_3746 pLevel, class_2338 pPos) {
        return pLevel.method_16358(pPos, p_160551_ -> {
            class_3614 material = p_160551_.method_26207();
            return material == class_3614.field_15956;
        });
    }

    public static boolean validTreePos(class_3746 pLevel, class_2338 pPos) {
        return TFGenDarkCanopyTree.isAirOrLeaves(pLevel, pPos) || TFGenDarkCanopyTree.isReplaceablePlant(pLevel, pPos) || TFGenDarkCanopyTree.isBlockWater(pLevel, pPos);
    }
}

