/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees.treeplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4657;
import net.minecraft.class_4662;
import net.minecraft.class_4663;
import net.minecraft.class_4970;
import twilightforest.world.registration.TwilightFeatures;

public class DangleFromTreeDecorator
extends class_4662 {
    public static final Codec<DangleFromTreeDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)32).fieldOf("attempts_minimum").forGetter(o -> o.count), (App)Codec.intRange((int)0, (int)32).fieldOf("random_add_attempts").orElse((Object)0).forGetter(o -> o.randomAddCount), (App)Codec.intRange((int)1, (int)24).fieldOf("minimum_required_length").forGetter(o -> o.minimumRequiredLength), (App)Codec.intRange((int)1, (int)24).fieldOf("base_length").forGetter(o -> o.baseLength), (App)Codec.intRange((int)0, (int)16).fieldOf("random_add_length").orElse((Object)0).forGetter(o -> o.randomAddLength), (App)class_4657.field_24946.fieldOf("rope_provider").forGetter(o -> o.rope), (App)class_4657.field_24946.fieldOf("baggage_provider").forGetter(o -> o.baggage)).apply((Applicative)instance, DangleFromTreeDecorator::new));
    private final int count;
    private final int randomAddCount;
    private final int minimumRequiredLength;
    private final int baseLength;
    private final int randomAddLength;
    private final class_4657 rope;
    private final class_4657 baggage;

    public DangleFromTreeDecorator(int count, int randomAddCount, int minimumRequiredLength, int baseLength, int randomAddLength, class_4657 rope, class_4657 baggage) {
        this.count = count;
        this.randomAddCount = randomAddCount;
        this.minimumRequiredLength = minimumRequiredLength;
        this.baseLength = baseLength;
        this.randomAddLength = randomAddLength;
        this.rope = rope;
        this.baggage = baggage;
    }

    protected class_4663<DangleFromTreeDecorator> method_28893() {
        return (class_4663)TwilightFeatures.DANGLING_DECORATOR.get();
    }

    public void method_23469(class_3746 worldReader, BiConsumer<class_2338, class_2680> worldPlacer, Random random, List<class_2338> trunkBlocks, List<class_2338> leafBlocks) {
        if (leafBlocks.isEmpty()) {
            return;
        }
        int totalTries = this.count + random.nextInt(this.randomAddCount + 1);
        int leafTotal = leafBlocks.size();
        totalTries = Math.min(totalTries, leafTotal);
        for (int attempt = 0; attempt < totalTries; ++attempt) {
            boolean clearedOfPossibleLeaves = false;
            class_2338 pos = leafBlocks.get(random.nextInt(leafTotal));
            if (pos.method_10263() == trunkBlocks.get(0).method_10264() && pos.method_10260() == trunkBlocks.get(0).method_10260()) {
                return;
            }
            int cordLength = this.baseLength + random.nextInt(this.randomAddLength + 1);
            for (int ropeUnrolling = 1; ropeUnrolling <= cordLength; ++ropeUnrolling) {
                boolean isAir = worldReader.method_16358(pos.method_10087(ropeUnrolling), class_4970.class_4971::method_26215);
                if (!clearedOfPossibleLeaves && isAir) {
                    clearedOfPossibleLeaves = true;
                }
                if (!clearedOfPossibleLeaves || isAir) continue;
                cordLength = ropeUnrolling;
                break;
            }
            if (cordLength <= this.minimumRequiredLength) continue;
            class_2680 rope = this.rope.method_23455(random, pos);
            for (int ropeUnrolling = 1; ropeUnrolling < cordLength; ++ropeUnrolling) {
                if (!worldReader.method_16358(pos = pos.method_10087(1), class_4970.class_4971::method_26215)) continue;
                worldPlacer.accept(pos, rope);
            }
            if (!worldReader.method_16358(pos = pos.method_10087(1), class_4970.class_4971::method_26215)) continue;
            worldPlacer.accept(pos, this.baggage.method_23455(random, pos));
        }
    }
}

