/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.darktower;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1533;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1917;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2363;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2399;
import net.minecraft.class_2465;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2794;
import net.minecraft.class_2975;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5556;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import net.minecraft.class_6626;
import net.minecraft.class_6808;
import net.minecraft.class_6880;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.entity.TFEntities;
import twilightforest.item.TFItems;
import twilightforest.loot.TFTreasure;
import twilightforest.util.RotationUtil;
import twilightforest.world.components.structures.TFMaze;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.TFStructureDecorator;
import twilightforest.world.components.structures.darktower.DarkTowerBossBridgeComponent;
import twilightforest.world.components.structures.darktower.DarkTowerEntranceBridgeComponent;
import twilightforest.world.components.structures.darktower.DarkTowerMainBridgeComponent;
import twilightforest.world.components.structures.darktower.DarkTowerPieces;
import twilightforest.world.components.structures.darktower.DarkTowerWingComponent;
import twilightforest.world.components.structures.darktower.EnumDarkTowerDoor;
import twilightforest.world.components.structures.darktower.StructureDecoratorDarkTower;
import twilightforest.world.registration.TFFeature;
import twilightforest.world.registration.features.TFConfiguredFeatures;

public class DarkTowerMainComponent
extends DarkTowerWingComponent {
    private boolean placedKeys = false;

    public DarkTowerMainComponent(class_6625 ctx, class_2487 nbt) {
        super(DarkTowerPieces.TFDTMai, nbt);
    }

    public DarkTowerMainComponent(TFFeature feature, Random rand, int index, int x, int y, int z) {
        this(feature, rand, index, x + 10, y + 4, z + 10, class_2350.field_11043);
    }

    public DarkTowerMainComponent(TFFeature feature, Random rand, int index, int x, int y, int z, class_2350 rotation) {
        super(DarkTowerPieces.TFDTMai, feature, index, x, y, z, 19, 56 + rand.nextInt(32) / 5 * 5, rotation);
        if (this.field_15315.method_35419() > 245) {
            int amtToLower = (this.field_15315.method_35419() - 245) / 5 * 5 + 5;
            TwilightForestMod.LOGGER.info("Lowering Dark Tower max height by {} to be within world bounds", (Object)amtToLower);
            this.height -= amtToLower;
            this.field_15315 = this.field_15315.method_19311(0, -amtToLower, 0);
        }
        if (this.deco == null) {
            this.deco = new StructureDecoratorDarkTower();
        }
    }

    @Override
    public void method_14918(class_3443 parent, class_6130 list, Random rand) {
        int childHeight;
        int[] dest;
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        if (this.method_14923() > 0) {
            this.addOpening(0, 1, this.size / 2, class_2470.field_11464);
        }
        class_2470 mainDir = null;
        if (this.method_14923() < 2) {
            mainDir = RotationUtil.ROTATIONS[rand.nextInt(RotationUtil.ROTATIONS.length)];
            for (class_2470 rotation : RotationUtil.ROTATIONS) {
                if (rotation == mainDir) continue;
                dest = this.getValidOpening(rand, rotation);
                childHeight = this.validateChildHeight(21 + rand.nextInt(10));
                this.makeTowerWing(list, rand, this.method_14923(), dest[0], dest[1], dest[2], 11, childHeight, rotation);
            }
        } else {
            for (class_2470 i : RotationUtil.ROTATIONS) {
                dest = this.getValidOpening(rand, i);
                this.makeBossTrapWing(list, rand, this.method_14923(), dest[0], dest[1], dest[2], i);
            }
        }
        if (this.method_14923() > 0) {
            for (class_2470 i : RotationUtil.ROTATIONS) {
                if (i == class_2470.field_11464) continue;
                dest = this.getValidOpening(rand, i);
                dest[1] = 1;
                childHeight = this.validateChildHeight(21 + rand.nextInt(10));
                this.makeTowerWing(list, rand, this.method_14923(), dest[0], dest[1], dest[2], 11, childHeight, i);
            }
            this.makeABeard(parent, list, rand);
        } else {
            for (class_2470 rotation : new class_2470[]{class_2470.field_11467, class_2470.field_11464}) {
                dest = this.getValidOpening(rand, rotation);
                dest[1] = 1;
                childHeight = this.validateChildHeight(10 + rand.nextInt(5));
                this.makeEntranceTower(list, rand, 5, dest[0], dest[1], dest[2], 9, childHeight, rotation);
            }
        }
        if (mainDir != null) {
            int[] dest2 = this.getValidOpening(rand, mainDir);
            this.makeNewLargeTower(list, rand, this.method_14923() + 1, dest2[0], dest2[1], dest2[2], mainDir);
        }
        this.makeARoof(parent, list, rand);
        if (!this.placedKeys && this.method_14923() < 2) {
            ArrayList<DarkTowerWingComponent> possibleKeyTowers = new ArrayList<DarkTowerWingComponent>();
            if (list instanceof class_6626) {
                class_6626 start = (class_6626)list;
                for (class_3443 piece : start.field_34944) {
                    if (!(piece instanceof DarkTowerWingComponent)) continue;
                    DarkTowerWingComponent wing = (DarkTowerWingComponent)piece;
                    if (wing.size != 9 || wing.method_14923() != this.method_14923()) continue;
                    possibleKeyTowers.add(wing);
                }
            }
            for (int i = 0; i < 4; ++i) {
                if (possibleKeyTowers.size() < 1) {
                    TwilightForestMod.LOGGER.warn("Dark forest tower could not find four small towers to place keys in.");
                    break;
                }
                int towerNum = rand.nextInt(possibleKeyTowers.size());
                ((DarkTowerWingComponent)possibleKeyTowers.get(towerNum)).setKeyTower(true);
                possibleKeyTowers.remove(towerNum);
            }
            this.placedKeys = true;
        }
    }

    private boolean makeEntranceTower(class_6130 list, Random rand, int index, int x, int y, int z, int childSize, int childHeight, class_2470 rotation) {
        class_2350 direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, 5, direction);
        DarkTowerEntranceBridgeComponent bridge = new DarkTowerEntranceBridgeComponent(this.getFeatureType(), index, dx[0], dx[1], dx[2], childSize, childHeight, direction);
        list.method_35462((class_3443)bridge);
        bridge.method_14918(this, list, rand);
        this.addOpening(x, y, z, rotation);
        return true;
    }

    private boolean makeNewLargeTower(class_6130 list, Random rand, int index, int x, int y, int z, class_2470 rotation) {
        int wingSize = 15;
        int wingHeight = 56;
        class_2350 direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, 5, direction);
        DarkTowerMainBridgeComponent bridge = new DarkTowerMainBridgeComponent(this.getFeatureType(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        list.method_35462((class_3443)bridge);
        bridge.method_14918(this, list, rand);
        this.addOpening(x, y, z, rotation, EnumDarkTowerDoor.LOCKED);
        return true;
    }

    private boolean makeBossTrapWing(class_6130 list, Random rand, int index, int x, int y, int z, class_2470 rotation) {
        int wingSize = 11;
        int wingHeight = 9;
        class_2350 direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, 5, direction);
        DarkTowerBossBridgeComponent bridge = new DarkTowerBossBridgeComponent(this.getFeatureType(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        list.method_35462((class_3443)bridge);
        bridge.method_14918(this, list, rand);
        this.addOpening(x, y, z, rotation);
        return true;
    }

    @Override
    public void makeARoof(class_3443 parent, class_6130 list, Random rand) {
        if (this.method_14923() < 2) {
            super.makeARoof(parent, list, rand);
        }
    }

    @Override
    public void method_14931(class_5281 world, class_5138 manager, class_2794 generator, Random rand, class_3341 sbb, class_1923 chunkPosIn, class_2338 blockPos) {
        Random decoRNG = new Random(world.method_8412() + (long)this.field_15315.method_35415() * 321534781L ^ (long)this.field_15315.method_35417() * 756839L);
        this.makeEncasedWalls(world, rand, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1);
        this.method_14942(world, sbb, 1, 1, 1, this.size - 2, this.height - 2, this.size - 2);
        if (this.method_14923() == 0) {
            for (int x = 0; x < this.size; ++x) {
                for (int z = 0; z < this.size; ++z) {
                    this.method_14917(world, this.deco.accentState, x, -1, z, sbb);
                }
            }
        }
        int totalFloors = this.height / 5;
        boolean beamMaze = decoRNG.nextBoolean();
        int centerFloors = beamMaze ? 4 : totalFloors / 2;
        int bottomFloors = (totalFloors - centerFloors) / 2;
        int topFloorsStartY = this.height - (bottomFloors * 5 + 1);
        this.addThreeQuarterFloors(world, manager, generator, decoRNG, sbb, 0, bottomFloors * 5);
        if (this.method_14923() < 2) {
            this.addThreeQuarterFloors(world, manager, generator, decoRNG, sbb, topFloorsStartY, this.height - 1);
        } else {
            this.addThreeQuarterFloorsDecorateBoss(world, decoRNG, sbb, topFloorsStartY, this.height - 1);
            this.destroyTower(world, decoRNG, 12, this.height + 4, 3, 4, sbb);
            this.destroyTower(world, decoRNG, 3, this.height + 4, 12, 4, sbb);
            this.destroyTower(world, decoRNG, 3, this.height + 4, 3, 4, sbb);
            this.destroyTower(world, decoRNG, 12, this.height + 4, 12, 4, sbb);
            this.destroyTower(world, decoRNG, 8, this.height + 4, 8, 5, sbb);
            this.decorateBossSpawner(world, sbb, class_2470.field_11467, this.height - 6);
        }
        if (beamMaze) {
            this.addTimberMaze(world, decoRNG, sbb, bottomFloors * 5, topFloorsStartY);
        } else {
            this.addBuilderPlatforms(world, decoRNG, sbb, bottomFloors * 5, topFloorsStartY);
        }
        this.makeOpenings(world, sbb);
    }

    protected void addThreeQuarterFloors(class_5281 world, class_5138 manager, class_2794 generator, Random decoRNG, class_3341 sbb, int bottom, int top) {
        int spacing = 5;
        class_2470 rotation = RotationUtil.ROTATIONS[Math.abs((this.field_15315.method_35416() + bottom) % 4)];
        if (bottom == 0) {
            this.makeLargeStairsUp(world, sbb, rotation, 0);
            rotation = rotation.method_10501(class_2470.field_11465);
            this.makeBottomEntrance(world, sbb, rotation, bottom);
            bottom += spacing;
        }
        for (int y = bottom; y < top; y += spacing) {
            boolean isBottomFloor = y == bottom && bottom != spacing;
            boolean isTopFloor = y >= top - spacing;
            boolean isTowerTopFloor = y >= this.height - spacing - 2;
            this.makeThreeQuarterFloor(world, sbb, rotation, y, isBottomFloor, isTowerTopFloor);
            if (!isTopFloor) {
                this.makeLargeStairsUp(world, sbb, rotation, y);
            }
            if (!isTopFloor || isTowerTopFloor) {
                this.decorateFloor(world, manager, generator, decoRNG, sbb, rotation, y, isBottomFloor, isTopFloor);
            }
            rotation = rotation.method_10501(class_2470.field_11465);
        }
    }

    protected void addThreeQuarterFloorsDecorateBoss(class_5281 world, Random decoRNG, class_3341 sbb, int bottom, int top) {
        int spacing = 5;
        class_2470 rotation = RotationUtil.ROTATIONS[(this.field_15315.method_35416() + bottom) % 4];
        if (bottom == 0) {
            this.makeLargeStairsUp(world, sbb, rotation, 0);
            rotation = rotation.method_10501(class_2470.field_11465);
            bottom += spacing;
        }
        for (int y = bottom; y < top; y += spacing) {
            boolean isBottomFloor = y == bottom && bottom != spacing;
            boolean isTopFloor = y >= top - spacing;
            boolean isTowerTopFloor = y >= this.height - spacing - 2;
            this.makeThreeQuarterFloor(world, sbb, rotation, y, isBottomFloor, isTowerTopFloor);
            if (!isTopFloor) {
                this.makeLargeStairsUp(world, sbb, rotation, y);
                this.decorateExperiment(world, sbb, rotation, y);
            }
            rotation = rotation.method_10501(class_2470.field_11465);
        }
    }

    private void decorateFloor(class_5281 world, class_5138 manager, class_2794 generator, Random decoRNG, class_3341 sbb, class_2470 rotation, int y, boolean isBottom, boolean isTop) {
        if (isTop) {
            switch (decoRNG.nextInt(3)) {
                case 1: {
                    this.decorateBotanical(world, generator, decoRNG, sbb, rotation, y);
                    break;
                }
                case 2: {
                    this.decorateNetherwart(world, decoRNG, sbb, rotation, y, isTop);
                    break;
                }
                default: {
                    this.decorateAquarium(world, sbb, rotation, y);
                    break;
                }
            }
        } else if (isBottom) {
            switch (decoRNG.nextInt(4)) {
                default: {
                    this.decorateAquarium(world, sbb, rotation, y);
                    break;
                }
                case 1: {
                    this.decorateBotanical(world, generator, decoRNG, sbb, rotation, y);
                    break;
                }
                case 2: {
                    if (y + this.field_15315.method_35416() > 64) {
                        this.decorateNetherwart(world, decoRNG, sbb, rotation, y, isTop);
                        break;
                    }
                }
                case 3: {
                    this.decorateForge(world, decoRNG, sbb, rotation, y);
                    break;
                }
            }
        } else {
            switch (decoRNG.nextInt(8)) {
                default: {
                    this.decorateReappearingMaze(world, manager, generator, decoRNG, sbb, rotation, y);
                    break;
                }
                case 2: {
                    this.decorateUnbuilderMaze(world, decoRNG, sbb, rotation, y);
                    break;
                }
                case 3: {
                    this.decorateAquarium(world, sbb, rotation, y);
                    break;
                }
                case 4: {
                    this.decorateBotanical(world, generator, decoRNG, sbb, rotation, y);
                    break;
                }
                case 5: {
                    if (y + this.field_15315.method_35416() > 64) {
                        this.decorateNetherwart(world, decoRNG, sbb, rotation, y, isTop);
                        break;
                    }
                }
                case 6: {
                    this.decorateLounge(world, generator, decoRNG, sbb, rotation, y);
                    break;
                }
                case 7: {
                    this.decorateForge(world, decoRNG, sbb, rotation, y);
                }
            }
        }
    }

    protected void makeThreeQuarterFloor(class_5281 world, class_3341 sbb, class_2470 rotation, int y, boolean isBottom, boolean isTowerTopFloor) {
        int half = this.size / 2;
        this.fillBlocksRotated(world, sbb, half + 1, y, 1, this.size - 2, y, half + 1, this.deco.blockState, rotation);
        this.fillBlocksRotated(world, sbb, 1, y, half + 1, this.size - 2, y, this.size - 2, this.deco.blockState, rotation);
        int startZ = isBottom ? 1 : 3;
        this.fillBlocksRotated(world, sbb, 1, y, half, half, y, half, this.deco.accentState, rotation);
        this.fillBlocksRotated(world, sbb, half, y, startZ, half, y, half, this.deco.accentState, rotation);
        this.fillBlocksRotated(world, sbb, 1, y + 1, half, half, y + 1, half, this.deco.fenceState, rotation);
        this.fillBlocksRotated(world, sbb, half, y + 1, startZ, half, y + 1, half, this.deco.fenceState, rotation);
        if (isTowerTopFloor) {
            this.fillBlocksRotated(world, sbb, 1, y, half - 2, 3, y, half, this.deco.accentState, rotation);
            this.fillBlocksRotated(world, sbb, 1, y + 1, half - 2, 3, y + 1, half, this.deco.fenceState, rotation);
            this.fillBlocksRotated(world, sbb, 1, y, half - 1, 2, y, half, this.deco.fenceState, rotation);
            this.fillBlocksRotated(world, sbb, 1, y + 1, half - 1, 2, y + 1, half, AIR, rotation);
        }
    }

    protected void makeLargeStairsUp(class_5281 world, class_3341 sbb, class_2470 rotation, int y) {
        for (int i = 0; i < 5; ++i) {
            int z = this.size / 2 - i + 4;
            int sy = y + i + 1;
            this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11035, false), 1, sy, z, rotation, sbb);
            this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11035, false), 2, sy, z, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.blockState, 1, sy, z - 1, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.blockState, 2, sy, z - 1, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.blockState, 3, sy, z - 1, rotation, sbb);
            if (i > 0 && i < 4) {
                this.setBlockStateRotated(world, this.deco.accentState, 3, sy, z, rotation, sbb);
                this.setBlockStateRotated(world, this.deco.fenceState, 3, sy + 1, z, rotation, sbb);
                this.setBlockStateRotated(world, this.deco.fenceState, 3, sy + 2, z, rotation, sbb);
                continue;
            }
            if (i != 0) continue;
            this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11034, false), 3, sy, z, rotation, sbb);
        }
    }

    private void decorateReappearingMaze(class_5281 world, class_5138 manager, class_2794 generator, Random decoRNG, class_3341 sbb, class_2470 rotation, int y) {
        int mazeSize = 6;
        TFMaze maze = new TFMaze(mazeSize, mazeSize);
        maze.setSeed(world.method_8412() + (long)this.field_15315.method_35415() * 90342903L + (long)y * 90342903L ^ (long)this.field_15315.method_35417());
        for (int i = 0; i < 13; ++i) {
            maze.putRaw(i, 0, 5);
            maze.putRaw(i, 12, 5);
            maze.putRaw(0, i, 5);
            maze.putRaw(12, i, 5);
        }
        maze.doorRarity = 0.3f;
        switch (rotation) {
            case field_11467: {
                int x;
                for (x = 1; x < 6; ++x) {
                    for (int z = 1; z < 6; ++z) {
                        maze.putRaw(x, z, 5);
                    }
                }
                maze.putRaw(1, 6, 5);
                maze.putRaw(1, 7, 5);
                maze.putRaw(1, 8, 5);
                maze.putRaw(1, 9, 5);
                maze.putRaw(1, 10, 6);
                maze.putRaw(6, 1, 5);
                maze.putRaw(7, 1, 5);
                maze.putRaw(8, 1, 6);
                maze.generateRecursiveBacktracker(0, 5);
                break;
            }
            case field_11463: {
                int x;
                for (x = 7; x < 12; ++x) {
                    for (int z = 1; z < 6; ++z) {
                        maze.putRaw(x, z, 5);
                    }
                }
                maze.putRaw(6, 1, 5);
                maze.putRaw(5, 1, 5);
                maze.putRaw(4, 1, 5);
                maze.putRaw(3, 1, 5);
                maze.putRaw(2, 1, 6);
                maze.putRaw(11, 6, 5);
                maze.putRaw(11, 7, 5);
                maze.putRaw(11, 8, 6);
                maze.generateRecursiveBacktracker(0, 0);
                break;
            }
            case field_11464: {
                int x;
                for (x = 7; x < 12; ++x) {
                    for (int z = 7; z < 12; ++z) {
                        maze.putRaw(x, z, 5);
                    }
                }
                maze.putRaw(11, 6, 5);
                maze.putRaw(11, 5, 5);
                maze.putRaw(11, 4, 5);
                maze.putRaw(11, 3, 5);
                maze.putRaw(11, 2, 6);
                maze.putRaw(6, 11, 5);
                maze.putRaw(5, 11, 5);
                maze.putRaw(4, 11, 6);
                maze.generateRecursiveBacktracker(5, 0);
                break;
            }
            case field_11465: {
                int x;
                for (x = 1; x < 6; ++x) {
                    for (int z = 7; z < 12; ++z) {
                        maze.putRaw(x, z, 5);
                    }
                }
                maze.putRaw(6, 11, 5);
                maze.putRaw(7, 11, 5);
                maze.putRaw(8, 11, 5);
                maze.putRaw(9, 11, 5);
                maze.putRaw(10, 11, 6);
                maze.putRaw(1, 6, 5);
                maze.putRaw(1, 5, 5);
                maze.putRaw(1, 4, 6);
                maze.generateRecursiveBacktracker(5, 5);
            }
        }
        maze.wallBlockState = this.deco.blockState;
        maze.headBlockState = this.deco.accentState;
        maze.pillarBlockState = this.deco.accentState;
        maze.doorBlockState = ((class_2248)TFBlocks.REAPPEARING_BLOCK.get()).method_9564();
        maze.torchRarity = 0.0f;
        maze.tall = 3;
        maze.head = 1;
        maze.oddBias = 2;
        maze.copyToStructure(world, manager, generator, 0, y + 1, 0, this, sbb);
        this.decorateMazeDeadEnds(world, decoRNG, maze, y, rotation, sbb);
    }

    protected void decorateMazeDeadEnds(class_5281 world, Random decoRNG, TFMaze maze, int y, class_2470 rotation, class_3341 sbb) {
        for (int x = 0; x < maze.width; ++x) {
            for (int z = 0; z < maze.depth; ++z) {
                if (!maze.isWall(x, z, x - 1, z) && maze.isWall(x, z, x + 1, z) && maze.isWall(x, z, x, z - 1) && maze.isWall(x, z, x, z + 1)) {
                    this.decorateDeadEnd(world, x, y, z, 3, sbb);
                }
                if (maze.isWall(x, z, x - 1, z) && !maze.isWall(x, z, x + 1, z) && maze.isWall(x, z, x, z - 1) && maze.isWall(x, z, x, z + 1)) {
                    this.decorateDeadEnd(world, x, y, z, 1, sbb);
                }
                if (maze.isWall(x, z, x - 1, z) && maze.isWall(x, z, x + 1, z) && !maze.isWall(x, z, x, z - 1) && maze.isWall(x, z, x, z + 1)) {
                    this.decorateDeadEnd(world, x, y, z, 0, sbb);
                }
                if (!maze.isWall(x, z, x - 1, z) || !maze.isWall(x, z, x + 1, z) || !maze.isWall(x, z, x, z - 1) || maze.isWall(x, z, x, z + 1)) continue;
                this.decorateDeadEnd(world, x, y, z, 2, sbb);
            }
        }
    }

    private void decorateDeadEnd(class_5281 world, int mx, int y, int mz, int facing, class_3341 sbb) {
        int x = mx * 3 + 1;
        int z = mz * 3 + 1;
        switch (facing) {
            case 0: {
                this.method_14917(world, this.deco.accentState, x, y + 1, z + 1, sbb);
                this.method_14917(world, this.deco.accentState, x + 1, y + 1, z + 1, sbb);
                this.setDoubleLootChest(world, x, y + 2, z + 1, x + 1, y + 2, z + 1, class_2350.field_11035, TFTreasure.DARKTOWER_CACHE, sbb, false);
                break;
            }
            case 1: {
                this.method_14917(world, this.deco.accentState, x, y + 1, z, sbb);
                this.method_14917(world, this.deco.accentState, x, y + 1, z + 1, sbb);
                this.setDoubleLootChest(world, x, y + 2, z, x, y + 2, z + 1, class_2350.field_11039, TFTreasure.DARKTOWER_CACHE, sbb, false);
                break;
            }
            case 2: {
                this.method_14917(world, this.deco.accentState, x, y + 1, z, sbb);
                this.method_14917(world, this.deco.accentState, x + 1, y + 1, z, sbb);
                this.setDoubleLootChest(world, x + 1, y + 2, z, x, y + 2, z, class_2350.field_11043, TFTreasure.DARKTOWER_CACHE, sbb, false);
                break;
            }
            case 3: {
                this.method_14917(world, this.deco.accentState, x + 1, y + 1, z, sbb);
                this.method_14917(world, this.deco.accentState, x + 1, y + 1, z + 1, sbb);
                this.setDoubleLootChest(world, x + 1, y + 2, z + 1, x + 1, y + 2, z, class_2350.field_11034, TFTreasure.DARKTOWER_CACHE, sbb, false);
            }
        }
    }

    private void decorateUnbuilderMaze(class_5281 world, Random decoRNG, class_3341 sbb, class_2470 rotation, int y) {
        for (int x = this.size / 2; x < this.size - 1; ++x) {
            for (int z = 3; z < this.size - 1; ++z) {
                int py;
                if (x % 2 == 1 && z % 2 == 1) {
                    for (py = 1; py < 5; ++py) {
                        this.setBlockStateRotated(world, this.deco.pillarState, x, y + py, z, rotation, sbb);
                    }
                    continue;
                }
                if (x % 2 != 1 && z % 2 != 1) continue;
                for (py = 1; py < 5; ++py) {
                    this.setBlockStateRotated(world, this.deco.fenceState, x, y + py, z, rotation, sbb);
                }
                if (x == this.size / 2 || x == this.size - 2 || z == this.size - 2) continue;
                int ay = decoRNG.nextInt(4) + 1;
                this.setBlockStateRotated(world, AIR, x, y + ay, z, rotation, sbb);
                if (x <= this.size - 7) continue;
                ay = decoRNG.nextInt(3) + 1;
                this.setBlockStateRotated(world, AIR, x, y + ay, z, rotation, sbb);
            }
        }
        class_2680 antiBuilderBlockState = ((class_2248)TFBlocks.ANTIBUILDER.get()).method_9564();
        this.setBlockStateRotated(world, antiBuilderBlockState, 15, y + 2, 7, rotation, sbb);
        this.setBlockStateRotated(world, antiBuilderBlockState, 11, y + 3, 7, rotation, sbb);
        this.setBlockStateRotated(world, antiBuilderBlockState, 15, y + 2, 13, rotation, sbb);
        this.setBlockStateRotated(world, antiBuilderBlockState, 11, y + 3, 13, rotation, sbb);
        this.setBlockStateRotated(world, antiBuilderBlockState, 5, y + 3, 13, rotation, sbb);
    }

    private void decorateLounge(class_5281 world, class_2794 generator, Random decoRNG, class_3341 sbb, class_2470 rotation, int y) {
        this.fillBlocksRotated(world, sbb, 17, y + 1, 1, 17, y + 4, 6, this.deco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 1, 17, y + 4, 1, this.deco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 13, y + 1, 2, 16, y + 1, 5, this.deco.blockState, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 2, 12, y + 1, 6, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11039, false), rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 6, 16, y + 1, 6, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11035, false), rotation);
        this.makeDispenserPillar(world, this.deco, 13, y, 1, class_2350.field_11035, rotation, sbb);
        this.makeDispenserPillar(world, this.deco, 15, y, 1, class_2350.field_11035, rotation, sbb);
        this.makeDispenserPillar(world, this.deco, 17, y, 3, class_2350.field_11039, rotation, sbb);
        this.makeDispenserPillar(world, this.deco, 17, y, 5, class_2350.field_11039, rotation, sbb);
        this.makeStonePillar(world, this.deco, 12, y, 1, rotation, sbb);
        this.makeStonePillar(world, this.deco, 17, y, 6, rotation, sbb);
        this.setBlockStateRotated(world, class_2246.field_10333.method_9564(), 13, y + 2, 5, rotation, sbb);
        this.setBlockStateRotated(world, (class_2680)class_2246.field_27097.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(3)), 15, y + 2, 3, rotation, sbb);
        this.fillBlocksRotated(world, sbb, 10, y + 1, 17, 17, y + 4, 17, this.deco.blockState, rotation);
        this.fillBlocksRotated(world, sbb, 17, y + 1, 10, 17, y + 4, 17, this.deco.blockState, rotation);
        this.fillBlocksRotated(world, sbb, 11, y + 1, 17, 12, y + 4, 17, class_2246.field_10504.method_9564(), rotation);
        this.fillBlocksRotated(world, sbb, 14, y + 1, 17, 15, y + 4, 17, class_2246.field_10504.method_9564(), rotation);
        this.fillBlocksRotated(world, sbb, 17, y + 1, 11, 17, y + 4, 12, class_2246.field_10504.method_9564(), rotation);
        this.fillBlocksRotated(world, sbb, 17, y + 1, 14, 17, y + 4, 15, class_2246.field_10504.method_9564(), rotation);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11035, true), 13, y + 1, 14, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11034, true), 14, y + 1, 14, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11043, true), 14, y + 1, 13, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11039, true), 13, y + 1, 13, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11034, false), 11, y + 1, 13, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11035, false), 13, y + 1, 11, rotation, sbb);
        this.setBlockStateRotated(world, class_2246.field_10524.method_9564(), 8, y + 3, 8, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getLeverState(class_2246.field_10363.method_9564(), class_2738.field_12473, decoRNG.nextBoolean() ? class_2350.field_11034 : class_2350.field_11043, false), 8, y + 2, 8, rotation, sbb);
        this.placeTreePlanter(world, generator, decoRNG.nextInt(5), 6, y + 1, 12, rotation, sbb);
    }

    private void makeDispenserPillar(class_5281 world, TFStructureDecorator forgeDeco, int x, int y, int z, class_2350 stairMeta, class_2470 rotation, class_3341 sbb) {
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(forgeDeco.stairState, stairMeta, true), x, y + 2, z, rotation, sbb);
        this.setBlockStateRotated(world, (class_2680)class_2246.field_10200.method_9564().method_11657((class_2769)class_2315.field_10918, (Comparable)stairMeta.method_10153()), x, y + 3, z, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(forgeDeco.stairState, stairMeta, false), x, y + 4, z, rotation, sbb);
    }

    private void decorateBossSpawner(class_5281 world, class_3341 sbb, class_2470 rotation, int y) {
        this.setBlockStateRotated(world, ((class_2248)TFBlocks.UR_GHAST_BOSS_SPAWNER.get()).method_9564(), 9, y + 4, 9, rotation, sbb);
    }

    private void decorateExperiment(class_5281 world, class_3341 sbb, class_2470 rotation, int y) {
        class_2680 obsidian = class_2246.field_10540.method_9564();
        class_2680 netherrack = class_2246.field_10515.method_9564();
        class_2680 redstone = class_2246.field_10002.method_9564();
        class_2680 inactiveReactor = ((class_2248)TFBlocks.CARMINITE_REACTOR.get()).method_9564();
        this.fillBlocksRotated(world, sbb, 17, y + 1, 1, 17, y + 4, 6, this.deco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 1, 17, y + 4, 1, this.deco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 13, y + 1, 2, 16, y + 1, 5, this.deco.blockState, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 2, 12, y + 1, 6, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11039, false), rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 6, 16, y + 1, 6, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11035, false), rotation);
        this.makeWoodPillar(world, 13, y, 1, rotation, sbb);
        this.makeWoodPillar(world, 15, y, 1, rotation, sbb);
        this.makeWoodPillar(world, 17, y, 3, rotation, sbb);
        this.makeWoodPillar(world, 17, y, 5, rotation, sbb);
        this.makeStonePillar(world, this.deco, 12, y, 1, rotation, sbb);
        this.makeStonePillar(world, this.deco, 17, y, 6, rotation, sbb);
        this.setBlockStateRotated(world, class_2246.field_9980.method_9564(), 14, y + 2, 4, rotation, sbb);
        this.placeItemFrameRotated(world, 13, y + 2, 1, rotation, class_2350.field_11035, new class_1799((class_1935)TFItems.BORER_ESSENCE.get()), sbb);
        this.placeItemFrameRotated(world, 14, y + 2, 1, rotation, class_2350.field_11035, new class_1799((class_1935)class_1802.field_8725), sbb);
        this.placeItemFrameRotated(world, 15, y + 2, 1, rotation, class_2350.field_11035, new class_1799((class_1935)TFItems.BORER_ESSENCE.get()), sbb);
        this.placeItemFrameRotated(world, 13, y + 3, 1, rotation, class_2350.field_11035, new class_1799((class_1935)class_1802.field_8725), sbb);
        this.placeItemFrameRotated(world, 14, y + 3, 1, rotation, class_2350.field_11035, new class_1799((class_1935)class_1802.field_8070), sbb);
        this.placeItemFrameRotated(world, 15, y + 3, 1, rotation, class_2350.field_11035, new class_1799((class_1935)class_1802.field_8725), sbb);
        this.placeItemFrameRotated(world, 13, y + 4, 1, rotation, class_2350.field_11035, new class_1799((class_1935)TFItems.BORER_ESSENCE.get()), sbb);
        this.placeItemFrameRotated(world, 14, y + 4, 1, rotation, class_2350.field_11035, new class_1799((class_1935)class_1802.field_8725), sbb);
        this.placeItemFrameRotated(world, 15, y + 4, 1, rotation, class_2350.field_11035, new class_1799((class_1935)TFItems.BORER_ESSENCE.get()), sbb);
        this.placeItemFrameRotated(world, 17, y + 2, 3, rotation, class_2350.field_11039, new class_1799((class_1935)TFBlocks.ENCASED_TOWERWOOD.get()), sbb);
        this.placeItemFrameRotated(world, 17, y + 2, 4, rotation, class_2350.field_11039, new class_1799((class_1935)TFBlocks.TOWERWOOD.get()), sbb);
        this.placeItemFrameRotated(world, 17, y + 2, 5, rotation, class_2350.field_11039, new class_1799((class_1935)TFBlocks.ENCASED_TOWERWOOD.get()), sbb);
        this.placeItemFrameRotated(world, 17, y + 3, 3, rotation, class_2350.field_11039, new class_1799((class_1935)TFBlocks.TOWERWOOD.get()), sbb);
        this.placeItemFrameRotated(world, 17, y + 3, 4, rotation, class_2350.field_11039, new class_1799((class_1935)TFItems.CARMINITE.get()), sbb);
        this.placeItemFrameRotated(world, 17, y + 3, 5, rotation, class_2350.field_11039, new class_1799((class_1935)TFBlocks.TOWERWOOD.get()), sbb);
        this.placeItemFrameRotated(world, 17, y + 4, 3, rotation, class_2350.field_11039, new class_1799((class_1935)TFBlocks.ENCASED_TOWERWOOD.get()), sbb);
        this.placeItemFrameRotated(world, 17, y + 4, 4, rotation, class_2350.field_11039, new class_1799((class_1935)TFBlocks.TOWERWOOD.get()), sbb);
        this.placeItemFrameRotated(world, 17, y + 4, 5, rotation, class_2350.field_11039, new class_1799((class_1935)TFBlocks.ENCASED_TOWERWOOD.get()), sbb);
        if (y < this.height - 13) {
            this.setBlockStateRotated(world, obsidian, 13, y + 1, 13, rotation, sbb);
            this.setBlockStateRotated(world, obsidian, 15, y + 1, 13, rotation, sbb);
            this.setBlockStateRotated(world, obsidian, 13, y + 1, 15, rotation, sbb);
            this.setBlockStateRotated(world, obsidian, 15, y + 1, 15, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 13, y + 1, 14, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 14, y + 1, 13, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 15, y + 1, 14, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 14, y + 1, 15, rotation, sbb);
            this.setBlockStateRotated(world, redstone, 14, y + 1, 14, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 13, y + 2, 13, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 15, y + 2, 13, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 13, y + 2, 15, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 15, y + 2, 15, rotation, sbb);
            this.setBlockStateRotated(world, inactiveReactor, 14, y + 2, 14, rotation, sbb);
            this.setBlockStateRotated(world, obsidian, 13, y + 3, 13, rotation, sbb);
            this.setBlockStateRotated(world, obsidian, 15, y + 3, 13, rotation, sbb);
            this.setBlockStateRotated(world, obsidian, 13, y + 3, 15, rotation, sbb);
            this.setBlockStateRotated(world, obsidian, 15, y + 3, 15, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 13, y + 3, 14, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 14, y + 3, 13, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 15, y + 3, 14, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 14, y + 3, 15, rotation, sbb);
            this.setBlockStateRotated(world, redstone, 14, y + 3, 14, rotation, sbb);
        }
        this.setBlockStateRotated(world, this.deco.accentState, 14, y + 1, 17, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getLeverState(class_2246.field_10363.method_9564(), class_2738.field_12471, class_2350.field_11034, false), 13, y + 1, 17, rotation, sbb);
        this.setBlockStateRotated(world, (class_2680)class_2246.field_10560.method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)class_2350.field_11035), 14, y + 2, 17, rotation, sbb);
        this.setBlockStateRotated(world, redstone, 14, y + 2, 16, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, 17, y + 1, 14, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getLeverState(class_2246.field_10363.method_9564(), class_2738.field_12471, class_2350.field_11035, false), 17, y + 1, 13, rotation, sbb);
        this.setBlockStateRotated(world, (class_2680)class_2246.field_10560.method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)class_2350.field_11034), 17, y + 2, 14, rotation, sbb);
        this.setBlockStateRotated(world, redstone, 16, y + 2, 14, rotation, sbb);
        this.setBlockStateRotated(world, redstone, 14, y + 2, 11, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, 14, y + 1, 11, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getLeverState(class_2246.field_10363.method_9564(), class_2738.field_12471, class_2350.field_11034, true), 13, y + 1, 11, rotation, sbb);
        this.setBlockStateRotated(world, (class_2680)class_2246.field_10560.method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)class_2350.field_11043), 14, y + 2, 10, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, 14, y + 1, 9, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getLeverState(class_2246.field_10363.method_9564(), class_2738.field_12471, class_2350.field_11034, false), 13, y + 1, 9, rotation, sbb);
        this.setBlockStateRotated(world, (class_2680)class_2246.field_10615.method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)class_2350.field_11043), 14, y + 2, 9, rotation, sbb);
        this.setBlockStateRotated(world, redstone, 11, y + 2, 14, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, 11, y + 1, 14, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getLeverState(class_2246.field_10363.method_9564(), class_2738.field_12471, class_2350.field_11035, true), 11, y + 1, 13, rotation, sbb);
        this.setBlockStateRotated(world, (class_2680)class_2246.field_10560.method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)class_2350.field_11039), 10, y + 2, 14, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, 9, y + 1, 14, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getLeverState(class_2246.field_10363.method_9564(), class_2738.field_12471, class_2350.field_11035, false), 9, y + 1, 13, rotation, sbb);
        this.setBlockStateRotated(world, (class_2680)class_2246.field_10615.method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)class_2350.field_11039), 9, y + 2, 14, rotation, sbb);
    }

    private void makeWoodPillar(class_5281 world, int x, int y, int z, class_2470 rotation, class_3341 sbb) {
        class_2680 log = ((class_2465)TFBlocks.DARK_LOG.get()).method_9564();
        this.setBlockStateRotated(world, log, x, y + 2, z, rotation, sbb);
        this.setBlockStateRotated(world, log, x, y + 3, z, rotation, sbb);
        this.setBlockStateRotated(world, log, x, y + 4, z, rotation, sbb);
    }

    private void placeItemFrameRotated(class_5281 world, int x, int y, int z, class_2470 rotation, class_2350 direction, class_1799 itemStack, class_3341 sbb) {
        class_2350 facing;
        int dz;
        int dy;
        int dx = this.getXWithOffsetRotated(x, z, rotation);
        class_2338 pos = new class_2338(dx, dy = this.method_14924(y), dz = this.getZWithOffsetRotated(x, z, rotation)).method_10093(facing = this.field_15313.method_10501(rotation).method_10503(direction).method_10153());
        if (sbb.method_14662((class_2382)pos)) {
            class_1533 frame = new class_1533((class_1937)world.method_8410(), pos, facing);
            if (!itemStack.method_7960()) {
                frame.method_6933(itemStack, false);
            }
            world.method_8649((class_1297)frame);
        }
    }

    private void decorateAquarium(class_5281 world, class_3341 sbb, class_2470 rotation, int y) {
        this.makePillarFrame(world, sbb, this.deco, rotation, 12, y, 3, 4, 4, 13, false);
        this.fillBlocksRotated(world, sbb, 13, y + 4, 4, 14, y + 4, 14, class_2246.field_10382.method_9564(), rotation);
        this.makePillarFrame(world, sbb, this.deco, rotation, 6, y, 12, 4, 4, 4, false);
        this.fillBlocksRotated(world, sbb, 6, y + 5, 12, 9, y + 5, 15, this.deco.accentState, rotation);
        this.fillBlocksRotated(world, sbb, 7, y + 4, 13, 8, y + 5, 14, class_2246.field_10382.method_9564(), rotation);
    }

    private void decorateForge(class_5281 world, Random decoRNG, class_3341 sbb, class_2470 rotation, int y) {
        TFStructureDecorator forgeDeco = this.deco;
        this.fillBlocksRotated(world, sbb, 17, y + 1, 1, 17, y + 4, 6, forgeDeco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 1, 17, y + 4, 1, forgeDeco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 17, 17, y + 4, 17, forgeDeco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 17, y + 1, 12, 17, y + 4, 17, forgeDeco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 13, y + 1, 2, 16, y + 1, 5, forgeDeco.blockState, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 2, 12, y + 1, 6, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11039, false), rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 6, 16, y + 1, 6, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11035, false), rotation);
        this.fillBlocksRotated(world, sbb, 13, y + 1, 13, 16, y + 1, 16, forgeDeco.blockState, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 12, 12, y + 1, 16, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11039, false), rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 12, 16, y + 1, 12, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11043, false), rotation);
        this.makeFurnacePillar(world, decoRNG, 13, y, 1, class_2350.field_11035, rotation, sbb);
        this.makeFurnacePillar(world, decoRNG, 15, y, 1, class_2350.field_11035, rotation, sbb);
        this.makeFurnacePillar(world, decoRNG, 17, y, 3, class_2350.field_11039, rotation, sbb);
        this.makeFurnacePillar(world, decoRNG, 17, y, 5, class_2350.field_11039, rotation, sbb);
        this.makeFurnacePillar(world, decoRNG, 13, y, 17, class_2350.field_11043, rotation, sbb);
        this.makeFurnacePillar(world, decoRNG, 15, y, 17, class_2350.field_11043, rotation, sbb);
        this.makeFurnacePillar(world, decoRNG, 17, y, 13, class_2350.field_11039, rotation, sbb);
        this.makeFurnacePillar(world, decoRNG, 17, y, 15, class_2350.field_11039, rotation, sbb);
        this.makeStonePillar(world, forgeDeco, 17, y, 6, rotation, sbb);
        this.makeStonePillar(world, forgeDeco, 12, y, 17, rotation, sbb);
        this.makeStonePillar(world, forgeDeco, 17, y, 12, rotation, sbb);
        this.makeStonePillar(world, forgeDeco, 17, y, 9, rotation, sbb);
        this.makeStonePillar(world, forgeDeco, 9, y, 17, rotation, sbb);
        this.setBlockStateRotated(world, (class_2680)List.of(class_2246.field_10535, class_2246.field_10105, class_2246.field_10414).get(decoRNG.nextInt(3)).method_9564().method_11657((class_2769)class_2199.field_9883, (Comparable)class_2350.class_2353.field_11062.method_10183(decoRNG)), 13, y + 2, 5, rotation, sbb);
        this.setBlockStateRotated(world, (class_2680)List.of(class_2246.field_10535, class_2246.field_10105, class_2246.field_10414).get(decoRNG.nextInt(3)).method_9564().method_11657((class_2769)class_2199.field_9883, (Comparable)class_2350.class_2353.field_11062.method_10183(decoRNG)), 13, y + 2, 13, rotation, sbb);
        this.makeFirePit(world, forgeDeco, 6, y + 1, 12, rotation, sbb);
    }

    private void makeFurnacePillar(class_5281 world, Random rand, int x, int y, int z, class_2350 direction, class_2470 rotation, class_3341 sbb) {
        int dz;
        int dy;
        int dx;
        class_2338 pos;
        int amount;
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, direction, true), x, y + 2, z, rotation, sbb);
        this.setBlockStateRotated(world, (class_2680)class_2246.field_10181.method_9564().method_11657((class_2769)class_2363.field_11104, (Comparable)direction.method_10153()), x, y + 3, z, rotation, sbb);
        int n = amount = rand.nextBoolean() ? rand.nextInt(5) + 4 : 0;
        if (amount > 0 && sbb.method_14662((class_2382)(pos = new class_2338(dx = this.getXWithOffsetRotated(x, z, rotation), dy = this.method_14924(y + 3), dz = this.getZWithOffsetRotated(x, z, rotation)))) && world.method_8320(pos).method_26204() == class_2246.field_10181) {
            class_1263 inv = (class_1263)world.method_8321(pos);
            inv.method_5447(1, new class_1799((class_1935)class_1802.field_8665, amount));
        }
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, direction, false), x, y + 4, z, rotation, sbb);
    }

    private void makeStonePillar(class_5281 world, TFStructureDecorator forgeDeco, int x, int y, int z, class_2470 rotation, class_3341 sbb) {
        for (int py = 1; py <= 4; ++py) {
            this.setBlockStateRotated(world, forgeDeco.pillarState, x, y + py, z, rotation, sbb);
        }
    }

    private void makeFirePit(class_5281 world, TFStructureDecorator myDeco, int x, int y, int z, class_2470 rotation, class_3341 sbb) {
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11039, false), x - 1, y, z, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11034, false), x + 1, y, z, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11035, false), x, y, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11043, false), x, y, z - 1, rotation, sbb);
        this.setBlockStateRotated(world, myDeco.pillarState, x + 1, y, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, myDeco.pillarState, x + 1, y, z - 1, rotation, sbb);
        this.setBlockStateRotated(world, myDeco.pillarState, x - 1, y, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, myDeco.pillarState, x - 1, y, z - 1, rotation, sbb);
        this.setBlockStateRotated(world, class_2246.field_10515.method_9564(), x, y, z, rotation, sbb);
        this.setBlockStateRotated(world, class_2246.field_10036.method_9564(), x, y + 1, z, rotation, sbb);
    }

    private void decorateNetherwart(class_5281 world, Random decoRNG, class_3341 sbb, class_2470 rotation, int y, boolean isTop) {
        TFStructureDecorator netherDeco = this.deco;
        this.makePillarFrame(world, sbb, netherDeco, rotation, 12, y, 9, 4, 4, 7, true);
        this.fillBlocksRotated(world, sbb, 13, y + 1, 10, 14, y + 1, 14, class_2246.field_10114.method_9564(), rotation);
        this.fillBlocksRotated(world, sbb, 13, y + 2, 10, 14, y + 2, 14, class_2246.field_9974.method_9564(), rotation);
        this.fillBlocksRotated(world, sbb, 13, y + 4, 10, 14, y + 4, 14, class_2246.field_10114.method_9564(), rotation);
        this.makePillarFrame(world, sbb, netherDeco, rotation, 5, y, 12, 3, isTop ? 4 : 9, 3, true);
        this.setBlockStateRotated(world, netherDeco.blockState, 6, y + 1, 13, rotation, sbb);
        this.setBlockStateRotated(world, netherDeco.blockState, 6, y + (isTop ? 4 : 9), 13, rotation, sbb);
        this.setSpawnerRotated(world, 6, y + 3, 13, rotation, class_1299.field_6099, sbb);
        this.destroyTower(world, decoRNG, 12, y, 3, 2, sbb);
    }

    private void decorateBotanical(class_5281 world, class_2794 generator, Random decoRNG, class_3341 sbb, class_2470 rotation, int y) {
        this.makePillarFrame(world, sbb, this.deco, rotation, 12, y, 12, 4, 4, 4, true);
        this.fillBlocksRotated(world, sbb, 13, y + 1, 13, 14, y + 1, 14, this.deco.blockState, rotation);
        this.fillBlocksRotated(world, sbb, 13, y + 4, 13, 14, y + 4, 14, this.deco.blockState, rotation);
        this.placeRandomPlant(world, decoRNG, 13, y + 2, 13, rotation, sbb);
        this.placeRandomPlant(world, decoRNG, 13, y + 2, 14, rotation, sbb);
        this.placeRandomPlant(world, decoRNG, 14, y + 2, 13, rotation, sbb);
        this.placeRandomPlant(world, decoRNG, 14, y + 2, 14, rotation, sbb);
        for (int py = 1; py <= 4; ++py) {
            this.setBlockStateRotated(world, this.deco.pillarState, 12, y + py, 4, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.pillarState, 15, y + py, 4, rotation, sbb);
        }
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11034, true), 13, y + 1, 4, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11039, true), 14, y + 1, 4, rotation, sbb);
        this.placeTreasureRotated(world, 13, y + 2, 4, this.method_14934(), rotation, TFTreasure.DARKTOWER_CACHE, sbb);
        this.setBlockStateRotated(world, class_2246.field_9980.method_9564(), 14, y + 2, 4, rotation, sbb);
        class_2680 slab = (class_2680)class_2246.field_10071.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11034, true), 12, y + 1, 7, rotation, sbb);
        this.setBlockStateRotated(world, slab, 13, y + 1, 7, rotation, sbb);
        this.setBlockStateRotated(world, slab, 14, y + 1, 7, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11039, true), 15, y + 1, 7, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11034, true), 12, y + 1, 10, rotation, sbb);
        this.setBlockStateRotated(world, slab, 13, y + 1, 10, rotation, sbb);
        this.setBlockStateRotated(world, slab, 14, y + 1, 10, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11039, true), 15, y + 1, 10, rotation, sbb);
        for (int x = 12; x <= 15; ++x) {
            this.placeRandomPlant(world, decoRNG, x, y + 2, 7, rotation, sbb);
            this.placeRandomPlant(world, decoRNG, x, y + 2, 10, rotation, sbb);
        }
        this.placeTreePlanter(world, generator, decoRNG.nextInt(5), 6, y + 1, 12, rotation, sbb);
    }

    private void placeTreePlanter(class_5281 world, class_2794 generator, int treeNum, int x, int y, int z, class_2470 rotation, class_3341 sbb) {
        this.setBlockStateRotated(world, this.deco.pillarState, x + 1, y, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.pillarState, x + 1, y, z - 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.pillarState, x - 1, y, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.pillarState, x - 1, y, z - 1, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11039, false), x - 1, y, z, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11034, false), x + 1, y, z, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11035, false), x, y, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getStairState(this.deco.stairState, class_2350.field_11043, false), x, y, z - 1, rotation, sbb);
        this.setBlockStateRotated(world, class_2246.field_10566.method_9564(), x, y, z, rotation, sbb);
        int dx = this.getXWithOffsetRotated(x, z, rotation);
        int dy = this.method_14924(y + 1);
        int dz = this.getZWithOffsetRotated(x, z, rotation);
        if (sbb.method_14662((class_2382)new class_2338(dx, dy, dz))) {
            class_6880 treeGen = switch (treeNum) {
                case 1 -> class_6808.field_35911;
                case 2 -> class_6808.field_35907;
                case 3 -> TFConfiguredFeatures.TWILIGHT_OAK_TREE;
                case 4 -> TFConfiguredFeatures.RAINBOW_OAK_TREE;
                default -> class_6808.field_35905;
            };
            for (int i = 0; i < 100 && !((class_2975)treeGen.comp_349()).method_12862(world, generator, world.method_8409(), new class_2338(dx, dy, dz)); ++i) {
            }
        }
    }

    private void placeRandomPlant(class_5281 world, Random decoRNG, int x, int y, int z, class_2470 rotation, class_3341 sbb) {
        class_2680 flowerPot = class_2378.field_11146.method_40266(BlockTagGenerator.DARK_TOWER_ALLOWED_POTS).flatMap(tag -> tag.method_40243(decoRNG)).map(holder -> ((class_2248)holder.comp_349()).method_9564()).orElse(class_2246.field_10495.method_9564());
        this.setBlockStateRotated(world, decoRNG.nextInt(10) == 0 ? class_2246.field_10495.method_9564() : flowerPot, x, y, z, rotation, sbb);
    }

    private void makeBottomEntrance(class_5281 world, class_3341 sbb, class_2470 rotation, int y) {
        this.makeFirePit(world, this.deco, 13, y + 1, 3, rotation, sbb);
        this.makeFirePit(world, this.deco, 3, y + 1, 13, rotation, sbb);
        this.makeFirePit(world, this.deco, 13, y + 1, 13, rotation, sbb);
        this.makePillarFrame(world, sbb, this.deco, rotation, 7, y, 7, 3, 4, 3, false);
    }

    protected void addTimberMaze(class_5281 world, Random rand, class_3341 sbb, int bottom, int top) {
        int spacing = 5;
        class_2470 floorside = class_2470.field_11467;
        if (bottom == 0) {
            bottom += spacing;
        }
        for (int y = bottom; y < top; y += spacing) {
            floorside = floorside.method_10501(class_2470.field_11463);
            this.makeTimberBeams(world, rand, sbb, floorside, y, y == bottom && bottom != spacing, y >= top - spacing, top);
        }
    }

    protected void makeTimberBeams(class_5281 world, Random rand, class_3341 sbb, class_2470 rotation, int y, boolean isBottom, boolean isTop, int top) {
        int x;
        int z;
        class_2680 beamID = ((class_2465)TFBlocks.TWILIGHT_OAK_LOG.get()).method_9564();
        class_2680 beamStateNS = (class_2680)beamID.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11051);
        class_2680 beamStateUD = (class_2680)beamID.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11052);
        class_2680 beamStateEW = (class_2680)beamID.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11048);
        for (z = 1; z < this.size - 1; ++z) {
            this.setBlockStateRotated(world, beamStateNS, 4, y, z, rotation, sbb);
            this.setBlockStateRotated(world, beamStateNS, 9, y, z, rotation, sbb);
            this.setBlockStateRotated(world, beamStateNS, 14, y, z, rotation, sbb);
        }
        z = this.pickBetweenExcluding(3, this.size - 3, rand, 4, 9, 14);
        for (x = 5; x < 9; ++x) {
            this.setBlockStateRotated(world, beamStateEW, x, y, z, rotation, sbb);
        }
        z = this.pickBetweenExcluding(3, this.size - 3, rand, 4, 9, 14);
        for (x = 10; x < 14; ++x) {
            this.setBlockStateRotated(world, beamStateEW, x, y, z, rotation, sbb);
        }
        int x1 = 4;
        int z1 = this.pickFrom(rand, 4, 9, 14);
        int x2 = 9;
        int z2 = this.pickFrom(rand, 4, 9, 14);
        int x3 = 14;
        int z3 = this.pickFrom(rand, 4, 9, 14);
        for (int by = 1; by < 5; ++by) {
            if (!isBottom || this.checkPost(world, x1, y - 5, z1, rotation, sbb)) {
                this.setBlockStateRotated(world, beamStateUD, x1, y - by, z1, rotation, sbb);
                this.setBlockStateRotated(world, (class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)class_2350.field_11039), x1 + 1, y - by, z1, rotation, sbb);
            }
            if (!isBottom || this.checkPost(world, x2, y - 5, z2, rotation, sbb)) {
                this.setBlockStateRotated(world, beamStateUD, x2, y - by, z2, rotation, sbb);
            }
            if (isBottom && !this.checkPost(world, x3, y - 5, z3, rotation, sbb)) continue;
            this.setBlockStateRotated(world, beamStateUD, x3, y - by, z3, rotation, sbb);
            this.setBlockStateRotated(world, (class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)class_2350.field_11034), x3 - 1, y - by, z3, rotation, sbb);
        }
        if (isTop) {
            class_2470 topFloorRotation = RotationUtil.ROTATIONS[(this.field_15315.method_35416() + top + 1) % 4];
            int ladderX = 4;
            int ladderZ = 10;
            for (int by = 1; by < 5; ++by) {
                this.setBlockStateRotated(world, beamStateUD, ladderX, y + by, 9, topFloorRotation, sbb);
                this.setBlockStateRotated(world, (class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)class_2350.field_11043), ladderX, y + by, ladderZ, topFloorRotation, sbb);
            }
            this.setBlockStateRotated(world, AIR, ladderX, y + 6, 9, topFloorRotation, sbb);
            this.setBlockStateRotated(world, this.deco.fenceState, ladderX + 1, y + 5, ladderZ, topFloorRotation, sbb);
            this.setBlockStateRotated(world, this.deco.fenceState, ladderX - 1, y + 5, ladderZ, topFloorRotation, sbb);
            this.setBlockStateRotated(world, this.deco.fenceState, ladderX + 1, y + 6, ladderZ, topFloorRotation, sbb);
            this.setBlockStateRotated(world, this.deco.fenceState, ladderX - 1, y + 6, ladderZ, topFloorRotation, sbb);
        }
        if (!isBottom && !isTop) {
            int sx = this.pickFrom(rand, 6, 7, 11);
            int sz = this.pickFrom(rand, 6, 11, 12);
            this.makeMiniGhastSpawner(world, y, sx, sz, sbb);
        }
        int lx = this.pickFrom(rand, 2, 12, 16);
        int lz = 2 + rand.nextInt(15);
        this.setBlockStateRotated(world, class_2246.field_10524.method_9564(), lx, y + 2, lz, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getLeverState(class_2246.field_10363.method_9564(), class_2738.field_12473, rand.nextBoolean() ? class_2350.field_11034 : class_2350.field_11043, false), lx, y + 1, lz, rotation, sbb);
    }

    private void makeMiniGhastSpawner(class_5281 world, int y, int sx, int sz, class_3341 sbb) {
        this.setSpawner(world, sx, y + 2, sz, sbb, (class_1299)TFEntities.CARMINITE_GHASTLING.get(), spawner -> {
            class_1917 base = spawner.method_11390();
            base.field_9157 = 16;
            base.field_9160 = 2;
            base.field_9149 = 1;
        });
    }

    protected void addBuilderPlatforms(class_5281 world, Random rand, class_3341 sbb, int bottom, int top) {
        int y;
        int spacing = 5;
        class_2470 floorside = class_2470.field_11467;
        if (bottom == 0) {
            bottom += spacing;
        }
        for (y = bottom; y < top - spacing; y += spacing) {
            this.makeBuilderPlatforms(world, rand, sbb, floorside, y);
            floorside = floorside.method_10501(class_2470.field_11463);
            floorside = floorside.method_10501(RotationUtil.ROTATIONS[rand.nextInt(3)]);
        }
        this.makeBuilderPlatform(world, rand, class_2470.field_11463, bottom, 5, true, sbb);
        this.makeBuilderPlatform(world, rand, class_2470.field_11465, bottom, 5, true, sbb);
        for (y = bottom - 4; y < bottom; ++y) {
            this.setBlockStateRotated(world, (class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)class_2350.field_11039), 1, y, 5, class_2470.field_11463, sbb);
            this.setBlockStateRotated(world, (class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)class_2350.field_11039), 1, y, 5, class_2470.field_11465, sbb);
        }
        this.addTopBuilderPlatform(world, rand, top, spacing, sbb);
    }

    protected void makeBuilderPlatforms(class_5281 world, Random rand, class_3341 sbb, class_2470 rotation, int y) {
        int z = this.size / 2 + rand.nextInt(5) - rand.nextInt(5);
        this.makeBuilderPlatform(world, rand, rotation, y, z, false, sbb);
        this.setBlockStateRotated(world, (class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)class_2350.field_11039), 1, y + 1, z, rotation, sbb);
        this.setBlockStateRotated(world, (class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)class_2350.field_11039), 1, y + 2, z, rotation, sbb);
        this.setBlockStateRotated(world, (class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)class_2350.field_11039), 1, y + 3, z, rotation, sbb);
        this.setBlockStateRotated(world, (class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)class_2350.field_11039), 1, y + 4, z, rotation, sbb);
        this.makeBuilderPlatform(world, rand, rotation, y + 5, z, true, sbb);
        if (y % 2 == 1) {
            int sx = this.pickFrom(rand, 5, 9, 13);
            int sz = sx == 9 ? (rand.nextBoolean() ? 5 : 13) : 9;
            class_2680 antibuilder = ((class_2248)TFBlocks.ANTIBUILDER.get()).method_9564();
            this.setBlockStateRotated(world, antibuilder, sx, y + 2, sz, rotation, sbb);
        } else {
            int sx = rand.nextBoolean() ? 5 : 13;
            int sz = rand.nextBoolean() ? 5 : 13;
            this.makeLampCluster(world, rand, sx, y, sz, rotation, sbb);
        }
    }

    private void addTopBuilderPlatform(class_5281 world, Random rand, int top, int spacing, class_3341 sbb) {
        class_2470 rotation = RotationUtil.ROTATIONS[(this.field_15315.method_35416() + top + 1) % 4];
        this.fillBlocksRotated(world, sbb, 5, top - spacing, 9, 7, top - spacing, 11, this.deco.accentState, rotation);
        this.fillBlocksRotated(world, sbb, 6, top - spacing, 9, 6, top, 9, this.deco.accentState, rotation);
        this.fillBlocksRotated(world, sbb, 6, top - spacing + 1, 10, 6, top - 1, 10, (class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)class_2350.field_11043), rotation);
        this.setBlockStateRotated(world, AIR, 6, top + 1, 9, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.fenceState, 5, top, 10, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.fenceState, 7, top, 10, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.fenceState, 5, top + 1, 10, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.fenceState, 7, top + 1, 10, rotation, sbb);
        class_2680 inactiveBuilder = ((class_2248)TFBlocks.CARMINITE_BUILDER.get()).method_9564();
        this.setBlockStateRotated(world, inactiveBuilder, 7, top - spacing, 10, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getLeverState(class_2246.field_10363.method_9564(), class_2738.field_12475, rand.nextBoolean() ? class_2350.field_11034 : class_2350.field_11043, false), 7, top - spacing + 1, 11, rotation, sbb);
    }

    private void makeBuilderPlatform(class_5281 world, Random rand, class_2470 rotation, int y, int z, boolean hole, class_3341 sbb) {
        this.setBlockStateRotated(world, this.deco.accentState, 1, y, z - 1, rotation, sbb);
        if (!hole) {
            this.setBlockStateRotated(world, this.deco.accentState, 1, y, z, rotation, sbb);
        }
        this.setBlockStateRotated(world, this.deco.accentState, 1, y, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, 2, y, z - 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, 2, y, z, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, 2, y, z + 1, rotation, sbb);
        class_2680 inactiveBuilder = ((class_2248)TFBlocks.CARMINITE_BUILDER.get()).method_9564();
        this.setBlockStateRotated(world, inactiveBuilder, 2, y, hole ? z + 1 : z - 1, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerMainComponent.getLeverState(class_2246.field_10363.method_9564(), class_2738.field_12475, rand.nextBoolean() ? class_2350.field_11034 : class_2350.field_11043, false), 2, y + 1, z, rotation, sbb);
    }

    private void makeLampCluster(class_5281 world, Random rand, int sx, int y, int sz, class_2470 rotation, class_3341 sbb) {
        int lz;
        int ly;
        int lx;
        int i;
        int radius = 4;
        block7: for (i = 0; i < 5; ++i) {
            lx = sx;
            ly = y;
            lz = sz;
            for (int move = 0; move < 10; ++move) {
                class_2350 facing;
                this.setBlockStateRotated(world, class_2246.field_10524.method_9564(), lx, ly, lz, rotation, sbb);
                int direction = rand.nextInt(8);
                if (direction > 5) {
                    direction -= 2;
                }
                if ((lx += (facing = class_2350.values()[direction]).method_10148()) > sx + radius || lx < sx - radius || (ly += facing.method_10164()) > y + radius || ly < y - radius || (lz += facing.method_10165()) > sz + radius || lz < sz - radius) continue block7;
            }
        }
        block9: for (i = 0; i < 5; ++i) {
            class_2350 direction;
            int move;
            lx = sx;
            ly = y;
            lz = sz;
            class_2350[] directions = new class_2350[10];
            for (move = 0; move < 10; ++move) {
                int direction2 = rand.nextInt(8);
                if (direction2 > 5) {
                    direction2 -= 2;
                }
                directions[move] = class_2350.values()[direction2];
            }
            for (move = 0; move < 10 && (lx += (direction = directions[move]).method_10148()) <= sx + radius && lx >= sx - radius && (ly += direction.method_10164()) <= y + radius && ly >= y - radius && (lz += direction.method_10165()) <= sz + radius && lz >= sz - radius; ++move) {
                class_2738 face;
                if (this.getBlockStateFromPosRotated(world, lx, ly, lz, sbb, rotation).method_26204() == class_2246.field_10524) continue;
                this.setBlockStateRotated(world, DarkTowerMainComponent.getLeverState(class_2246.field_10363.method_9564(), face, switch (direction) {
                    case class_2350.field_11043 -> {
                        face = class_2738.field_12471;
                        yield class_2350.field_11035;
                    }
                    case class_2350.field_11035 -> {
                        face = class_2738.field_12471;
                        yield class_2350.field_11043;
                    }
                    case class_2350.field_11034 -> {
                        face = class_2738.field_12471;
                        yield class_2350.field_11039;
                    }
                    case class_2350.field_11039 -> {
                        face = class_2738.field_12471;
                        yield class_2350.field_11034;
                    }
                    case class_2350.field_11036 -> {
                        face = class_2738.field_12475;
                        yield class_2350.field_11034;
                    }
                    default -> {
                        face = class_2738.field_12473;
                        yield class_2350.field_11043;
                    }
                }, false), lx, ly, lz, rotation, sbb);
                continue block9;
            }
        }
    }
}

