/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.darktower;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2312;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_2399;
import net.minecraft.class_2401;
import net.minecraft.class_2462;
import net.minecraft.class_2465;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import twilightforest.block.TFBlocks;
import twilightforest.entity.TFEntities;
import twilightforest.loot.TFTreasure;
import twilightforest.util.RotationUtil;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.TFStructureDecorator;
import twilightforest.world.components.structures.darktower.DarkTowerBalconyComponent;
import twilightforest.world.components.structures.darktower.DarkTowerBeardComponent;
import twilightforest.world.components.structures.darktower.DarkTowerBridgeComponent;
import twilightforest.world.components.structures.darktower.DarkTowerPieces;
import twilightforest.world.components.structures.darktower.DarkTowerRoofAntennaComponent;
import twilightforest.world.components.structures.darktower.DarkTowerRoofCactusComponent;
import twilightforest.world.components.structures.darktower.DarkTowerRoofComponent;
import twilightforest.world.components.structures.darktower.DarkTowerRoofFourPostComponent;
import twilightforest.world.components.structures.darktower.DarkTowerRoofRingsComponent;
import twilightforest.world.components.structures.darktower.EnumDarkTowerDoor;
import twilightforest.world.components.structures.darktower.StructureDecoratorDarkTower;
import twilightforest.world.components.structures.lichtower.TowerRoofAttachedSlabComponent;
import twilightforest.world.components.structures.lichtower.TowerRoofComponent;
import twilightforest.world.components.structures.lichtower.TowerRoofFenceComponent;
import twilightforest.world.components.structures.lichtower.TowerRoofGableForwardsComponent;
import twilightforest.world.components.structures.lichtower.TowerRoofSlabForwardsComponent;
import twilightforest.world.components.structures.lichtower.TowerWingComponent;
import twilightforest.world.registration.TFFeature;

public class DarkTowerWingComponent
extends TowerWingComponent {
    protected boolean keyTower = false;
    protected ArrayList<EnumDarkTowerDoor> openingTypes = new ArrayList();

    public DarkTowerWingComponent(class_6625 ctx, class_2487 nbt) {
        this(DarkTowerPieces.TFDTWin, nbt);
    }

    public DarkTowerWingComponent(class_3773 piece, class_2487 nbt) {
        super(piece, nbt);
        this.keyTower = nbt.method_10577("keyTower");
        this.readDoorsTypesFromArray(nbt.method_10561("doorTypeInts"));
    }

    protected DarkTowerWingComponent(class_3773 piece, TFFeature feature, int i, int x, int y, int z, int pSize, int pHeight, class_2350 direction) {
        super(piece, feature, i, x, y, z, pSize, pHeight, direction);
    }

    private int[] getDoorsTypesAsIntArray() {
        int[] ret = new int[this.openingTypes.size()];
        int idx = 0;
        for (EnumDarkTowerDoor doorType : this.openingTypes) {
            ret[idx++] = doorType.ordinal();
        }
        return ret;
    }

    @Override
    protected void method_14943(class_6625 ctx, class_2487 tagCompound) {
        super.method_14943(ctx, tagCompound);
        tagCompound.method_10556("keyTower", this.keyTower);
        tagCompound.method_10539("doorTypeInts", this.getDoorsTypesAsIntArray());
    }

    private void readDoorsTypesFromArray(int[] intArray) {
        for (int typeInt : intArray) {
            this.openingTypes.add(EnumDarkTowerDoor.values()[typeInt]);
        }
    }

    @Override
    public void method_14918(class_3443 parent, class_6130 list, Random rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        this.addOpening(0, 1, this.size / 2, class_2470.field_11464);
        this.makeARoof(parent, list, rand);
        this.makeABeard(parent, list, rand);
        if (this.size > 10) {
            for (class_2470 direction : RotationUtil.ROTATIONS) {
                int[] dest = this.getValidOpening(rand, direction);
                int childHeight = this.validateChildHeight(this.height - 4 + rand.nextInt(10) - rand.nextInt(10));
                boolean madeWing = this.makeTowerWing(list, rand, this.method_14923(), dest[0], dest[1], dest[2], this.size - 2, childHeight, direction);
                if (madeWing || direction != class_2470.field_11464 && !rand.nextBoolean()) continue;
                this.makeTowerBalcony(list, rand, this.method_14923(), dest[0], dest[1], dest[2], direction);
            }
        } else if (rand.nextInt(4) == 0) {
            class_2470 direction = RotationUtil.ROTATIONS[rand.nextInt(4)];
            int[] dest = this.getValidOpening(rand, direction);
            this.makeTowerBalcony(list, rand, this.method_14923(), dest[0], dest[1], dest[2], direction);
        }
    }

    protected int validateChildHeight(int childHeight) {
        return childHeight / 4 * 4 + 1;
    }

    @Override
    public void makeARoof(class_3443 parent, class_6130 list, Random rand) {
        int index = this.method_14923();
        DarkTowerRoofComponent roof = switch (rand.nextInt(5)) {
            case 2 -> new DarkTowerRoofCactusComponent(this.getFeatureType(), index, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260());
            case 3 -> new DarkTowerRoofRingsComponent(this.getFeatureType(), index, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260());
            case 4 -> new DarkTowerRoofFourPostComponent(this.getFeatureType(), index, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260());
            default -> new DarkTowerRoofAntennaComponent(this.getFeatureType(), index, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260());
        };
        list.method_35462((class_3443)roof);
        roof.method_14918(this, list, rand);
        this.roofType = roof.getClass();
    }

    @Override
    protected void makeAttachedRoof(class_6130 list, Random rand) {
        TowerRoofComponent roof;
        int index = this.method_14923();
        if (this.roofType == null && rand.nextInt(32) != 0) {
            this.tryToFitRoof(list, rand, new TowerRoofGableForwardsComponent(this.getFeatureType(), index + 1, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260()));
        }
        if (this.roofType == null && rand.nextInt(8) != 0) {
            this.tryToFitRoof(list, rand, new TowerRoofSlabForwardsComponent(this.getFeatureType(), index + 1, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260()));
        }
        if (this.roofType == null && rand.nextInt(32) != 0) {
            roof = new TowerRoofAttachedSlabComponent(this.getFeatureType(), index + 1, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260());
            this.tryToFitRoof(list, rand, roof);
        }
        if (this.roofType == null) {
            roof = new TowerRoofFenceComponent(this.getFeatureType(), index + 1, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260());
            this.tryToFitRoof(list, rand, roof);
        }
    }

    @Override
    public void makeABeard(class_3443 parent, class_6130 list, Random rand) {
        DarkTowerBeardComponent beard = new DarkTowerBeardComponent(this.getFeatureType(), this.method_14923() + 1, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260());
        list.method_35462((class_3443)beard);
        beard.method_14918(this, list, rand);
    }

    @Override
    public boolean makeTowerWing(class_6130 list, Random rand, int index, int x, int y, int z, int wingSize, int wingHeight, class_2470 rotation) {
        if (wingHeight < 8) {
            return false;
        }
        class_2350 direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, 5, direction);
        if (dx[1] + wingHeight > 250) {
            return false;
        }
        DarkTowerBridgeComponent bridge = new DarkTowerBridgeComponent(DarkTowerPieces.TFDTBri, this.getFeatureType(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        class_3443 intersect = list.method_35461(bridge.method_14935());
        if (intersect != null && intersect != this) {
            return false;
        }
        intersect = list.method_35461(bridge.getWingBB());
        if (intersect == null || intersect == this) {
            list.method_35462((class_3443)bridge);
            bridge.method_14918(this, list, rand);
            this.addOpening(x, y, z, rotation);
            return true;
        }
        return false;
    }

    protected boolean makeTowerBalcony(class_6130 list, Random rand, int index, int x, int y, int z, class_2470 rotation) {
        class_2350 direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, 5, direction);
        DarkTowerBalconyComponent balcony = new DarkTowerBalconyComponent(this.getFeatureType(), index, dx[0], dx[1], dx[2], direction);
        class_3443 intersect = list.method_35461(balcony.method_14935());
        if (intersect == null || intersect == this) {
            list.method_35462((class_3443)balcony);
            balcony.method_14918(this, list, rand);
            this.addOpening(x, y, z, rotation, EnumDarkTowerDoor.REAPPEARING);
            return true;
        }
        return false;
    }

    @Override
    public void method_14931(class_5281 world, class_5138 manager, class_2794 generator, Random rand, class_3341 sbb, class_1923 chunkPosIn, class_2338 blockPos) {
        Random decoRNG = new Random(world.method_8412() + (long)this.field_15315.method_35415() * 321534781L ^ (long)this.field_15315.method_35417() * 756839L);
        this.makeEncasedWalls(world, rand, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1);
        this.method_14942(world, sbb, 1, 1, 1, this.size - 2, this.height - 2, this.size - 2);
        if (this.size > 9) {
            this.addHalfFloors(world, decoRNG, sbb, 4, this.height - 1);
        } else if (decoRNG.nextInt(3) == 0) {
            this.addSmallTimberBeams(world, decoRNG, sbb, 4, this.height - 1);
        } else {
            this.addHalfFloors(world, decoRNG, sbb, 4, this.height - 1);
        }
        this.makeOpenings(world, sbb);
        if (decoRNG.nextBoolean() && !this.isKeyTower() && this.height > 8) {
            int blobs = 1;
            if (this.size > 9 && decoRNG.nextBoolean()) {
                ++blobs;
            }
            for (int i = 0; i < blobs; ++i) {
                int x = decoRNG.nextInt(this.size);
                int y = decoRNG.nextInt(this.height - 7) + 2;
                int z = decoRNG.nextInt(this.size);
                this.destroyTower(world, decoRNG, x, y, z, 3, sbb);
            }
        }
    }

    protected void destroyTower(class_5281 world, Random decoRNG, int x, int y, int z, int amount, class_3341 sbb) {
        int initialRadius = decoRNG.nextInt(amount) + amount;
        this.drawBlob(world, x, y, z, initialRadius, AIR, sbb);
        for (int i = 0; i < 3; ++i) {
            int dx = x + (initialRadius - 1) * (decoRNG.nextBoolean() ? 1 : -1);
            int dy = y + (initialRadius - 1) * (decoRNG.nextBoolean() ? 1 : -1);
            int dz = z + (initialRadius - 1) * (decoRNG.nextBoolean() ? 1 : -1);
            this.netherTransformBlob(world, decoRNG, dx, dy, dz, initialRadius - 1, sbb);
            this.drawBlob(world, dx, dy, dz, initialRadius - 2, AIR, sbb);
        }
    }

    private void netherTransformBlob(class_5281 world, Random inRand, int sx, int sy, int sz, int rad, class_3341 sbb) {
        Random rand = new Random(inRand.nextLong());
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dy = 0; dy <= rad; dy = (int)((byte)(dy + 1))) {
                for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                    byte dist = dx >= dy && dx >= dz ? (byte)(dx + (byte)((double)Math.max(dy, dz) * 0.5 + (double)Math.min(dy, dz) * 0.25)) : (dy >= dx && dy >= dz ? (byte)(dy + (byte)((double)Math.max(dx, dz) * 0.5 + (double)Math.min(dx, dz) * 0.25)) : (byte)(dz + (byte)((double)Math.max(dx, dy) * 0.5 + (double)Math.min(dx, dy) * 0.25)));
                    if (dist > rad) continue;
                    this.testAndChangeToNetherrack(world, rand, sx + dx, sy + dy, sz + dz, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx + dx, sy + dy, sz + dz, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx + dx, sy + dy, sz - dz, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx - dx, sy + dy, sz + dz, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx - dx, sy + dy, sz - dz, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx + dx, sy - dy, sz + dz, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx + dx, sy - dy, sz - dz, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx - dx, sy - dy, sz + dz, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx - dx, sy - dy, sz - dz, sbb);
                }
            }
        }
    }

    private void testAndChangeToNetherrack(class_5281 world, Random rand, int x, int y, int z, class_3341 sbb) {
        if (this.method_14929((class_1922)world, x, y, z, sbb).method_26204() != class_2246.field_10124) {
            this.method_14917(world, class_2246.field_10515.method_9564(), x, y, z, sbb);
            if (this.method_14929((class_1922)world, x, y + 1, z, sbb).method_26204() == class_2246.field_10124 && rand.nextBoolean()) {
                this.method_14917(world, class_2246.field_10036.method_9564(), x, y + 1, z, sbb);
            }
        }
    }

    private void drawBlob(class_5281 world, int sx, int sy, int sz, int rad, class_2680 state, class_3341 sbb) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dy = 0; dy <= rad; dy = (int)((byte)(dy + 1))) {
                for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                    byte dist = dx >= dy && dx >= dz ? (byte)(dx + (byte)((double)Math.max(dy, dz) * 0.5 + (double)Math.min(dy, dz) * 0.25)) : (dy >= dx && dy >= dz ? (byte)(dy + (byte)((double)Math.max(dx, dz) * 0.5 + (double)Math.min(dx, dz) * 0.25)) : (byte)(dz + (byte)((double)Math.max(dx, dy) * 0.5 + (double)Math.min(dx, dy) * 0.25)));
                    if (dist > rad) continue;
                    this.method_14917(world, state, sx + dx, sy + dy, sz + dz, sbb);
                    this.method_14917(world, state, sx + dx, sy + dy, sz - dz, sbb);
                    this.method_14917(world, state, sx - dx, sy + dy, sz + dz, sbb);
                    this.method_14917(world, state, sx - dx, sy + dy, sz - dz, sbb);
                    this.method_14917(world, state, sx + dx, sy - dy, sz + dz, sbb);
                    this.method_14917(world, state, sx + dx, sy - dy, sz - dz, sbb);
                    this.method_14917(world, state, sx - dx, sy - dy, sz + dz, sbb);
                    this.method_14917(world, state, sx - dx, sy - dy, sz - dz, sbb);
                }
            }
        }
    }

    private void addHalfFloors(class_5281 world, Random rand, class_3341 sbb, int bottom, int top) {
        int spacing = 4;
        class_2470 rotation = RotationUtil.ROTATIONS[(this.field_15315.method_35416() + bottom) % 3];
        if (bottom == 0) {
            bottom += spacing;
        }
        for (int y = bottom; y < top; y += spacing) {
            rotation = rotation.method_10501(class_2470.field_11464);
            if (y >= top - spacing) {
                this.makeFullFloor(world, sbb, y);
                if (this.isDeadEnd()) {
                    this.decorateTreasureRoom(world, sbb, rotation, y, 4, this.deco);
                }
            } else {
                this.makeHalfFloor(world, sbb, rotation, y);
                switch (rand.nextInt(8)) {
                    case 0: {
                        if (this.size < 11) {
                            this.decorateReappearingFloor(world, sbb, rotation, y);
                            break;
                        }
                    }
                    case 1: {
                        this.decorateSpawner(world, rand, sbb, rotation, y);
                        break;
                    }
                    case 2: {
                        this.decorateLounge(world, sbb, rotation, y);
                        break;
                    }
                    case 3: {
                        this.decorateLibrary(world, sbb, rotation, y);
                        break;
                    }
                    case 4: {
                        this.decorateExperimentPulser(world, sbb, rotation, y);
                        break;
                    }
                    case 5: {
                        this.decorateExperimentLamp(world, sbb, rotation, y);
                        break;
                    }
                    case 6: {
                        this.decoratePuzzleChest(world, sbb, rotation, y);
                    }
                }
            }
            this.addStairsDown(world, sbb, rotation, y, this.size - 2, spacing);
            if (this.size <= 9) continue;
            this.addStairsDown(world, sbb, rotation, y, this.size - 3, spacing);
        }
        rotation = rotation.method_10501(class_2470.field_11464);
        this.addStairsDown(world, sbb, rotation, this.height - 1, this.size - 2, spacing);
    }

    protected void makeHalfFloor(class_5281 world, class_3341 sbb, class_2470 rotation, int y) {
        this.fillBlocksRotated(world, sbb, this.size / 2, y, 1, this.size - 2, y, this.size - 2, this.deco.blockState, rotation);
        this.fillBlocksRotated(world, sbb, this.size / 2 - 1, y, 1, this.size / 2 - 1, y, this.size - 2, this.deco.accentState, rotation);
    }

    protected void makeFullFloor(class_5281 world, class_3341 sbb, int y) {
        this.method_14940(world, sbb, 1, y, 1, this.size - 2, y, this.size - 2, this.deco.blockState, class_2246.field_10124.method_9564(), false);
        this.method_14940(world, sbb, this.size / 2, y, 1, this.size / 2, y, this.size - 2, this.deco.accentState, class_2246.field_10124.method_9564(), true);
    }

    protected void decorateTreasureRoom(class_5281 world, class_3341 sbb, class_2470 rotation, int y, int spacing, TFStructureDecorator myDeco) {
        int x = this.size / 2;
        int z = this.size / 2;
        this.makePillarFrame(world, sbb, this.deco, rotation, x - 1, y, z - 1, true);
        this.setBlockStateRotated(world, myDeco.platformState, x, y + 1, z, rotation, sbb);
        this.placeTreasureAtCurrentPosition(world, x, y + 2, z, this.isKeyTower() ? TFTreasure.DARKTOWER_KEY : TFTreasure.DARKTOWER_CACHE, sbb);
    }

    private void decorateSpawner(class_5281 world, Random rand, class_3341 sbb, class_2470 rotation, int y) {
        int z;
        int x = this.size > 9 ? 4 : 3;
        int n = z = this.size > 9 ? 5 : 4;
        class_1299 mobID = this.size > 9 ? (rand.nextBoolean() ? (class_1299)TFEntities.CARMINITE_GOLEM.get() : (class_1299)TFEntities.CARMINITE_BROODLING.get()) : (class_1299)TFEntities.CARMINITE_BROODLING.get();
        this.makePillarFrame(world, sbb, this.deco, rotation, x, y, z, true);
        this.setSpawnerRotated(world, x + 1, y + 2, z + 1, rotation, mobID, sbb);
    }

    private void decorateLounge(class_5281 world, class_3341 sbb, class_2470 rotation, int y) {
        int cx = this.size > 9 ? 9 : 7;
        int cz = this.size > 9 ? 4 : 3;
        this.setBlockStateRotated(world, DarkTowerWingComponent.getStairState(this.deco.stairState, class_2350.field_11035, false), cx, y + 1, cz, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerWingComponent.getStairState(this.deco.stairState, class_2350.field_11039, false), cx, y + 1, cz + 1, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerWingComponent.getStairState(this.deco.stairState, class_2350.field_11043, false), cx, y + 1, cz + 2, rotation, sbb);
        cx = this.size > 9 ? 5 : 3;
        this.setBlockStateRotated(world, DarkTowerWingComponent.getStairState(this.deco.stairState, class_2350.field_11035, true), cx, y + 1, cz, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerWingComponent.getSlabState(class_2246.field_10071.method_9564(), class_2771.field_12679), cx, y + 1, cz + 1, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerWingComponent.getStairState(this.deco.stairState, class_2350.field_11043, true), cx, y + 1, cz + 2, rotation, sbb);
    }

    private void decorateReappearingFloor(class_5281 world, class_3341 sbb, class_2470 rotation, int y) {
        class_2680 inactiveReappearing = ((class_2248)TFBlocks.REAPPEARING_BLOCK.get()).method_9564();
        class_2680 woodenPressurePlate = class_2246.field_10484.method_9564();
        this.fillBlocksRotated(world, sbb, 4, y, 3, 7, y, 5, inactiveReappearing, rotation);
        this.fillBlocksRotated(world, sbb, 4, y + 1, 2, 7, y + 1, 2, woodenPressurePlate, rotation);
        this.fillBlocksRotated(world, sbb, 4, y + 1, 6, 7, y + 1, 6, woodenPressurePlate, rotation);
    }

    private void decorateExperimentLamp(class_5281 world, class_3341 sbb, class_2470 rotation, int y) {
        int cx = this.size > 9 ? 5 : 3;
        int cz = this.size > 9 ? 5 : 4;
        class_2680 redstoneLamp = class_2246.field_10524.method_9564();
        this.setBlockStateRotated(world, (class_2680)class_2246.field_10615.method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)class_2350.field_11036), cx, y + 1, cz, rotation, sbb);
        this.setBlockStateRotated(world, redstoneLamp, cx, y + 2, cz, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, cx, y + 1, cz + 1, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerWingComponent.getLeverState(class_2246.field_10363.method_9564(), class_2738.field_12471, class_2350.field_11043, false), cx, y + 1, cz + 2, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, cx, y + 3, cz - 1, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerWingComponent.getLeverState(class_2246.field_10363.method_9564(), class_2738.field_12471, class_2350.field_11035, true), cx, y + 3, cz - 2, rotation, sbb);
    }

    protected static class_2680 getLeverState(class_2680 initialState, class_2738 face, class_2350 direction, boolean isPowered) {
        switch (direction) {
            case field_11043: 
            case field_11035: 
            case field_11034: 
            case field_11039: {
                break;
            }
            default: {
                direction = class_2350.field_11043;
            }
        }
        return (class_2680)((class_2680)((class_2680)initialState.method_11657((class_2769)class_2383.field_11177, (Comparable)direction)).method_11657((class_2769)class_2341.field_11007, (Comparable)face)).method_11657((class_2769)class_2401.field_11265, (Comparable)Boolean.valueOf(isPowered));
    }

    private void decorateExperimentPulser(class_5281 world, class_3341 sbb, class_2470 rotation, int y) {
        int cx = this.size > 9 ? 6 : 5;
        int cz = this.size > 9 ? 4 : 3;
        class_2680 redstoneWire = class_2246.field_10091.method_9564();
        class_2680 woodenPressurePlate = class_2246.field_10484.method_9564();
        class_2680 stickyPiston = (class_2680)class_2246.field_10615.method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)class_2350.field_11035);
        class_2680 unpoweredRepeater = (class_2680)((class_2680)((class_2680)class_2246.field_10450.method_9564().method_11657((class_2769)class_2312.field_10911, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2383.field_11177, (Comparable)class_2350.field_11039)).method_11657((class_2769)class_2462.field_11451, (Comparable)Integer.valueOf(2));
        this.setBlockStateRotated(world, stickyPiston, cx, y + 1, cz + 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, cx, y + 1, cz, rotation, sbb);
        this.setBlockStateRotated(world, redstoneWire, cx + 1, y + 1, cz, rotation, sbb);
        this.setBlockStateRotated(world, woodenPressurePlate, cx + 2, y + 1, cz, rotation, sbb);
        this.setBlockStateRotated(world, unpoweredRepeater, cx - 1, y + 1, cz, rotation, sbb);
        this.setBlockStateRotated(world, redstoneWire, cx - 2, y + 1, cz, rotation, sbb);
        this.setBlockStateRotated(world, redstoneWire, cx - 2, y + 1, cz + 1, rotation, sbb);
        this.setBlockStateRotated(world, redstoneWire, cx - 1, y + 1, cz + 1, rotation, sbb);
    }

    private void decorateLibrary(class_5281 world, class_3341 sbb, class_2470 rotation, int y) {
        int bx = this.size > 9 ? 4 : 3;
        int bz = this.size > 9 ? 3 : 2;
        this.makeSmallBookshelf(world, sbb, rotation, y, bx, bz);
        bx = this.size > 9 ? 9 : 7;
        bz = this.size > 9 ? 3 : 2;
        this.makeSmallBookshelf(world, sbb, rotation, y, bx, bz);
    }

    protected void makeSmallBookshelf(class_5281 world, class_3341 sbb, class_2470 rotation, int y, int bx, int bz) {
        this.setBlockStateRotated(world, DarkTowerWingComponent.getStairState(this.deco.stairState, class_2350.field_11043, false), bx, y + 1, bz, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerWingComponent.getStairState(this.deco.stairState, class_2350.field_11043, true), bx, y + 2, bz, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerWingComponent.getStairState(this.deco.stairState, class_2350.field_11035, false), bx, y + 1, bz + 3, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerWingComponent.getStairState(this.deco.stairState, class_2350.field_11035, true), bx, y + 2, bz + 3, rotation, sbb);
        class_2680 bookshelf = class_2246.field_10504.method_9564();
        this.setBlockStateRotated(world, bookshelf, bx, y + 1, bz + 1, rotation, sbb);
        this.setBlockStateRotated(world, bookshelf, bx, y + 2, bz + 1, rotation, sbb);
        this.setBlockStateRotated(world, bookshelf, bx, y + 1, bz + 2, rotation, sbb);
        this.setBlockStateRotated(world, bookshelf, bx, y + 2, bz + 2, rotation, sbb);
    }

    private void decoratePuzzleChest(class_5281 world, class_3341 sbb, class_2470 rotation, int y) {
        int x = this.size > 9 ? 4 : 3;
        int z = this.size > 9 ? 5 : 4;
        this.makePillarFrame(world, sbb, this.deco, rotation, x, y, z, true);
        this.setBlockStateRotated(world, this.deco.platformState, x + 1, y + 1, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.blockState, x + 2, y + 1, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.blockState, x, y + 1, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.blockState, x + 1, y + 1, z + 2, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.blockState, x + 1, y + 1, z, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.blockState, x + 2, y + 3, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.blockState, x, y + 3, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.blockState, x + 1, y + 3, z + 2, rotation, sbb);
        this.setBlockStateRotated(world, AIR, x + 1, y + 3, z, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.blockState, x + 1, y + 3, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, (class_2680)class_2246.field_10615.method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)class_2350.field_11043), x + 1, y + 3, z - 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, x + 1, y + 3, z - 2, rotation, sbb);
        this.setBlockStateRotated(world, DarkTowerWingComponent.getLeverState(class_2246.field_10363.method_9564(), class_2738.field_12471, class_2350.field_11039, false), x + 2, y + 3, z - 2, rotation, sbb);
        this.placeTreasureRotated(world, x + 1, y + 2, z + 1, this.method_14934(), rotation, TFTreasure.DARKTOWER_CACHE, sbb);
    }

    protected void makePillarFrame(class_5281 world, class_3341 sbb, TFStructureDecorator myDeco, class_2470 rotation, int x, int y, int z, boolean fenced) {
        this.makePillarFrame(world, sbb, myDeco, rotation, x, y, z, 3, 3, 3, fenced);
    }

    protected void makePillarFrame(class_5281 world, class_3341 sbb, TFStructureDecorator myDeco, class_2470 rotation, int x, int y, int z, int width, int height, int length, boolean fenced) {
        for (int dx = 0; dx < width; ++dx) {
            for (int dz = 0; dz < length; ++dz) {
                if (!(dx % 3 != 0 && dx != width - 1 || dz % 3 != 0 && dz != length - 1)) {
                    for (int py = 1; py <= height; ++py) {
                        this.setBlockStateRotated(world, myDeco.pillarState, x + dx, y + py, z + dz, rotation, sbb);
                    }
                    continue;
                }
                if (dx == 0) {
                    class_2680 southStairs = DarkTowerWingComponent.getStairState(this.deco.stairState, class_2350.field_11039, false);
                    this.setBlockStateRotated(world, southStairs, x + dx, y + 1, z + dz, rotation, sbb);
                    this.setBlockStateRotated(world, (class_2680)southStairs.method_11657((class_2769)class_2510.field_11572, (Comparable)class_2760.field_12619), x + dx, y + height, z + dz, rotation, sbb);
                } else if (dx == width - 1) {
                    class_2680 northStairs = DarkTowerWingComponent.getStairState(this.deco.stairState, class_2350.field_11034, false);
                    this.setBlockStateRotated(world, northStairs, x + dx, y + 1, z + dz, rotation, sbb);
                    this.setBlockStateRotated(world, (class_2680)northStairs.method_11657((class_2769)class_2510.field_11572, (Comparable)class_2760.field_12619), x + dx, y + height, z + dz, rotation, sbb);
                } else if (dz == 0) {
                    class_2680 westStairs = DarkTowerWingComponent.getStairState(this.deco.stairState, class_2350.field_11043, false);
                    this.setBlockStateRotated(world, westStairs, x + dx, y + 1, z + dz, rotation, sbb);
                    this.setBlockStateRotated(world, (class_2680)westStairs.method_11657((class_2769)class_2510.field_11572, (Comparable)class_2760.field_12619), x + dx, y + height, z + dz, rotation, sbb);
                } else if (dz == length - 1) {
                    class_2680 eastStairs = DarkTowerWingComponent.getStairState(this.deco.stairState, class_2350.field_11035, false);
                    this.setBlockStateRotated(world, eastStairs, x + dx, y + 1, z + dz, rotation, sbb);
                    this.setBlockStateRotated(world, (class_2680)eastStairs.method_11657((class_2769)class_2510.field_11572, (Comparable)class_2760.field_12619), x + dx, y + height, z + dz, rotation, sbb);
                }
                if (!fenced || dx != 0 && dx != width - 1 && dz != 0 && dz != length - 1) continue;
                for (int fy = 2; fy <= height - 1; ++fy) {
                    this.setBlockStateRotated(world, myDeco.fenceState, x + dx, y + fy, z + dz, rotation, sbb);
                }
            }
        }
    }

    protected void addStairsDown(class_5281 world, class_3341 sbb, class_2470 rotation, int y, int sz, int spacing) {
        for (int i = 0; i < spacing; ++i) {
            int sx = this.size - 3 - i;
            this.setBlockStateRotated(world, DarkTowerWingComponent.getStairState(this.deco.stairState, class_2350.field_11039, false), sx, y - i, sz, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.accentState, sx, y - 1 - i, sz, rotation, sbb);
            this.setBlockStateRotated(world, AIR, sx, y + 1 - i, sz, rotation, sbb);
            this.setBlockStateRotated(world, AIR, sx, y + 2 - i, sz, rotation, sbb);
            this.setBlockStateRotated(world, AIR, sx - 1, y + 2 - i, sz, rotation, sbb);
            this.setBlockStateRotated(world, AIR, sx, y + 3 - i, sz, rotation, sbb);
            this.setBlockStateRotated(world, AIR, sx - 1, y + 3 - i, sz, rotation, sbb);
        }
    }

    protected void addSmallTimberBeams(class_5281 world, Random rand, class_3341 sbb, int bottom, int top) {
        int spacing = 4;
        class_2470 rotation = class_2470.field_11467;
        if (bottom == 0) {
            bottom += spacing;
        }
        for (int y = bottom; y < top; y += spacing) {
            rotation = rotation.method_10501(class_2470.field_11463);
            if (y >= top - spacing && this.isDeadEnd()) {
                this.makeTimberFloor(world, sbb, rotation, y);
                StructureDecoratorDarkTower logDeco = new StructureDecoratorDarkTower();
                logDeco.pillarState = ((class_2465)TFBlocks.DARK_LOG.get()).method_9564();
                logDeco.platformState = ((class_2465)TFBlocks.DARK_LOG.get()).method_9564();
                this.decorateTreasureRoom(world, sbb, rotation, y, 4, logDeco);
                continue;
            }
            this.makeSmallTimberBeams(world, rand, sbb, rotation, y, y == bottom && bottom != spacing);
        }
    }

    protected void makeTimberFloor(class_5281 world, class_3341 sbb, class_2470 rotation, int y) {
        class_2680 beamID = ((class_2465)TFBlocks.DARK_LOG.get()).method_9564();
        class_2680 beamStateNS = (class_2680)beamID.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11051);
        class_2680 beamStateUD = (class_2680)beamID.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11052);
        class_2680 beamStateEW = (class_2680)beamID.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11048);
        for (int z = 1; z < this.size - 1; ++z) {
            for (int x = 1; x < this.size - 1; ++x) {
                if (x < z) {
                    this.setBlockStateRotated(world, beamStateNS, x, y, z, rotation, sbb);
                    continue;
                }
                this.setBlockStateRotated(world, beamStateEW, x, y, z, rotation, sbb);
            }
        }
        for (int by = 1; by < 4; ++by) {
            class_2680 ladder = class_2246.field_9983.method_9564();
            this.setBlockStateRotated(world, beamStateUD, 2, y - by, 2, rotation, sbb);
            this.setBlockStateRotated(world, (class_2680)ladder.method_11657((class_2769)class_2399.field_11253, (Comparable)class_2350.field_11039), 3, y - by, 2, rotation, sbb);
            this.setBlockStateRotated(world, beamStateUD, 6, y - by, 6, rotation, sbb);
            this.setBlockStateRotated(world, (class_2680)ladder.method_11657((class_2769)class_2399.field_11253, (Comparable)class_2350.field_11034), 5, y - by, 6, rotation, sbb);
        }
        this.setBlockStateRotated(world, AIR, 3, y, 2, rotation, sbb);
        this.setBlockStateRotated(world, AIR, 5, y, 6, rotation, sbb);
    }

    protected void makeSmallTimberBeams(class_5281 world, Random rand, class_3341 sbb, class_2470 rotation, int y, boolean bottom) {
        int z;
        class_2680 beamID = ((class_2465)TFBlocks.DARK_LOG.get()).method_9564();
        class_2680 beamStateNS = (class_2680)beamID.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11048);
        class_2680 beamStateUD = (class_2680)beamID.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11052);
        class_2680 beamStateEW = (class_2680)beamID.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11051);
        for (z = 1; z < this.size - 1; ++z) {
            this.setBlockStateRotated(world, beamStateEW, 2, y, z, rotation, sbb);
            this.setBlockStateRotated(world, beamStateEW, 6, y, z, rotation, sbb);
        }
        z = this.pickBetweenExcluding(3, this.size - 3, rand, 2, 2, 6);
        for (int x = 3; x < 6; ++x) {
            this.setBlockStateRotated(world, beamStateNS, x, y, z, rotation, sbb);
        }
        int x1 = 2;
        int z1 = rand.nextBoolean() ? 2 : 6;
        int x3 = 6;
        int z3 = rand.nextBoolean() ? 2 : 6;
        for (int by = 1; by < 4; ++by) {
            class_2680 ladder = class_2246.field_9983.method_9564();
            if (!bottom || this.checkPost(world, x1, y - 4, z1, rotation, sbb)) {
                this.setBlockStateRotated(world, beamStateUD, x1, y - by, z1, rotation, sbb);
                this.setBlockStateRotated(world, (class_2680)ladder.method_11657((class_2769)class_2399.field_11253, (Comparable)class_2350.field_11039), x1 + 1, y - by, z1, rotation, sbb);
            }
            if (bottom && !this.checkPost(world, x3, y - 4, z3, rotation, sbb)) continue;
            this.setBlockStateRotated(world, beamStateUD, x3, y - by, z3, rotation, sbb);
            this.setBlockStateRotated(world, (class_2680)ladder.method_11657((class_2769)class_2399.field_11253, (Comparable)class_2350.field_11034), x3 - 1, y - by, z3, rotation, sbb);
        }
    }

    protected int pickBetweenExcluding(int low, int high, Random rand, int k, int l, int m) {
        int result;
        while ((result = rand.nextInt(high - low) + low) == k || result == l || result == m) {
        }
        return result;
    }

    protected int pickFrom(Random rand, int i, int j, int k) {
        return switch (rand.nextInt(3)) {
            case 1 -> j;
            case 2 -> k;
            default -> i;
        };
    }

    protected boolean checkPost(class_5281 world, int x, int y, int z, class_2470 rotation, class_3341 sbb) {
        int worldZ;
        int worldY;
        int worldX = this.getXWithOffsetRotated(x, z, rotation);
        class_2338 vec = new class_2338(worldX, worldY = this.method_14924(y), worldZ = this.getZWithOffsetRotated(x, z, rotation));
        if (!sbb.method_14662((class_2382)vec)) {
            return false;
        }
        class_2680 blockState = world.method_8320(vec);
        return blockState.method_26204() != class_2246.field_10124 && blockState != this.deco.accentState;
    }

    protected void makeEncasedWalls(class_5281 world, Random rand, class_3341 sbb, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (x != minX && x != maxX && y != minY && y != maxY && z != minZ && z != maxZ) continue;
                    if (!((y != minY && y != maxY || x != minY && x != maxX && z != minZ && z != maxZ) && (z != minZ && z != maxZ || x != minY && x != maxX && y != minY && y != maxY))) {
                        this.method_14917(world, this.deco.accentState, x, y, z, sbb);
                        continue;
                    }
                    class_3443.class_3444 blocker = this.deco.randomBlocks;
                    blocker.method_14948(rand, x, y, z, true);
                    this.method_14917(world, blocker.method_14947(), x, y, z, sbb);
                }
            }
        }
        this.method_14917(world, this.deco.accentState, minX + 1, minY + 1, minZ, sbb);
        this.method_14917(world, this.deco.accentState, minX + 1, minY + 1, maxZ, sbb);
        this.method_14917(world, this.deco.accentState, maxX - 1, minY + 1, minZ, sbb);
        this.method_14917(world, this.deco.accentState, maxX - 1, minY + 1, maxZ, sbb);
        this.method_14917(world, this.deco.accentState, minX + 1, maxY - 1, minZ, sbb);
        this.method_14917(world, this.deco.accentState, minX + 1, maxY - 1, maxZ, sbb);
        this.method_14917(world, this.deco.accentState, maxX - 1, maxY - 1, minZ, sbb);
        this.method_14917(world, this.deco.accentState, maxX - 1, maxY - 1, maxZ, sbb);
        this.method_14917(world, this.deco.accentState, minX, minY + 1, minZ + 1, sbb);
        this.method_14917(world, this.deco.accentState, minX, minY + 1, maxZ - 1, sbb);
        this.method_14917(world, this.deco.accentState, maxX, minY + 1, minZ + 1, sbb);
        this.method_14917(world, this.deco.accentState, maxX, minY + 1, maxZ - 1, sbb);
        this.method_14917(world, this.deco.accentState, minX, maxY - 1, minZ + 1, sbb);
        this.method_14917(world, this.deco.accentState, minX, maxY - 1, maxZ - 1, sbb);
        this.method_14917(world, this.deco.accentState, maxX, maxY - 1, minZ + 1, sbb);
        this.method_14917(world, this.deco.accentState, maxX, maxY - 1, maxZ - 1, sbb);
        this.method_14917(world, this.deco.accentState, minX + 1, minY, minZ + 1, sbb);
        this.method_14917(world, this.deco.accentState, minX + 1, minY, maxZ - 1, sbb);
        this.method_14917(world, this.deco.accentState, maxX - 1, minY, minZ + 1, sbb);
        this.method_14917(world, this.deco.accentState, maxX - 1, minY, maxZ - 1, sbb);
        this.method_14917(world, this.deco.accentState, minX + 1, maxY, minZ + 1, sbb);
        this.method_14917(world, this.deco.accentState, minX + 1, maxY, maxZ - 1, sbb);
        this.method_14917(world, this.deco.accentState, maxX - 1, maxY, minZ + 1, sbb);
        this.method_14917(world, this.deco.accentState, maxX - 1, maxY, maxZ - 1, sbb);
    }

    @Override
    public int[] getValidOpening(Random rand, class_2470 direction) {
        int verticalOffset;
        int n = verticalOffset = this.size == 19 ? 5 : 4;
        if (direction == class_2470.field_11467 || direction == class_2470.field_11464) {
            int rx = direction == class_2470.field_11467 ? this.size - 1 : 0;
            int rz = this.size / 2;
            int ry = this.height - verticalOffset;
            return new int[]{rx, ry, rz};
        }
        if (direction == class_2470.field_11463 || direction == class_2470.field_11465) {
            int rx = this.size / 2;
            int rz = direction == class_2470.field_11463 ? this.size - 1 : 0;
            int ry = this.height - verticalOffset;
            return new int[]{rx, ry, rz};
        }
        return new int[]{0, 0, 0};
    }

    @Override
    public void addOpening(int dx, int dy, int dz, class_2470 direction) {
        this.addOpening(dx, dy, dz, direction, EnumDarkTowerDoor.VANISHING);
    }

    protected void addOpening(int dx, int dy, int dz, class_2470 direction, EnumDarkTowerDoor type) {
        super.addOpening(dx, dy, dz, direction);
        this.openingTypes.add(this.openings.indexOf(new class_2338(dx, dy, dz)), type);
    }

    @Override
    protected void makeOpenings(class_5281 world, class_3341 sbb) {
        block4: for (int i = 0; i < this.openings.size(); ++i) {
            class_2338 doorCoords = (class_2338)this.openings.get(i);
            EnumDarkTowerDoor doorType = this.openingTypes.size() > i ? this.openingTypes.get(i) : EnumDarkTowerDoor.VANISHING;
            switch (doorType) {
                case REAPPEARING: {
                    this.makeReappearingDoorOpening(world, doorCoords.method_10263(), doorCoords.method_10264(), doorCoords.method_10260(), sbb);
                    continue block4;
                }
                case LOCKED: {
                    this.makeLockedDoorOpening(world, doorCoords.method_10263(), doorCoords.method_10264(), doorCoords.method_10260(), sbb);
                    continue block4;
                }
                default: {
                    this.makeDoorOpening(world, doorCoords.method_10263(), doorCoords.method_10264(), doorCoords.method_10260(), sbb);
                }
            }
        }
    }

    @Override
    protected void makeDoorOpening(class_5281 world, int dx, int dy, int dz, class_3341 sbb) {
        class_2680 inactiveVanish = ((class_2248)TFBlocks.VANISHING_BLOCK.get()).method_9564();
        if (dx == 0 || dx == this.size - 1) {
            this.method_14940(world, sbb, dx, dy - 1, dz - 2, dx, dy + 3, dz + 2, this.deco.accentState, AIR, false);
            this.method_14940(world, sbb, dx, dy, dz - 1, dx, dy + 2, dz + 1, inactiveVanish, AIR, false);
        }
        if (dz == 0 || dz == this.size - 1) {
            this.method_14940(world, sbb, dx - 2, dy - 1, dz, dx + 2, dy + 3, dz, this.deco.accentState, AIR, false);
            this.method_14940(world, sbb, dx - 1, dy, dz, dx + 1, dy + 2, dz, inactiveVanish, AIR, false);
        }
    }

    protected void makeReappearingDoorOpening(class_5281 world, int dx, int dy, int dz, class_3341 sbb) {
        class_2680 inactiveReappearing = ((class_2248)TFBlocks.REAPPEARING_BLOCK.get()).method_9564();
        if (dx == 0 || dx == this.size - 1) {
            this.method_14940(world, sbb, dx, dy - 1, dz - 2, dx, dy + 3, dz + 2, this.deco.accentState, AIR, false);
            this.method_14940(world, sbb, dx, dy, dz - 1, dx, dy + 2, dz + 1, inactiveReappearing, AIR, false);
        }
        if (dz == 0 || dz == this.size - 1) {
            this.method_14940(world, sbb, dx - 2, dy - 1, dz, dx + 2, dy + 3, dz, this.deco.accentState, AIR, false);
            this.method_14940(world, sbb, dx - 1, dy, dz, dx + 1, dy + 2, dz, inactiveReappearing, AIR, false);
        }
    }

    protected void makeLockedDoorOpening(class_5281 world, int dx, int dy, int dz, class_3341 sbb) {
        class_2680 lockedVanish = ((class_2248)TFBlocks.LOCKED_VANISHING_BLOCK.get()).method_9564();
        class_2680 inactiveVanish = ((class_2248)TFBlocks.VANISHING_BLOCK.get()).method_9564();
        if (dx == 0 || dx == this.size - 1) {
            this.method_14940(world, sbb, dx, dy - 1, dz - 2, dx, dy + 3, dz + 2, this.deco.accentState, AIR, false);
            this.method_14940(world, sbb, dx, dy, dz - 1, dx, dy + 2, dz + 1, inactiveVanish, AIR, false);
            this.method_14917(world, lockedVanish, dx, dy, dz + 1, sbb);
            this.method_14917(world, lockedVanish, dx, dy, dz - 1, sbb);
            this.method_14917(world, lockedVanish, dx, dy + 2, dz + 1, sbb);
            this.method_14917(world, lockedVanish, dx, dy + 2, dz - 1, sbb);
        }
        if (dz == 0 || dz == this.size - 1) {
            this.method_14940(world, sbb, dx - 2, dy - 1, dz, dx + 2, dy + 3, dz, this.deco.accentState, AIR, false);
            this.method_14940(world, sbb, dx - 1, dy, dz, dx + 1, dy + 2, dz, inactiveVanish, AIR, false);
            this.method_14917(world, lockedVanish, dx + 1, dy, dz, sbb);
            this.method_14917(world, lockedVanish, dx - 1, dy, dz, sbb);
            this.method_14917(world, lockedVanish, dx + 1, dy + 2, dz, sbb);
            this.method_14917(world, lockedVanish, dx - 1, dy + 2, dz, sbb);
        }
    }

    @Override
    public boolean isDeadEnd() {
        int nonBalconies = 0;
        for (EnumDarkTowerDoor type : this.openingTypes) {
            if (type == EnumDarkTowerDoor.REAPPEARING) continue;
            ++nonBalconies;
        }
        return nonBalconies <= 1;
    }

    public boolean isKeyTower() {
        return this.keyTower;
    }

    public void setKeyTower(boolean keyTower) {
        this.keyTower = keyTower;
    }
}

