/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.start;

import java.util.List;
import net.minecraft.class_1311;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3037;
import net.minecraft.class_3195;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_5138;
import net.minecraft.class_5312;
import net.minecraft.class_5483;
import net.minecraft.class_6624;
import net.minecraft.class_6625;
import twilightforest.world.components.structures.TFStructureComponent;
import twilightforest.world.components.structures.start.LegacyStructureFeature;

public class TFStructureStart<C extends class_3037>
extends class_3449 {
    private boolean conquered = false;

    public TFStructureStart(class_5312<C, ?> structureFeature, class_1923 chunkPos, int references, class_6624 pieces) {
        super(structureFeature, chunkPos, references, pieces);
    }

    public class_2487 method_14972(class_6625 level, class_1923 chunkPos) {
        class_2487 tag = super.method_14972(level, chunkPos);
        if (this.method_16657()) {
            tag.method_10556("conquered", this.conquered);
        }
        return tag;
    }

    public void load(class_2487 nbt) {
        this.conquered = nbt.method_10577("conquered");
    }

    public final void setConquered(boolean flag) {
        this.conquered = flag;
    }

    public final boolean isConquered() {
        return this.conquered;
    }

    private static int getSpawnListIndexAt(class_3449 start, class_2338 pos) {
        int highestFoundIndex = -1;
        for (class_3443 component : start.method_14963()) {
            if (!component.method_14935().method_14662((class_2382)pos)) continue;
            if (component instanceof TFStructureComponent) {
                TFStructureComponent tfComponent = (TFStructureComponent)component;
                if (tfComponent.spawnListIndex <= highestFoundIndex) continue;
                highestFoundIndex = tfComponent.spawnListIndex;
                continue;
            }
            return 0;
        }
        return highestFoundIndex;
    }

    public static List<class_5483.class_1964> gatherPotentialSpawns(class_5138 structureManager, class_1311 classification, class_2338 pos) {
        for (class_5312 structure : structureManager.method_41036().method_33309(class_2378.field_25915)) {
            int index;
            class_3195 class_31952;
            class_3449 start;
            class_2960 location = class_2378.field_16644.method_10221((Object)structure.field_24835);
            if (location == null || !"twilightforest".equals(location.method_12836()) || !(start = structureManager.method_28388(pos, structure)).method_16657() || !((class_31952 = structure.field_24835) instanceof LegacyStructureFeature)) continue;
            LegacyStructureFeature legacyData = (LegacyStructureFeature)class_31952;
            if (classification != class_1311.field_6302) {
                return legacyData.feature.getSpawnableList(classification);
            }
            if (start instanceof TFStructureStart) {
                TFStructureStart s = (TFStructureStart)start;
                if (s.conquered) {
                    return null;
                }
            }
            if ((index = TFStructureStart.getSpawnListIndexAt(start, pos)) < 0) {
                return null;
            }
            return legacyData.feature.getSpawnableMonsterList(index);
        }
        return null;
    }
}

