/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.worldstripper.common;

import com.ewyboy.worldstripper.common.network.MessageHandler;
import java.util.Deque;
import java.util.LinkedList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraftforge.common.WorldWorkerManager;

public class WorldDressingWorker
implements WorldWorkerManager.IWorker {
    private final CommandSourceStack listener;
    protected final BlockPos start;
    protected final int radiusX;
    protected final int radiusZ;
    private final int total;
    private final ServerLevel dim;
    private final Deque<BlockPos> queue;
    private final int notificationFrequency;
    private int lastNotification = 0;
    private long lastNotificationTime = 0L;
    private final Boolean keepingLoaded = false;
    private int blockUpdateFlag;

    public WorldDressingWorker(CommandSourceStack listener, BlockPos start, int radiusX, int radiusZ, ServerLevel dim, int interval, int blockUpdateFlag) {
        this.listener = listener;
        this.start = start;
        this.radiusX = radiusX;
        this.radiusZ = radiusZ;
        this.dim = dim;
        this.queue = this.dressQueue();
        this.total = this.queue.size();
        this.notificationFrequency = interval != -1 ? interval : Math.max((radiusX + radiusZ) / 2 / 10, 100);
        this.lastNotificationTime = System.currentTimeMillis();
        this.blockUpdateFlag = blockUpdateFlag;
    }

    private Deque<BlockPos> dressQueue() {
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        BlockPos neg = new BlockPos(this.start.m_123341_() - this.radiusX, 0, this.start.m_123343_() - this.radiusZ);
        BlockPos pos = new BlockPos(this.start.m_123341_() + this.radiusX, 255, this.start.m_123343_() + this.radiusZ);
        BlockPos.m_121990_((BlockPos)neg, (BlockPos)pos).map(BlockPos::m_7949_).filter(MessageHandler.hashedBlockCache::containsKey).forEach(queue::add);
        return queue;
    }

    public boolean doWork() {
        BlockPos next;
        while (!((next = this.queue.pollLast()) != null && this.isInStrippedCache(next) || this.queue.isEmpty())) {
        }
        if (next != null) {
            if (++this.lastNotification >= this.notificationFrequency || this.lastNotificationTime < System.currentTimeMillis() - 60000L) {
                this.listener.m_81354_((Component)new TextComponent(String.format("Progress: %.02f%%", Float.valueOf((float)(this.total - this.queue.size()) / (float)this.total * 100.0f))), false);
                this.lastNotification = 0;
                this.lastNotificationTime = System.currentTimeMillis();
            }
            this.dim.m_7731_(next, MessageHandler.hashedBlockCache.remove(next), this.blockUpdateFlag);
        }
        if (this.queue.size() == 0) {
            this.listener.m_81354_((Component)new TextComponent("Progress: 100%"), false);
            this.listener.m_81354_((Component)new TextComponent("World Dressing operation successfully executed!"), false);
            return false;
        }
        return true;
    }

    private boolean isInStrippedCache(BlockPos next) {
        return MessageHandler.hashedBlockCache.containsKey(next);
    }

    public boolean hasWork() {
        return this.queue.size() > 0;
    }

    private BlockInWorld blockInfo(BlockPos pos) {
        return new BlockInWorld((LevelReader)this.dim, pos, this.keepingLoaded.booleanValue());
    }
}

