/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.worldstripper.common;

import com.ewyboy.worldstripper.common.config.ConfigHelper;
import com.ewyboy.worldstripper.common.config.ConfigOptions;
import com.ewyboy.worldstripper.common.network.MessageHandler;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.registries.ForgeRegistries;

public class WorldStrippingWorker
implements WorldWorkerManager.IWorker {
    private final CommandSourceStack listener;
    protected final BlockPos start;
    protected final int radiusX;
    protected final int radiusZ;
    private final int total;
    private final ServerLevel dim;
    private final Queue<BlockInWorld> queue;
    private final int notificationFrequency;
    private int lastNotification = 0;
    private long lastNotificationTime = 0L;
    private final Boolean keepingLoaded = true;
    private int blockUpdateFlag;

    public WorldStrippingWorker(CommandSourceStack listener, BlockPos start, int radiusX, int radiusZ, ServerLevel dim, int interval, int blockUpdateFlag) {
        this.listener = listener;
        this.start = start;
        this.radiusX = radiusX;
        this.radiusZ = radiusZ;
        this.dim = dim;
        this.queue = this.stripQueue();
        this.total = this.queue.size();
        this.notificationFrequency = interval != -1 ? interval : Math.max((radiusX + radiusZ) / 2 / 10, 100);
        this.lastNotificationTime = System.currentTimeMillis();
        this.blockUpdateFlag = blockUpdateFlag;
    }

    private Queue<BlockInWorld> stripQueue() {
        LinkedList<BlockInWorld> queue = new LinkedList<BlockInWorld>();
        BlockPos neg = new BlockPos(this.start.m_123341_() - this.radiusX, 0, this.start.m_123343_() - this.radiusZ);
        BlockPos pos = new BlockPos(this.start.m_123341_() + this.radiusX, 255, this.start.m_123343_() + this.radiusZ);
        BlockPos.m_121990_((BlockPos)neg, (BlockPos)pos).map(BlockPos::m_7949_).map(this::blockInfo).forEach(queue::add);
        return queue;
    }

    public boolean doWork() {
        BlockInWorld next;
        while (!((next = this.queue.poll()) != null && this.isReplaceableBlock(next) || this.queue.isEmpty())) {
        }
        if (next != null) {
            if (++this.lastNotification >= this.notificationFrequency || this.lastNotificationTime < System.currentTimeMillis() - 60000L) {
                this.listener.m_81354_((Component)new TextComponent(String.format("Progress: %.02f%%", Float.valueOf((float)(this.total - this.queue.size()) / (float)this.total * 100.0f))), false);
                this.lastNotification = 0;
                this.lastNotificationTime = System.currentTimeMillis();
            }
            MessageHandler.hashedBlockCache.put(next.m_61176_(), next.m_61168_());
            this.dim.m_7731_(next.m_61176_(), Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(ConfigOptions.Stripping.replacementBlock))).m_49966_(), this.blockUpdateFlag);
        }
        if (this.queue.size() == 0) {
            this.listener.m_81354_((Component)new TextComponent("Progress: 100%"), false);
            this.listener.m_81354_((Component)new TextComponent("World Stripping operation successfully executed!"), false);
            return false;
        }
        return true;
    }

    private boolean isReplaceableBlock(BlockInWorld next) {
        if (ConfigHelper.profileMap.get(ConfigOptions.Profiles.profile).contains(Objects.requireNonNull(next.m_61168_().m_60734_().getRegistryName()).toString())) {
            return true;
        }
        if (ConfigOptions.Stripping.stripBedrock) {
            return next.m_61168_().m_60734_() == Blocks.f_50752_;
        }
        return false;
    }

    public boolean hasWork() {
        return this.queue.size() > 0;
    }

    private BlockInWorld blockInfo(BlockPos pos) {
        return new BlockInWorld((LevelReader)this.dim, pos, this.keepingLoaded.booleanValue());
    }
}

