/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.worldstripper.common.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    public final Stripping stripping = new Stripping();
    public final Profiles profiles = new Profiles();
    public final BlockUpdate blockUpdate = new BlockUpdate();

    Config(ForgeConfigSpec.Builder builder) {
        builder.comment("World Stripper Config File").push("WorldStripper");
        builder.comment("Stripper Settings").push("Stripping");
        this.stripping.blocksToStripX = builder.comment("Amount of blocks to strip in on the x-axis").translation("worldstripper.config.stripping.blocksToStripX").defineInRange("blocks_to_strip_x", 48, 0, 320);
        this.stripping.blocksToStripZ = builder.comment("Amount of blocks to strip in on the z-axis").translation("worldstripper.config.stripping.blocksToStripZ").defineInRange("blocks_to_strip_z", 48, 0, 320);
        this.stripping.liveStripping = builder.comment("Toggles realtime world stripping / dressing").translation("worldstripper.config.stripping.liveStripping").define("live_stripping", true);
        this.stripping.stripBedrock = builder.comment("Should bedrock be removed?").translation("worldstripper.config.stripping.stripBedrock").define("strip_bedrock", false);
        this.stripping.replacementBlock = builder.comment("Replaces every block touched by the stripper with this block").translation("worldstripper.config.stripping.replacementBlock").define("replacement_block", (Object)"minecraft:air");
        builder.pop();
        builder.comment("Stripper Profile Settings").push("Profiles");
        this.profiles.profile = builder.comment("Selected profile").translation("worldstripper.config.common.profiles.profile").defineEnum("profile", (Enum)Profiles.Profile.PROFILE_1);
        this.profiles.profile1 = builder.comment("Profile 1 - A list of blocks to strip away from the world").translation("worldstripper.config.profiles.profile1").define("profile_1", (Object)Lists.newArrayList(Profiles.defaultStripList));
        this.profiles.profile2 = builder.comment("Profile 2 - A list of blocks to strip away from the world").translation("worldstripper.config.profiles.profile2").define("profile_2", (Object)Lists.newArrayList(Profiles.defaultStripList));
        this.profiles.profile3 = builder.comment("Profile 3 - A list of blocks to strip away from the world").translation("worldstripper.config.profiles.profile3").define("profile_3", (Object)Lists.newArrayList(Profiles.defaultStripList));
        this.profiles.profile4 = builder.comment("Profile 4 - A list of blocks to strip away from the world").translation("worldstripper.config.profiles.profile4").define("profile_4", (Object)Lists.newArrayList(Profiles.defaultStripList));
        this.profiles.profile5 = builder.comment("Profile 5 - A list of blocks to strip away from the world").translation("worldstripper.config.profiles.profile5").define("profile_5", (Object)Lists.newArrayList(Profiles.defaultStripList));
        builder.pop();
        builder.comment("Block Update Settings").push("BlockUpdate");
        builder.comment("ADVANCED SETTINGS");
        builder.comment("Don't touch unless you know what you are doing");
        this.blockUpdate.notifyNeighbors = builder.comment("Calls neighborChanged on surrounding blocks (with isMoving as false)").translation("worldstripper.config.blockupdate.notifyNeighbors").define("notify_neighbors", false);
        this.blockUpdate.blockUpdate = builder.comment("Calls for block update").translation("worldstripper.config.blockupdate.blockUpdate").define("block_update", true);
        this.blockUpdate.noRender = builder.comment("Stops the blocks from being marked for a render update").translation("worldstripper.config.blockupdate.noRender").define("no_render", false);
        this.blockUpdate.renderMainThread = builder.comment("Makes the block be re-rendered immediately, on the main thread").translation("worldstripper.config.blockupdate.renderMainThread").define("render_main_thread", false);
        this.blockUpdate.updateNeighbors = builder.comment("Causes neighbor updates to be sent to ALL surrounding blocks").translation("worldstripper.config.blockupdate.updateNeighbors").define("update_neighbors", true);
        builder.pop();
        builder.pop();
    }

    public static class Stripping {
        ForgeConfigSpec.IntValue blocksToStripX;
        ForgeConfigSpec.IntValue blocksToStripZ;
        ForgeConfigSpec.BooleanValue liveStripping;
        ForgeConfigSpec.BooleanValue stripBedrock;
        ForgeConfigSpec.ConfigValue<String> replacementBlock;
    }

    public static class Profiles {
        ForgeConfigSpec.EnumValue profile;
        ForgeConfigSpec.ConfigValue<List<? extends String>> profile1;
        ForgeConfigSpec.ConfigValue<List<? extends String>> profile2;
        ForgeConfigSpec.ConfigValue<List<? extends String>> profile3;
        ForgeConfigSpec.ConfigValue<List<? extends String>> profile4;
        ForgeConfigSpec.ConfigValue<List<? extends String>> profile5;
        public static List<String> defaultStripList = new ArrayList<String>();

        static {
            defaultStripList.add("minecraft:dirt");
            defaultStripList.add("minecraft:grass");
            defaultStripList.add("minecraft:grass_path");
            defaultStripList.add("minecraft:tall_grass");
            defaultStripList.add("minecraft:grass_block");
            defaultStripList.add("minecraft:stone");
            defaultStripList.add("minecraft:diorite");
            defaultStripList.add("minecraft:granite");
            defaultStripList.add("minecraft:andesite");
            defaultStripList.add("minecraft:gravel");
            defaultStripList.add("minecraft:sand");
            defaultStripList.add("minecraft:sandstone");
            defaultStripList.add("minecraft:oak_log");
            defaultStripList.add("minecraft:dark_oak_log");
            defaultStripList.add("minecraft:spruce_log");
            defaultStripList.add("minecraft:birch_log");
            defaultStripList.add("minecraft:jungle_log");
            defaultStripList.add("minecraft:acacia_log");
            defaultStripList.add("minecraft:oak_leaves");
            defaultStripList.add("minecraft:dark_oak_leaves");
            defaultStripList.add("minecraft:spruce_leaves");
            defaultStripList.add("minecraft:birch_leaves");
            defaultStripList.add("minecraft:jungle_leaves");
            defaultStripList.add("minecraft:acacia_leaves");
            defaultStripList.add("minecraft:water");
            defaultStripList.add("minecraft:flowing_water");
            defaultStripList.add("minecraft:lava");
            defaultStripList.add("minecraft:flowing_lava");
            defaultStripList.add("minecraft:netherrack");
            defaultStripList.add("minecraft:end_stone");
            defaultStripList.add("minecraft:podzol");
            defaultStripList.add("minecraft:bamboo");
            defaultStripList.add("minecraft:seagrass");
            defaultStripList.add("minecraft:tall_seagrass");
            defaultStripList.add("minecraft:deepslate");
            defaultStripList.add("minecraft:tuff");
            defaultStripList.add("minecraft:glow_lichen");
        }

        public static enum Profile {
            PROFILE_1,
            PROFILE_2,
            PROFILE_3,
            PROFILE_4,
            PROFILE_5;

        }
    }

    public static class BlockUpdate {
        ForgeConfigSpec.BooleanValue notifyNeighbors;
        ForgeConfigSpec.BooleanValue blockUpdate;
        ForgeConfigSpec.BooleanValue noRender;
        ForgeConfigSpec.BooleanValue renderMainThread;
        ForgeConfigSpec.BooleanValue updateNeighbors;
    }
}

