/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.worldstripper.common.config;

import com.ewyboy.worldstripper.common.config.Config;
import com.ewyboy.worldstripper.common.config.ConfigHolder;
import com.ewyboy.worldstripper.common.config.ConfigOptions;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="worldstripper", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigHelper {
    public static ModConfig config;
    public static HashMap<Config.Profiles.Profile, List<String>> profileMap;
    public static HashMap<Config.Profiles.Profile, String> profilePathMap;

    private static void updateMap(Config.Profiles.Profile profile, List<String> profileList) {
        if (profileMap.containsKey((Object)profile)) {
            profileMap.replace(profile, profileList);
        } else {
            profileMap.put(profile, profileList);
        }
    }

    static void readConfigToMemory(ModConfig modConfig) {
        config = modConfig;
        Config config = ConfigHolder.config;
        ConfigOptions.Stripping.blocksToStripX = (Integer)config.stripping.blocksToStripX.get();
        ConfigOptions.Stripping.blocksToStripZ = (Integer)config.stripping.blocksToStripZ.get();
        ConfigOptions.Stripping.liveStripping = (Boolean)config.stripping.liveStripping.get();
        ConfigOptions.Stripping.stripBedrock = (Boolean)config.stripping.stripBedrock.get();
        ConfigOptions.Stripping.replacementBlock = (String)config.stripping.replacementBlock.get();
        ConfigOptions.Profiles.profile = (Enum)config.profiles.profile.get();
        ConfigOptions.Profiles.profile1 = ((List)config.profiles.profile1.get()).stream().map(String::toLowerCase).collect(Collectors.toList());
        ConfigOptions.Profiles.profile2 = ((List)config.profiles.profile2.get()).stream().map(String::toLowerCase).collect(Collectors.toList());
        ConfigOptions.Profiles.profile3 = ((List)config.profiles.profile3.get()).stream().map(String::toLowerCase).collect(Collectors.toList());
        ConfigOptions.Profiles.profile4 = ((List)config.profiles.profile4.get()).stream().map(String::toLowerCase).collect(Collectors.toList());
        ConfigOptions.Profiles.profile5 = ((List)config.profiles.profile5.get()).stream().map(String::toLowerCase).collect(Collectors.toList());
        ConfigHelper.updateMap(Config.Profiles.Profile.PROFILE_1, ConfigOptions.Profiles.profile1);
        ConfigHelper.updateMap(Config.Profiles.Profile.PROFILE_2, ConfigOptions.Profiles.profile2);
        ConfigHelper.updateMap(Config.Profiles.Profile.PROFILE_3, ConfigOptions.Profiles.profile3);
        ConfigHelper.updateMap(Config.Profiles.Profile.PROFILE_4, ConfigOptions.Profiles.profile4);
        ConfigHelper.updateMap(Config.Profiles.Profile.PROFILE_5, ConfigOptions.Profiles.profile5);
        ConfigOptions.BlockUpdate.notifyNeighbors = (Boolean)config.blockUpdate.notifyNeighbors.get();
        ConfigOptions.BlockUpdate.blockUpdate = (Boolean)config.blockUpdate.blockUpdate.get();
        ConfigOptions.BlockUpdate.noRender = (Boolean)config.blockUpdate.noRender.get();
        ConfigOptions.BlockUpdate.renderMainThread = (Boolean)config.blockUpdate.renderMainThread.get();
        ConfigOptions.BlockUpdate.updateNeighbors = (Boolean)config.blockUpdate.updateNeighbors.get();
    }

    static void writeConfigFromMemory(ModConfig modConfig) {
        config = modConfig;
        Config config = ConfigHolder.config;
        config.stripping.blocksToStripX.set((Object)ConfigOptions.Stripping.blocksToStripX);
        config.stripping.blocksToStripZ.set((Object)ConfigOptions.Stripping.blocksToStripZ);
        config.stripping.liveStripping.set((Object)ConfigOptions.Stripping.liveStripping);
        config.stripping.replacementBlock.set((Object)ConfigOptions.Stripping.replacementBlock);
        config.stripping.stripBedrock.set((Object)ConfigOptions.Stripping.stripBedrock);
        config.profiles.profile.set(ConfigOptions.Profiles.profile);
        config.profiles.profile1.set(ConfigOptions.Profiles.profile1);
        config.profiles.profile2.set(ConfigOptions.Profiles.profile2);
        config.profiles.profile3.set(ConfigOptions.Profiles.profile3);
        config.profiles.profile4.set(ConfigOptions.Profiles.profile4);
        config.profiles.profile5.set(ConfigOptions.Profiles.profile5);
        config.blockUpdate.notifyNeighbors.set((Object)ConfigOptions.BlockUpdate.notifyNeighbors);
        config.blockUpdate.blockUpdate.set((Object)ConfigOptions.BlockUpdate.blockUpdate);
        config.blockUpdate.noRender.set((Object)ConfigOptions.BlockUpdate.noRender);
        config.blockUpdate.renderMainThread.set((Object)ConfigOptions.BlockUpdate.renderMainThread);
        config.blockUpdate.updateNeighbors.set((Object)ConfigOptions.BlockUpdate.updateNeighbors);
    }

    public static void reloadConfig() {
        ConfigHelper.readConfigToMemory(config);
    }

    public static void syncConfig() {
        ConfigHelper.writeConfigFromMemory(config);
    }

    public static void saveConfig() {
        config.save();
    }

    public static void reloadAndSaveConfig() {
        ConfigHelper.readConfigToMemory(config);
        config.save();
    }

    public static void saveAndReloadConfig() {
        config.save();
        ConfigHelper.readConfigToMemory(config);
    }

    public static void syncAndSaveConfig() {
        ConfigHelper.writeConfigFromMemory(config);
        config.save();
    }

    public static void saveAndSyncConfig() {
        config.save();
        ConfigHelper.writeConfigFromMemory(config);
    }

    public static void setValueAndSaveConfig(String path, Object newValue) {
        config.getConfigData().set(path, newValue);
        config.save();
        ConfigHelper.reloadConfig();
    }

    public static String getComment(String path) {
        return config.getConfigData().getComment(path).replaceAll("\n", " - ");
    }

    static {
        profileMap = new HashMap();
        profilePathMap = new HashMap();
        profilePathMap.put(Config.Profiles.Profile.PROFILE_1, "profile_1");
        profilePathMap.put(Config.Profiles.Profile.PROFILE_2, "profile_2");
        profilePathMap.put(Config.Profiles.Profile.PROFILE_3, "profile_3");
        profilePathMap.put(Config.Profiles.Profile.PROFILE_4, "profile_4");
        profilePathMap.put(Config.Profiles.Profile.PROFILE_5, "profile_5");
    }

    public static final class CategoryName {
        public static final String STRIPPING = "WorldStripper.Stripping.";
        public static final String PROFILES = "WorldStripper.Profiles.";
        public static final String BLOCK_UPDATE = "WorldStripper.BlockUpdate.";
    }
}

