/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.worldstripper.common.network.messages.stripping;

import com.ewyboy.worldstripper.common.config.ConfigOptions;
import com.ewyboy.worldstripper.common.network.MessageHandler;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class MessageDressWorld {
    public int x;
    public int z;

    public MessageDressWorld() {
        this.x = -1;
        this.z = -1;
    }

    public MessageDressWorld(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.z);
    }

    public static MessageDressWorld decode(FriendlyByteBuf buf) {
        return new MessageDressWorld(buf.readInt(), buf.readInt());
    }

    public static void handle(MessageDressWorld message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Level world = player != null ? player.m_20193_() : null;
            double chunkClearSizeX = ConfigOptions.Stripping.blocksToStripX / 2;
            double chunkClearSizeZ = ConfigOptions.Stripping.blocksToStripZ / 2;
            if (player.m_7500_() || player.m_5833_()) {
                player.m_5661_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.RED + "WARNING! " + ChatFormatting.WHITE + "World Dressing Initialized! Lag May Occur.."), false);
                int x = (int)(player.m_20185_() - chunkClearSizeX);
                while ((double)x <= player.m_20185_() + chunkClearSizeX) {
                    int y = 0;
                    while ((double)y <= player.m_20186_() + 16.0) {
                        int z = (int)(player.m_20189_() - chunkClearSizeZ);
                        while ((double)z <= player.m_20189_() + chunkClearSizeZ) {
                            BlockPos targetBlockPos = new BlockPos(x, y, z);
                            if (MessageHandler.hashedBlockCache.get(targetBlockPos) != null) {
                                world.m_7731_(targetBlockPos, MessageHandler.hashedBlockCache.get(targetBlockPos), 3);
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                player.m_5661_((Component)new TextComponent("World Dressing Successfully Executed!"), false);
            } else {
                player.m_5661_((Component)new TextComponent(ChatFormatting.RED + "Error: You have to be in creative mode to use this feature!"), false);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

