/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.worldstripper.common.network.messages.stripping;

import com.ewyboy.worldstripper.common.config.ConfigHelper;
import com.ewyboy.worldstripper.common.config.ConfigOptions;
import com.ewyboy.worldstripper.common.network.MessageHandler;
import com.ewyboy.worldstripper.common.stripclub.BlockUpdater;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class MessageStripWorld {
    public int x;
    public int z;

    public MessageStripWorld() {
        this.x = -1;
        this.z = -1;
    }

    public MessageStripWorld(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.z);
    }

    public static MessageStripWorld decode(FriendlyByteBuf buf) {
        return new MessageStripWorld(buf.readInt(), buf.readInt());
    }

    public static void handle(MessageStripWorld message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            double chunkClearSizeZ;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Level world = player != null ? player.m_20193_() : null;
            List<String> profileList = ConfigHelper.profileMap.get(ConfigOptions.Profiles.profile);
            int blockUpdateFlag = BlockUpdater.getBlockUpdateFlag();
            double chunkClearSizeX = message.getX() < 0 ? (double)ConfigOptions.Stripping.blocksToStripX : (double)message.getX();
            double d = chunkClearSizeZ = message.getZ() < 0 ? (double)ConfigOptions.Stripping.blocksToStripZ : (double)message.getZ();
            if (player.m_7500_()) {
                player.m_5661_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.RED + "WARNING! " + ChatFormatting.WHITE + "World Stripping Initialized! Lag May Occur.."), false);
                int x = (int)(player.m_20185_() - chunkClearSizeX);
                while ((double)x <= player.m_20185_() + chunkClearSizeX) {
                    int y = (int)(player.m_20186_() + 16.0);
                    while ((double)y >= 0.0) {
                        int z = (int)(player.m_20189_() - chunkClearSizeZ);
                        while ((double)z <= player.m_20189_() + chunkClearSizeZ) {
                            BlockPos targetBlockPos = new BlockPos(x, y, z);
                            BlockState targetBlockState = world.m_8055_(targetBlockPos);
                            Block targetBlock = targetBlockState.m_60734_();
                            if (!targetBlock.equals(Blocks.f_50016_) || !targetBlock.equals(Blocks.f_50359_)) {
                                Stream<String> stream = Arrays.stream(profileList.toArray(new String[0]));
                                ResourceLocation targetBlockResource = new ResourceLocation(Objects.requireNonNull(targetBlock.getRegistryName()).toString());
                                stream.map(ResourceLocation::new).filter(arg_0 -> ((ResourceLocation)targetBlockResource).equals(arg_0)).forEachOrdered(s -> {
                                    MessageHandler.hashedBlockCache.put(targetBlockPos, targetBlockState);
                                    BlockState newState = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(ConfigOptions.Stripping.replacementBlock))).m_49966_();
                                    world.m_7731_(targetBlockPos, newState, blockUpdateFlag);
                                });
                            }
                            ++z;
                        }
                        --y;
                    }
                    ++x;
                }
                player.m_5661_((Component)new TextComponent("World Stripping Successfully Executed!"), false);
            } else {
                player.m_5661_((Component)new TextComponent(ChatFormatting.RED + "Error: You have to be in creative mode to use this feature!"), false);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

