/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.worldstripper.common.stripclub;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.dimension.DimensionType;

public class StripperCache {
    public static final Codec<BlockPos> BLOCK_POS_STRING_CODEC = Codec.STRING.xmap(Long::parseLong, String::valueOf).xmap(BlockPos::m_122022_, BlockPos::m_121878_);
    public static final Codec<StripperCache> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DimensionType.f_63843_.fieldOf("dimension").forGetter(it -> it.dimensionType), (App)Codec.unboundedMap(BLOCK_POS_STRING_CODEC, (Codec)BlockState.f_61039_).fieldOf("strippedBlocks").forGetter(it -> it.strippedBlocksMap)).apply((Applicative)instance, StripperCache::new));
    private final DimensionType dimensionType;
    private final Map<BlockPos, BlockState> strippedBlocksMap;

    private StripperCache(DimensionType dimensionType, Map<BlockPos, BlockState> strippedBlocksMap) {
        this.dimensionType = dimensionType;
        this.strippedBlocksMap = strippedBlocksMap;
    }

    public StripperCache(LevelReader world) {
        this(world.m_6042_(), new HashMap<BlockPos, BlockState>());
    }

    public void addStrippedBlock(BlockInWorld blockInfo) {
        this.strippedBlocksMap.put(blockInfo.m_61176_(), blockInfo.m_61168_());
    }

    public Set<BlockPos> getCachedPositions() {
        return this.strippedBlocksMap.keySet();
    }

    public BlockState getCachedState(BlockPos pos) {
        return this.strippedBlocksMap.get(pos);
    }
}

