/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.dreadsteel.client.models.armor;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class ArmorModel<T extends LivingEntity>
extends HumanoidModel<T>
implements IClientItemExtensions {
    public EquipmentSlot slot;
    ModelPart root;
    ModelPart modelHead;
    ModelPart modelBody;
    ModelPart modelLeft_arm;
    ModelPart modelRight_arm;
    ModelPart modelBelt;
    ModelPart modelLeft_leg;
    ModelPart modelRight_leg;
    ModelPart modelLeft_foot;
    ModelPart modelRight_foot;

    public ArmorModel(ModelPart root) {
        super(root);
        this.root = root;
        this.modelBelt = root.m_171324_("Belt");
        this.modelBody = root.m_171324_("Body");
        this.modelRight_foot = root.m_171324_("RightBoot");
        this.modelLeft_foot = root.m_171324_("LeftBoot");
        this.modelLeft_arm = root.m_171324_("LeftArm");
        this.modelRight_arm = root.m_171324_("RightArm");
        this.modelRight_leg = root.m_171324_("LeftLeg");
        this.modelLeft_leg = root.m_171324_("RightLeg");
        this.modelHead = root.m_171324_("Head");
    }

    public static PartDefinition createHumanoidAlias(MeshDefinition mesh) {
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("Body", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("Belt", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("Head", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("LeftLeg", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("LeftBoot", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("RightLeg", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("RightBoot", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("LeftArm", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("RightArm", new CubeListBuilder(), PartPose.f_171404_);
        return root;
    }

    protected Iterable<ModelPart> m_5607_() {
        return this.slot == EquipmentSlot.HEAD ? ImmutableList.of((Object)this.modelHead) : ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        if (this.slot == EquipmentSlot.CHEST) {
            return ImmutableList.of((Object)this.modelBody, (Object)this.modelLeft_arm, (Object)this.modelRight_arm);
        }
        if (this.slot == EquipmentSlot.LEGS) {
            return ImmutableList.of((Object)this.modelLeft_leg, (Object)this.modelRight_leg, (Object)this.modelBelt);
        }
        if (this.slot == EquipmentSlot.FEET) {
            return ImmutableList.of((Object)this.modelLeft_foot, (Object)this.modelRight_foot);
        }
        return ImmutableList.of();
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        matrixStack.m_85836_();
        if (this.slot == EquipmentSlot.HEAD) {
            this.modelHead.m_104315_(this.f_102808_);
            this.modelHead.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        } else if (this.slot == EquipmentSlot.CHEST) {
            this.modelBody.m_104315_(this.f_102810_);
            this.modelBody.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.modelRight_arm.m_104315_(this.f_102811_);
            this.modelRight_arm.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.modelLeft_arm.m_104315_(this.f_102812_);
            this.modelLeft_arm.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        } else if (this.slot == EquipmentSlot.LEGS) {
            this.modelBelt.m_104315_(this.f_102810_);
            this.modelBelt.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.modelRight_leg.m_104315_(this.f_102813_);
            this.modelRight_leg.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.modelLeft_leg.m_104315_(this.f_102814_);
            this.modelLeft_leg.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        } else if (this.slot == EquipmentSlot.FEET) {
            this.modelRight_foot.m_104315_(this.f_102813_);
            this.modelRight_foot.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.modelLeft_foot.m_104315_(this.f_102814_);
            this.modelLeft_foot.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        matrixStack.m_85849_();
    }

    public void copyFromDefault(HumanoidModel model) {
        this.modelBody.m_104315_(model.f_102810_);
        this.modelBelt.m_104315_(model.f_102810_);
        this.modelHead.m_104315_(model.f_102808_);
        this.modelLeft_arm.m_104315_(model.f_102812_);
        this.modelRight_arm.m_104315_(model.f_102811_);
        this.modelLeft_leg.m_104315_(this.f_102814_);
        this.modelRight_leg.m_104315_(this.f_102813_);
        this.modelLeft_foot.m_104315_(this.f_102814_);
        this.modelRight_foot.m_104315_(this.f_102813_);
    }
}

