/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.dreadsteel.item.armor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mindoth.dreadsteel.client.models.armor.DreadsteelModel;
import net.mindoth.dreadsteel.config.DreadsteelCommonConfig;
import net.mindoth.dreadsteel.registries.DreadsteelItems;
import net.mindoth.dreadsteel.util.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="dreadsteel")
public class DreadsteelArmor
extends ArmorItem {
    public static final Map<String, UUID> NAME_UUID_MAP = new HashMap<String, UUID>();

    public static UUID getUUID(ItemStack stack) {
        return NAME_UUID_MAP.computeIfAbsent(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString(), s -> UUID.nameUUIDFromBytes(s.getBytes()));
    }

    @SubscribeEvent
    public static void dreadsteelAttributeEvent(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (item == DreadsteelItems.DREADSTEEL_HELMET.get() && event.getSlotType() == EquipmentSlot.HEAD) {
            event.addModifier(Attributes.f_22284_, new AttributeModifier(DreadsteelArmor.getUUID(event.getItemStack()), "dreadsteel_armor", (double)((Integer)DreadsteelCommonConfig.HELMET_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
            event.addModifier(Attributes.f_22285_, new AttributeModifier(DreadsteelArmor.getUUID(event.getItemStack()), "dreadsteel_toughness", (double)((Integer)DreadsteelCommonConfig.ARMOR_TOUGHNESS.get()).intValue(), AttributeModifier.Operation.ADDITION));
            event.addModifier(Attributes.f_22278_, new AttributeModifier(DreadsteelArmor.getUUID(event.getItemStack()), "dreadsteel_knockback_resistance", ((Double)DreadsteelCommonConfig.ARMOR_KNOCKBACK_RESISTANCE.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
        }
        if (item == DreadsteelItems.DREADSTEEL_CHESTPLATE.get() && event.getSlotType() == EquipmentSlot.CHEST) {
            event.addModifier(Attributes.f_22284_, new AttributeModifier(DreadsteelArmor.getUUID(event.getItemStack()), "dreadsteel_armor", (double)((Integer)DreadsteelCommonConfig.CHESTPLATE_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
            event.addModifier(Attributes.f_22285_, new AttributeModifier(DreadsteelArmor.getUUID(event.getItemStack()), "dreadsteel_toughness", (double)((Integer)DreadsteelCommonConfig.ARMOR_TOUGHNESS.get()).intValue(), AttributeModifier.Operation.ADDITION));
            event.addModifier(Attributes.f_22278_, new AttributeModifier(DreadsteelArmor.getUUID(event.getItemStack()), "dreadsteel_knockback_resistance", ((Double)DreadsteelCommonConfig.ARMOR_KNOCKBACK_RESISTANCE.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
        }
        if (item == DreadsteelItems.DREADSTEEL_LEGGINGS.get() && event.getSlotType() == EquipmentSlot.LEGS) {
            event.addModifier(Attributes.f_22284_, new AttributeModifier(DreadsteelArmor.getUUID(event.getItemStack()), "dreadsteel_armor", (double)((Integer)DreadsteelCommonConfig.LEGGINGS_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
            event.addModifier(Attributes.f_22285_, new AttributeModifier(DreadsteelArmor.getUUID(event.getItemStack()), "dreadsteel_toughness", (double)((Integer)DreadsteelCommonConfig.ARMOR_TOUGHNESS.get()).intValue(), AttributeModifier.Operation.ADDITION));
            event.addModifier(Attributes.f_22278_, new AttributeModifier(DreadsteelArmor.getUUID(event.getItemStack()), "dreadsteel_knockback_resistance", ((Double)DreadsteelCommonConfig.ARMOR_KNOCKBACK_RESISTANCE.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
        }
        if (item == DreadsteelItems.DREADSTEEL_BOOTS.get() && event.getSlotType() == EquipmentSlot.FEET) {
            event.addModifier(Attributes.f_22284_, new AttributeModifier(DreadsteelArmor.getUUID(event.getItemStack()), "dreadsteel_armor", (double)((Integer)DreadsteelCommonConfig.BOOTS_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
            event.addModifier(Attributes.f_22285_, new AttributeModifier(DreadsteelArmor.getUUID(event.getItemStack()), "dreadsteel_toughness", (double)((Integer)DreadsteelCommonConfig.ARMOR_TOUGHNESS.get()).intValue(), AttributeModifier.Operation.ADDITION));
            event.addModifier(Attributes.f_22278_, new AttributeModifier(DreadsteelArmor.getUUID(event.getItemStack()), "dreadsteel_knockback_resistance", ((Double)DreadsteelCommonConfig.ARMOR_KNOCKBACK_RESISTANCE.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.dreadsteel.dreadsteel_setbonus"));
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            static DreadsteelModel model;

            public DreadsteelModel getHumanoidArmorModel(LivingEntity entity, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel _default) {
                if (model == null) {
                    model = new DreadsteelModel(Minecraft.m_91087_().m_167973_().m_171103_(ClientProxy.DREADSTEEL_ARMOR_LAYER));
                }
                float pticks = Minecraft.m_91087_().m_91296_();
                float f = Mth.m_14189_((float)pticks, (float)entity.f_20884_, (float)entity.f_20883_);
                float f1 = Mth.m_14189_((float)pticks, (float)entity.f_20886_, (float)entity.f_20885_);
                float netHeadYaw = f1 - f;
                float netHeadPitch = Mth.m_14179_((float)pticks, (float)entity.f_19860_, (float)entity.m_146909_());
                1.model.slot = DreadsteelArmor.this.f_40377_;
                model.copyFromDefault(_default);
                model.m_6973_(entity, entity.f_20925_, entity.f_20924_, (float)entity.f_19797_ + pticks, netHeadYaw, netHeadPitch);
                return model;
            }
        });
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        CompoundTag tag = stack.m_41783_();
        String color = null;
        if (tag != null) {
            if (tag.m_128451_("CustomModelData") == 1) {
                color = "dreadsteel:textures/item/dreadsteel_armor_model_white.png";
            }
            if (tag.m_128451_("CustomModelData") == 2) {
                color = "dreadsteel:textures/item/dreadsteel_armor_model_black.png";
            }
            if (tag.m_128451_("CustomModelData") == 3) {
                color = "dreadsteel:textures/item/dreadsteel_armor_model_bronze.png";
            }
            if (tag.m_128451_("CustomModelData") == 0) {
                color = "dreadsteel:textures/item/dreadsteel_armor_model_default.png";
            }
        } else {
            color = "dreadsteel:textures/item/dreadsteel_armor_model_default.png";
        }
        return color;
    }

    public boolean m_8120_(ItemStack p_77616_1_) {
        return true;
    }

    public DreadsteelArmor(ArmorMaterial material, EquipmentSlot slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    @SubscribeEvent
    public static void noHat(RenderPlayerEvent event) {
        Player player = event.getEntity();
        if (player.m_6844_(EquipmentSlot.HEAD).m_41720_() == DreadsteelItems.DREADSTEEL_HELMET.get()) {
            ((PlayerModel)event.getRenderer().m_7200_()).f_102809_.f_104207_ = false;
        }
    }

    @SubscribeEvent
    public static void dreadsteelSetDefence(LivingAttackEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_6844_(EquipmentSlot.HEAD).m_41720_() == DreadsteelItems.DREADSTEEL_HELMET.get() && entity.m_6844_(EquipmentSlot.CHEST).m_41720_() == DreadsteelItems.DREADSTEEL_CHESTPLATE.get() && entity.m_6844_(EquipmentSlot.LEGS).m_41720_() == DreadsteelItems.DREADSTEEL_LEGGINGS.get() && entity.m_6844_(EquipmentSlot.FEET).m_41720_() == DreadsteelItems.DREADSTEEL_BOOTS.get() && (event.getSource().m_19385_().equals(DamageSource.f_19306_.m_19385_()) || event.getSource().m_19385_().equals(DamageSource.f_19305_.m_19385_()) || event.getSource().m_19385_().equals(DamageSource.f_19307_.m_19385_()) || event.getSource().m_19385_().equals(DamageSource.f_19314_.m_19385_()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerUseArmorItem(PlayerInteractEvent.RightClickItem event) {
        CompoundTag tag;
        ItemStack headStack = event.getEntity().m_6844_(EquipmentSlot.HEAD);
        ItemStack chestStack = event.getEntity().m_6844_(EquipmentSlot.CHEST);
        ItemStack legsStack = event.getEntity().m_6844_(EquipmentSlot.LEGS);
        ItemStack feetStack = event.getEntity().m_6844_(EquipmentSlot.FEET);
        ItemStack mainStack = event.getEntity().m_6844_(EquipmentSlot.MAINHAND);
        ItemStack offStack = event.getEntity().m_6844_(EquipmentSlot.OFFHAND);
        if (event.getItemStack().m_41720_().equals(DreadsteelItems.WHITE_KIT.get())) {
            if (headStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_HELMET.get())) {
                tag = headStack.m_41784_();
                tag.m_128405_("CustomModelData", 1);
                headStack.m_41751_(tag);
            }
            if (chestStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_CHESTPLATE.get())) {
                tag = chestStack.m_41784_();
                tag.m_128405_("CustomModelData", 1);
                chestStack.m_41751_(tag);
            }
            if (legsStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_LEGGINGS.get())) {
                tag = legsStack.m_41784_();
                tag.m_128405_("CustomModelData", 1);
                legsStack.m_41751_(tag);
            }
            if (feetStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_BOOTS.get())) {
                tag = feetStack.m_41784_();
                tag.m_128405_("CustomModelData", 1);
                feetStack.m_41751_(tag);
            }
            if (mainStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_SCYTHE.get())) {
                tag = mainStack.m_41784_();
                tag.m_128405_("CustomModelData", 1);
                mainStack.m_41751_(tag);
            }
            if (offStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_SCYTHE.get())) {
                tag = offStack.m_41784_();
                tag.m_128405_("CustomModelData", 1);
                offStack.m_41751_(tag);
            }
            if (mainStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_SHIELD.get())) {
                tag = mainStack.m_41784_();
                tag.m_128405_("CustomModelData", 1);
                mainStack.m_41751_(tag);
            }
            if (offStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_SHIELD.get())) {
                tag = offStack.m_41784_();
                tag.m_128405_("CustomModelData", 1);
                offStack.m_41751_(tag);
            }
            if (!event.getEntity().m_7500_()) {
                event.getItemStack().m_41774_(1);
            }
            event.getEntity().m_6330_(SoundEvents.f_11675_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (event.getItemStack().m_41720_().equals(DreadsteelItems.BLACK_KIT.get())) {
            if (headStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_HELMET.get())) {
                tag = headStack.m_41784_();
                tag.m_128405_("CustomModelData", 2);
                headStack.m_41751_(tag);
            }
            if (chestStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_CHESTPLATE.get())) {
                tag = chestStack.m_41784_();
                tag.m_128405_("CustomModelData", 2);
                chestStack.m_41751_(tag);
            }
            if (legsStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_LEGGINGS.get())) {
                tag = legsStack.m_41784_();
                tag.m_128405_("CustomModelData", 2);
                legsStack.m_41751_(tag);
            }
            if (feetStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_BOOTS.get())) {
                tag = feetStack.m_41784_();
                tag.m_128405_("CustomModelData", 2);
                feetStack.m_41751_(tag);
            }
            if (mainStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_SCYTHE.get())) {
                tag = mainStack.m_41784_();
                tag.m_128405_("CustomModelData", 2);
                mainStack.m_41751_(tag);
            }
            if (offStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_SCYTHE.get())) {
                tag = offStack.m_41784_();
                tag.m_128405_("CustomModelData", 2);
                offStack.m_41751_(tag);
            }
            if (mainStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_SHIELD.get())) {
                tag = mainStack.m_41784_();
                tag.m_128405_("CustomModelData", 2);
                mainStack.m_41751_(tag);
            }
            if (offStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_SHIELD.get())) {
                tag = offStack.m_41784_();
                tag.m_128405_("CustomModelData", 2);
                offStack.m_41751_(tag);
            }
            if (!event.getEntity().m_7500_()) {
                event.getItemStack().m_41774_(1);
            }
            event.getEntity().m_6330_(SoundEvents.f_11675_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (event.getItemStack().m_41720_().equals(DreadsteelItems.BRONZE_KIT.get())) {
            if (headStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_HELMET.get())) {
                tag = headStack.m_41784_();
                tag.m_128405_("CustomModelData", 3);
                headStack.m_41751_(tag);
            }
            if (chestStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_CHESTPLATE.get())) {
                tag = chestStack.m_41784_();
                tag.m_128405_("CustomModelData", 3);
                chestStack.m_41751_(tag);
            }
            if (legsStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_LEGGINGS.get())) {
                tag = legsStack.m_41784_();
                tag.m_128405_("CustomModelData", 3);
                legsStack.m_41751_(tag);
            }
            if (feetStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_BOOTS.get())) {
                tag = feetStack.m_41784_();
                tag.m_128405_("CustomModelData", 3);
                feetStack.m_41751_(tag);
            }
            if (mainStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_SCYTHE.get())) {
                tag = mainStack.m_41784_();
                tag.m_128405_("CustomModelData", 3);
                mainStack.m_41751_(tag);
            }
            if (offStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_SCYTHE.get())) {
                tag = offStack.m_41784_();
                tag.m_128405_("CustomModelData", 3);
                offStack.m_41751_(tag);
            }
            if (mainStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_SHIELD.get())) {
                tag = mainStack.m_41784_();
                tag.m_128405_("CustomModelData", 3);
                mainStack.m_41751_(tag);
            }
            if (offStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_SHIELD.get())) {
                tag = offStack.m_41784_();
                tag.m_128405_("CustomModelData", 3);
                offStack.m_41751_(tag);
            }
            if (!event.getEntity().m_7500_()) {
                event.getItemStack().m_41774_(1);
            }
            event.getEntity().m_6330_(SoundEvents.f_11675_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (event.getItemStack().m_41720_().equals(DreadsteelItems.DEFAULT_KIT.get())) {
            if (headStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_HELMET.get())) {
                headStack.m_41749_("CustomModelData");
            }
            if (chestStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_CHESTPLATE.get())) {
                chestStack.m_41749_("CustomModelData");
            }
            if (legsStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_LEGGINGS.get())) {
                legsStack.m_41749_("CustomModelData");
            }
            if (feetStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_BOOTS.get())) {
                feetStack.m_41749_("CustomModelData");
            }
            if (mainStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_SCYTHE.get())) {
                mainStack.m_41749_("CustomModelData");
            }
            if (offStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_SCYTHE.get())) {
                offStack.m_41749_("CustomModelData");
            }
            if (mainStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_SHIELD.get())) {
                mainStack.m_41749_("CustomModelData");
            }
            if (offStack.m_41720_().equals(DreadsteelItems.DREADSTEEL_SHIELD.get())) {
                offStack.m_41749_("CustomModelData");
            }
            if (!event.getEntity().m_7500_()) {
                event.getItemStack().m_41774_(1);
            }
            event.getEntity().m_6330_(SoundEvents.f_11675_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static enum MaterialDreadsteel implements ArmorMaterial
    {
        DREADSTEEL("dreadsteel", 0, new int[]{0, 0, 0, 0}, 25, SoundEvents.f_11679_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DreadsteelItems.DREADSTEEL_INGOT.get()}));

        private static final int[] MAX_DAMAGE_ARRAY;
        private final String name;
        private final int maxDamageFactor;
        private final int[] damageReductionAmountArray;
        private final int enchantability;
        private final SoundEvent soundEvent;
        private final float toughness;
        private final float knockbackResistance;
        private final Supplier<Ingredient> repairMaterial;

        private MaterialDreadsteel(String name, int maxDamageFactor, int[] damageReductionAmountArray, int enchantability, SoundEvent soundEvent, float toughness, float knockbackResistance, Supplier<Ingredient> repairMaterial) {
            this.name = name;
            this.maxDamageFactor = maxDamageFactor;
            this.damageReductionAmountArray = damageReductionAmountArray;
            this.enchantability = enchantability;
            this.soundEvent = soundEvent;
            this.toughness = toughness;
            this.knockbackResistance = knockbackResistance;
            this.repairMaterial = repairMaterial;
        }

        public int m_7366_(EquipmentSlot slotIn) {
            return MAX_DAMAGE_ARRAY[slotIn.m_20749_()] * this.maxDamageFactor;
        }

        public int m_7365_(EquipmentSlot slotIn) {
            return this.damageReductionAmountArray[slotIn.m_20749_()];
        }

        public int m_6646_() {
            return this.enchantability;
        }

        public SoundEvent m_7344_() {
            return this.soundEvent;
        }

        public Ingredient m_6230_() {
            return this.repairMaterial.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        public String m_6082_() {
            return this.name;
        }

        public float m_6651_() {
            return this.toughness;
        }

        public float m_6649_() {
            return this.knockbackResistance;
        }

        static {
            MAX_DAMAGE_ARRAY = new int[]{0, 0, 0, 0};
        }
    }
}

